/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.gui.TextView;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.querybuilder.BrowserItems;
import nickyb.sqleonardo.querybuilder.DiagramAbstractEntity;
import nickyb.sqleonardo.querybuilder.DiagramEntity;
import nickyb.sqleonardo.querybuilder.DiagramField;
import nickyb.sqleonardo.querybuilder.DiagramLayout;
import nickyb.sqleonardo.querybuilder.DiagramLoader;
import nickyb.sqleonardo.querybuilder.DiagramRelation;
import nickyb.sqleonardo.querybuilder.QueryActions;
import nickyb.sqleonardo.querybuilder.QueryModel;
import nickyb.sqleonardo.querybuilder.QueryStyledDocument;
import nickyb.sqleonardo.querybuilder.ViewBrowser;
import nickyb.sqleonardo.querybuilder.ViewDiagram;
import nickyb.sqleonardo.querybuilder.ViewObjects;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.querybuilder.syntax.SQLFormatter;
import nickyb.sqleonardo.querybuilder.syntax.SQLParser;
import nickyb.sqleonardo.querybuilder.syntax.SubQuery;

public class QueryBuilder
extends JTabbedPane
implements ChangeListener {
    private Connection connection;
    private boolean loading = false;
    public static boolean autoJoin = true;
    public static boolean autoAlias = true;
    public static boolean useAlwaysQuote = true;
    public static boolean loadObjectsAtOnce = true;
    public static boolean selectAllColumns = true;
    public static String identifierQuoteString = "\"";
    public static int maxColumnNameLength = 0;
    private DiagramLayout layout;
    private TextView syntax;
    ViewBrowser browser;
    ViewDiagram diagram;
    ViewObjects objects;

    public QueryBuilder() {
        this(null);
    }

    public QueryBuilder(Connection connection) {
        super(3);
        QueryActions.init(this);
        this.initComponents();
        this.setConnection(connection);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                BorderLayoutPanel designer = (BorderLayoutPanel)QueryBuilder.this.getComponentAt(0);
                JSplitPane split = (JSplitPane)designer.getComponent(0);
                JSplitPane split2 = (JSplitPane)split.getLeftComponent();
                split2.setDividerLocation(0.5);
                split2.validate();
            }
        });
        this.transferFocus();
    }

    private void initComponents() {
        this.browser = new ViewBrowser(this);
        this.diagram = new ViewDiagram(this);
        this.objects = new ViewObjects(this);
        JSplitPane split2 = new JSplitPane(0);
        split2.setOneTouchExpandable(true);
        split2.setDividerLocation(250);
        split2.setLeftComponent(this.browser);
        split2.setRightComponent(this.objects);
        JSplitPane split = new JSplitPane(1);
        split.setTopComponent(split2);
        split.setBottomComponent(this.diagram);
        split.setOneTouchExpandable(true);
        BorderLayoutPanel designer = new BorderLayoutPanel(2, 2);
        designer.setComponentCenter(split);
        this.add(I18n.getString("querybuilder.designer", "designer"), designer);
        this.syntax = new TextView(new QueryStyledDocument());
        this.add(I18n.getString("querybuilder.syntax", "syntax"), this.syntax);
        this.addChangeListener(this);
    }

    public boolean isDragAndDropEnabled() {
        return this.diagram.isDragAndDropEnabled();
    }

    public void setDragAndDropEnabled(boolean b) {
        this.diagram.setDragAndDropEnabled(b);
    }

    public final DiagramLayout getDiagramLayout() {
        this.layout.freeze();
        return this.layout;
    }

    public final void setDiagramLayout(DiagramLayout layout) {
        this.layout = layout;
        layout.setQueryBuilder(this);
        this.onModelChanged();
    }

    public final QueryModel getQueryModel() {
        if (this.layout == null) {
            this.layout = new DiagramLayout();
            this.layout.setQueryBuilder(this);
        }
        return this.layout.getQueryModel();
    }

    public final void setQueryModel(QueryModel qm) {
        this.layout = new DiagramLayout();
        this.layout.setQueryBuilder(this);
        this.layout.setQueryModel(qm);
        this.onModelChanged();
    }

    private void onModelChanged() {
        this.loading = true;
        this.diagram.onModelChanged();
        this.browser.onModelChanged();
        this.objects.onModelChanged();
        this.loading = false;
    }

    boolean isLoading() {
        return this.loading;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        try {
            this.connection = connection;
            if (connection != null) {
                identifierQuoteString = connection.getMetaData().getIdentifierQuoteString();
                maxColumnNameLength = connection.getMetaData().getMaxColumnNameLength();
            }
            this.objects.onConnectionChanged();
        }
        catch (SQLException sqle) {
            System.out.println("[ QueryBuilder::setConnection ]\n" + sqle);
        }
    }

    void onLoad() {
        this.loading = true;
        this.load(this.browser.getQuerySpecification().getFromClause());
        this.load(this.browser.getQuerySpecification().getSelectList());
        this.loading = false;
        this.convertJoins(this.browser.getQuerySpecification().getWhereClause());
    }

    private void load(QueryTokens._TableReference[] tokens) {
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i] instanceof QueryTokens.Table) {
                DiagramLoader.run(0, this, (QueryTokens.Table)tokens[i], false);
                continue;
            }
            this.doJoin((QueryTokens.Join)tokens[i]);
        }
        this.layout.resume();
    }

    private void load(QueryTokens._Expression[] tokens) {
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i] instanceof QueryTokens.Column) {
                DiagramField field;
                QueryTokens.Column token = (QueryTokens.Column)tokens[i];
                DiagramEntity entity = this.diagram.getEntity(token.getTable());
                if (entity == null || (field = entity.getField(token.getName())) == null) continue;
                field.setQueryToken(token);
                field.setSelected(true);
                continue;
            }
            if (!(tokens[i] instanceof QueryTokens.DefaultExpression)) continue;
            DiagramAbstractEntity[] entities = this.diagram.getEntities();
            for (int j = 0; j < entities.length; ++j) {
                DiagramEntity entity;
                DiagramField field;
                if (!(entities[j] instanceof DiagramEntity) || (field = (entity = (DiagramEntity)entities[j]).getField(tokens[i].toString())) == null) continue;
                QueryTokens.Column token = new QueryTokens.Column(entity.getQueryToken(), tokens[i].toString());
                field.setQueryToken(token);
                BrowserItems.DefaultTreeItem item = (BrowserItems.DefaultTreeItem)this.browser.getQueryItem().getChildAt(0);
                for (int k = 0; k < item.getChildCount(); ++k) {
                    BrowserItems.DefaultTreeItem child = (BrowserItems.DefaultTreeItem)item.getChildAt(k);
                    if (!child.getUserObject().toString().equalsIgnoreCase(tokens[i].toString())) continue;
                    this.browser.getQuerySpecification().setSelectList(k, token);
                    child.setUserObject(token);
                    this.browser.reload(child);
                }
            }
        }
    }

    private void convertJoins(QueryTokens.Condition[] tokens) {
        int i;
        DiagramAbstractEntity[] entities = this.diagram.getEntities();
        if (entities.length < 2) {
            return;
        }
        Hashtable<String, QueryTokens.Table> tables = new Hashtable<String, QueryTokens.Table>();
        for (i = 0; i < entities.length; ++i) {
            if (!(entities[i] instanceof DiagramEntity)) continue;
            DiagramEntity entity = (DiagramEntity)entities[i];
            QueryTokens.Table token = entity.getQueryToken();
            tables.put(SQLFormatter.stripQuote(token.getReference()), token);
        }
        for (i = 0; i < tokens.length; ++i) {
            if (tokens[i].getLeft() instanceof SubQuery || tokens[i].getRight() instanceof SubQuery) continue;
            try {
                QueryTokens.Join token;
                DiagramRelation relation;
                QueryTokens.Column left = SQLParser.doConvertColumn(tables, tokens[i].getLeft());
                QueryTokens.Column right = SQLParser.doConvertColumn(tables, tokens[i].getRight());
                if (left == null || right == null || (relation = this.doJoin(token = new QueryTokens.Join(left, tokens[i].getOperator(), right))) == null) continue;
                this.browser.removeWhereClause(tokens[i]);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private DiagramRelation doJoin(QueryTokens.Join token) {
        DiagramEntity entityF;
        DiagramRelation relation = null;
        DiagramEntity entityP = this.diagram.getEntity(token.getPrimary().getTable());
        if (entityP == null) {
            DiagramLoader.run(0, this, token.getPrimary().getTable(), false);
            entityP = this.diagram.getEntity(token.getPrimary().getTable());
        }
        if ((entityF = this.diagram.getEntity(token.getForeign().getTable())) == null) {
            DiagramLoader.run(0, this, token.getForeign().getTable(), false);
            entityF = this.diagram.getEntity(token.getForeign().getTable());
        }
        DiagramField fieldP = entityP.getField(token.getPrimary().getName());
        DiagramField fieldF = entityF.getField(token.getForeign().getName());
        if (fieldP != null && fieldF != null) {
            this.diagram.join(entityP, fieldP);
            this.diagram.join(entityF, fieldF);
            relation = this.diagram.getRelation(token);
            if (relation != null) {
                relation.setQueryToken(token);
            }
        }
        return relation;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.getActionMap().get("diagram-save-as-image").setEnabled(this.getSelectedIndex() == 0);
        this.getActionMap().get("entities-arrange").setEnabled(this.getSelectedIndex() == 0);
        this.getActionMap().get("entities-remove").setEnabled(this.getSelectedIndex() == 0);
        this.getActionMap().get("entities-pack").setEnabled(this.getSelectedIndex() == 0);
        if (this.getSelectedIndex() == 0) {
            int choice;
            String msql = this.layout.getQueryModel().toString(true);
            String tsql = this.syntax.getText();
            if (!tsql.equals(msql) && (choice = JOptionPane.showConfirmDialog(this, I18n.getString("querybuilder.syntaxChanged", "syntax changed!\ndo you want to apply changes (designer need to reload)?"))) == 0) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (!QueryBuilder.this.getComponentAt(0).isVisible()) {
                        }
                        try {
                            QueryModel qm = SQLParser.toQueryModel(QueryBuilder.this.syntax.getText());
                            qm.setSchema(QueryBuilder.this.layout.getQueryModel().getSchema());
                            QueryBuilder.this.setQueryModel(qm);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }).start();
            }
        } else {
            this.syntax.setText(this.getQueryModel().toString(true));
        }
    }
}

