/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.OPU_R25_CONTAINER;
import ca.uhn.hl7v2.model.v26.group.OPU_R25_ORDER;
import ca.uhn.hl7v2.model.v26.group.OPU_R25_SPECIMEN_OBSERVATION;
import ca.uhn.hl7v2.model.v26.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OPU_R25_SPECIMEN
extends AbstractGroup {
    public OPU_R25_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false);
            this.add(OPU_R25_SPECIMEN_OBSERVATION.class, false, true);
            this.add(OPU_R25_CONTAINER.class, false, true);
            this.add(OPU_R25_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating OPU_R25_SPECIMEN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public SPM getSPM() {
        SPM ret = null;
        try {
            ret = (SPM)this.get("SPM");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OPU_R25_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION() {
        OPU_R25_SPECIMEN_OBSERVATION ret = null;
        try {
            ret = (OPU_R25_SPECIMEN_OBSERVATION)this.get("SPECIMEN_OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OPU_R25_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION(int rep) {
        OPU_R25_SPECIMEN_OBSERVATION ret = null;
        try {
            ret = (OPU_R25_SPECIMEN_OBSERVATION)this.get("SPECIMEN_OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSPECIMEN_OBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("SPECIMEN_OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSPECIMEN_OBSERVATION(OPU_R25_SPECIMEN_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_OBSERVATION", (Structure)structure, rep);
    }

    public OPU_R25_SPECIMEN_OBSERVATION insertSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OPU_R25_SPECIMEN_OBSERVATION)super.insertRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OPU_R25_SPECIMEN_OBSERVATION removeSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OPU_R25_SPECIMEN_OBSERVATION)super.removeRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OPU_R25_CONTAINER getCONTAINER() {
        OPU_R25_CONTAINER ret = null;
        try {
            ret = (OPU_R25_CONTAINER)this.get("CONTAINER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OPU_R25_CONTAINER getCONTAINER(int rep) {
        OPU_R25_CONTAINER ret = null;
        try {
            ret = (OPU_R25_CONTAINER)this.get("CONTAINER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCONTAINERReps() {
        int reps = -1;
        try {
            reps = this.getAll("CONTAINER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCONTAINER(OPU_R25_CONTAINER structure, int rep) throws HL7Exception {
        super.insertRepetition("CONTAINER", (Structure)structure, rep);
    }

    public OPU_R25_CONTAINER insertCONTAINER(int rep) throws HL7Exception {
        return (OPU_R25_CONTAINER)super.insertRepetition("CONTAINER", rep);
    }

    public OPU_R25_CONTAINER removeCONTAINER(int rep) throws HL7Exception {
        return (OPU_R25_CONTAINER)super.removeRepetition("CONTAINER", rep);
    }

    public OPU_R25_ORDER getORDER() {
        OPU_R25_ORDER ret = null;
        try {
            ret = (OPU_R25_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OPU_R25_ORDER getORDER(int rep) {
        OPU_R25_ORDER ret = null;
        try {
            ret = (OPU_R25_ORDER)this.get("ORDER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORDER(OPU_R25_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public OPU_R25_ORDER insertORDER(int rep) throws HL7Exception {
        return (OPU_R25_ORDER)super.insertRepetition("ORDER", rep);
    }

    public OPU_R25_ORDER removeORDER(int rep) throws HL7Exception {
        return (OPU_R25_ORDER)super.removeRepetition("ORDER", rep);
    }
}

