/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.step.StepMeta;

public class CurrentDirectoryResolver {
    public VariableSpace resolveCurrentDirectory(VariableSpace parentVariables, RepositoryDirectoryInterface directory, String filename) {
        Variables tmpSpace = new Variables();
        tmpSpace.setParentVariableSpace(parentVariables);
        tmpSpace.initializeVariablesFrom(parentVariables);
        if (directory != null) {
            tmpSpace.setVariable("Internal.Entry.Current.Directory", directory.toString());
            tmpSpace.setVariable("Internal.Job.Filename.Directory", directory.toString());
            tmpSpace.setVariable("Internal.Transformation.Filename.Directory", directory.toString());
        } else if (filename != null) {
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)filename, (VariableSpace)tmpSpace);
                if (!fileObject.exists()) {
                    return tmpSpace;
                }
                FileName fileName = fileObject.getName();
                tmpSpace.setVariable("Internal.Job.Filename.Name", fileName.getBaseName());
                FileName fileDir = fileName.getParent();
                tmpSpace.setVariable("Internal.Transformation.Filename.Directory", fileDir.getURI());
                tmpSpace.setVariable("Internal.Job.Filename.Directory", fileDir.getURI());
                tmpSpace.setVariable("Internal.Entry.Current.Directory", fileDir.getURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tmpSpace;
    }

    public VariableSpace resolveCurrentDirectory(ObjectLocationSpecificationMethod specificationMethod, VariableSpace parentVariables, Repository repository, StepMeta stepMeta, String filename) {
        RepositoryDirectoryInterface directory = null;
        if (repository != null && specificationMethod.equals((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME) && stepMeta != null && stepMeta.getParentTransMeta() != null && stepMeta.getParentTransMeta().getRepositoryDirectory() != null) {
            directory = stepMeta.getParentTransMeta().getRepositoryDirectory();
        } else if (repository == null && stepMeta != null && stepMeta.getParentTransMeta() != null) {
            filename = stepMeta.getParentTransMeta().getFilename();
        } else if (stepMeta != null && stepMeta.getParentTransMeta() != null && repository != null && specificationMethod.equals((Object)ObjectLocationSpecificationMethod.FILENAME)) {
            directory = stepMeta.getParentTransMeta().getRepositoryDirectory();
        } else if (stepMeta != null && stepMeta.getParentTransMeta() != null && filename == null) {
            filename = stepMeta.getParentTransMeta().getFilename();
        }
        return this.resolveCurrentDirectory(parentVariables, directory, filename);
    }

    public VariableSpace resolveCurrentDirectory(ObjectLocationSpecificationMethod specificationMethod, VariableSpace parentVariables, Repository repository, Job job, String filename) {
        RepositoryDirectoryInterface directory = null;
        if (repository != null && specificationMethod.equals((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME) && job != null && job.getJobMeta() != null && job.getJobMeta().getRepositoryDirectory() != null) {
            directory = job.getJobMeta().getRepositoryDirectory();
        } else if (job != null && repository == null && specificationMethod.equals((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME)) {
            filename = job.getFilename();
        } else if (job != null && job.getJobMeta() != null && repository != null && specificationMethod.equals((Object)ObjectLocationSpecificationMethod.FILENAME)) {
            directory = job.getJobMeta().getRepositoryDirectory();
        } else if (job != null && filename == null) {
            filename = job.getFilename();
        } else if (repository != null && JobMeta.class.isAssignableFrom(parentVariables.getClass())) {
            JobMeta realParent = null;
            realParent = (JobMeta)parentVariables;
            if (realParent != null && realParent.getRepositoryDirectory() != null) {
                directory = realParent.getRepositoryDirectory();
            }
        } else if (JobMeta.class.isAssignableFrom(parentVariables.getClass())) {
            JobMeta realParent = null;
            realParent = (JobMeta)parentVariables;
            filename = realParent.getFilename();
        }
        return this.resolveCurrentDirectory(parentVariables, directory, filename);
    }

    public String normalizeSlashes(String str) {
        if (StringUtils.isBlank((String)str)) {
            return str;
        }
        while (str.contains("\\")) {
            str = str.replace("\\", "/");
        }
        while (str.contains("//")) {
            str = str.replace("//", "/");
        }
        return str;
    }
}

