/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.ael.adapters;

import java.util.concurrent.atomic.AtomicReference;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.events.PDIEvent;
import org.pentaho.di.engine.api.model.LogicalModelElement;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class StepDataInterfaceEngineAdapter
implements StepDataInterface {
    private AtomicReference<BaseStepData.StepExecutionStatus> stepExecutionStatus = new AtomicReference<BaseStepData.StepExecutionStatus>(BaseStepData.StepExecutionStatus.STATUS_INIT);

    StepDataInterfaceEngineAdapter(Operation op, ExecutionContext executionContext) {
        executionContext.subscribe((LogicalModelElement)op, Status.class, (Subscriber)new Subscriber<PDIEvent<Operation, Status>>(){

            public void onSubscribe(Subscription s) {
                s.request(Long.MAX_VALUE);
            }

            public void onNext(PDIEvent<Operation, Status> status) {
                switch ((Status)status.getData()) {
                    case FINISHED: {
                        StepDataInterfaceEngineAdapter.this.stepExecutionStatus.set(BaseStepData.StepExecutionStatus.STATUS_FINISHED);
                        break;
                    }
                    case FAILED: 
                    case STOPPED: {
                        StepDataInterfaceEngineAdapter.this.stepExecutionStatus.set(BaseStepData.StepExecutionStatus.STATUS_STOPPED);
                        break;
                    }
                    case PAUSED: {
                        StepDataInterfaceEngineAdapter.this.stepExecutionStatus.set(BaseStepData.StepExecutionStatus.STATUS_PAUSED);
                        break;
                    }
                    case RUNNING: {
                        StepDataInterfaceEngineAdapter.this.stepExecutionStatus.set(BaseStepData.StepExecutionStatus.STATUS_RUNNING);
                    }
                }
            }

            public void onError(Throwable t) {
            }

            public void onComplete() {
                StepDataInterfaceEngineAdapter.this.stepExecutionStatus.set(BaseStepData.StepExecutionStatus.STATUS_FINISHED);
            }
        });
    }

    @Override
    public void setStatus(BaseStepData.StepExecutionStatus stepExecutionStatus) {
        this.stepExecutionStatus.set(stepExecutionStatus);
    }

    @Override
    public BaseStepData.StepExecutionStatus getStatus() {
        return this.stepExecutionStatus.get();
    }

    @Override
    public boolean isEmpty() {
        return this.stepExecutionStatus.get() == BaseStepData.StepExecutionStatus.STATUS_EMPTY;
    }

    @Override
    public boolean isInitialising() {
        return this.stepExecutionStatus.get() == BaseStepData.StepExecutionStatus.STATUS_INIT;
    }

    @Override
    public boolean isRunning() {
        return this.stepExecutionStatus.get() == BaseStepData.StepExecutionStatus.STATUS_RUNNING;
    }

    @Override
    public boolean isIdle() {
        return this.stepExecutionStatus.get() == BaseStepData.StepExecutionStatus.STATUS_IDLE;
    }

    @Override
    public boolean isFinished() {
        return this.stepExecutionStatus.get() == BaseStepData.StepExecutionStatus.STATUS_FINISHED;
    }

    @Override
    public boolean isDisposed() {
        return this.stepExecutionStatus.get() == BaseStepData.StepExecutionStatus.STATUS_DISPOSED;
    }
}

