/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getvariable;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getvariable.GetVariable;
import org.pentaho.di.trans.steps.getvariable.GetVariableData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="GetVariable.Injection.", groups={"FIELDS"})
public class GetVariableMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = GetVariableMeta.class;
    @InjectionDeep
    private FieldDefinition[] fieldDefinitions;

    public FieldDefinition[] getFieldDefinitions() {
        return this.fieldDefinitions;
    }

    public void setFieldDefinitions(FieldDefinition[] fieldDefinitions) {
        this.fieldDefinitions = fieldDefinitions;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int count) {
        this.fieldDefinitions = new FieldDefinition[count];
        for (int i = 0; i < this.fieldDefinitions.length; ++i) {
            this.fieldDefinitions[i] = new FieldDefinition();
        }
    }

    @Override
    public Object clone() {
        GetVariableMeta retval = (GetVariableMeta)super.clone();
        int count = this.fieldDefinitions.length;
        retval.allocate(count);
        for (int i = 0; i < count; ++i) {
            retval.getFieldDefinitions()[i] = this.fieldDefinitions[i].clone();
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int count = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldDefinitions[i].setFieldName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                this.fieldDefinitions[i].setVariableString(XMLHandler.getTagValue((Node)fnode, (String)"variable"));
                this.fieldDefinitions[i].setFieldType(ValueMetaFactory.getIdForValueMeta((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
                this.fieldDefinitions[i].setFieldFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
                this.fieldDefinitions[i].setCurrency(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
                this.fieldDefinitions[i].setDecimal(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.fieldDefinitions[i].setGroup(XMLHandler.getTagValue((Node)fnode, (String)"group"));
                this.fieldDefinitions[i].setFieldLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.fieldDefinitions[i].setFieldPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                this.fieldDefinitions[i].setTrimType(ValueMetaString.getTrimTypeByCode((String)XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
                if (this.fieldDefinitions[i].getFieldType() != 0) continue;
                this.fieldDefinitions[i].setFieldType(2);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to read step information from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.fieldDefinitions[i].setFieldName("field" + i);
            this.fieldDefinitions[i].setVariableString("");
        }
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        int length = -1;
        for (int i = 0; i < this.fieldDefinitions.length; ++i) {
            String string;
            String variableString = this.fieldDefinitions[i].getVariableString();
            if (variableString == null || (string = space.environmentSubstitute(variableString)).length() <= length) continue;
            length = string.length();
        }
        RowMeta row = new RowMeta();
        for (int i = 0; i < this.fieldDefinitions.length; ++i) {
            ValueMetaInterface v;
            try {
                v = ValueMetaFactory.createValueMeta((String)this.fieldDefinitions[i].getFieldName(), (int)this.fieldDefinitions[i].getFieldType());
            }
            catch (KettlePluginException e) {
                throw new KettleStepException((Throwable)e);
            }
            int fieldLength = this.fieldDefinitions[i].getFieldLength();
            if (fieldLength < 0) {
                v.setLength(length);
            } else {
                v.setLength(fieldLength);
            }
            int fieldPrecision = this.fieldDefinitions[i].getFieldPrecision();
            if (fieldPrecision >= 0) {
                v.setPrecision(fieldPrecision);
            }
            v.setConversionMask(this.fieldDefinitions[i].getFieldFormat());
            v.setGroupingSymbol(this.fieldDefinitions[i].getGroup());
            v.setDecimalSymbol(this.fieldDefinitions[i].getDecimal());
            v.setCurrencySymbol(this.fieldDefinitions[i].getCurrency());
            v.setTrimType(this.fieldDefinitions[i].getTrimType());
            v.setOrigin(name);
            row.addValueMeta(v);
        }
        inputRowMeta.mergeRowMeta((RowMetaInterface)row, name);
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldDefinitions.length; ++i) {
            String fieldName = this.fieldDefinitions[i].getFieldName();
            if (fieldName == null || fieldName.length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)fieldName));
            retval.append("        ").append(XMLHandler.addTagValue((String)"variable", (String)this.fieldDefinitions[i].getVariableString()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)this.fieldDefinitions[i].getFieldType())));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.fieldDefinitions[i].getFieldFormat()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)this.fieldDefinitions[i].getCurrency()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.fieldDefinitions[i].getDecimal()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.fieldDefinitions[i].getGroup()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.fieldDefinitions[i].getFieldLength()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.fieldDefinitions[i].getFieldPrecision()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)ValueMetaString.getTrimTypeCode((int)this.fieldDefinitions[i].getTrimType())));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldDefinitions[i].setFieldName(rep.getStepAttributeString(id_step, i, "field_name"));
                this.fieldDefinitions[i].setVariableString(rep.getStepAttributeString(id_step, i, "field_variable"));
                this.fieldDefinitions[i].setFieldType(ValueMetaFactory.getIdForValueMeta((String)rep.getStepAttributeString(id_step, i, "field_type")));
                this.fieldDefinitions[i].setFieldFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                this.fieldDefinitions[i].setCurrency(rep.getStepAttributeString(id_step, i, "field_currency"));
                this.fieldDefinitions[i].setDecimal(rep.getStepAttributeString(id_step, i, "field_decimal"));
                this.fieldDefinitions[i].setGroup(rep.getStepAttributeString(id_step, i, "field_group"));
                this.fieldDefinitions[i].setFieldLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                this.fieldDefinitions[i].setFieldPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                this.fieldDefinitions[i].setTrimType(ValueMetaString.getTrimTypeByCode((String)rep.getStepAttributeString(id_step, i, "field_trim_type")));
                int fieldType = this.fieldDefinitions[i].getFieldType();
                if (fieldType != 0) continue;
                this.fieldDefinitions[i].setFieldType(2);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fieldDefinitions.length; ++i) {
                String fieldName = this.fieldDefinitions[i].getFieldName();
                if (fieldName == null || fieldName.length() == 0) continue;
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", fieldName);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_variable", this.fieldDefinitions[i].getVariableString());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", ValueMetaFactory.getValueMetaName((int)this.fieldDefinitions[i].getFieldType()));
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", this.fieldDefinitions[i].getFieldFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", this.fieldDefinitions[i].getCurrency());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", this.fieldDefinitions[i].getDecimal());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", this.fieldDefinitions[i].getGroup());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", this.fieldDefinitions[i].getFieldLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", this.fieldDefinitions[i].getFieldPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", ValueMetaString.getTrimTypeCode((int)this.fieldDefinitions[i].getTrimType()));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        int nrRemarks = remarks.size();
        for (int i = 0; i < this.fieldDefinitions.length; ++i) {
            if (!Utils.isEmpty((CharSequence)this.fieldDefinitions[i].getVariableString())) continue;
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetVariableMeta.CheckResult.VariableNotSpecified", (String[])new String[]{this.fieldDefinitions[i].getFieldName()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (remarks.size() == nrRemarks) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetVariableMeta.CheckResult.AllVariablesSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new GetVariable(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new GetVariableData();
    }

    public static class FieldDefinition
    implements Cloneable {
        @Injection(name="FIELDNAME", group="FIELDS")
        private String fieldName;
        @Injection(name="VARIABLE", group="FIELDS")
        private String variableString;
        @Injection(name="FIELDTYPE", group="FIELDS")
        private int fieldType;
        @Injection(name="FIELDFORMAT", group="FIELDS")
        private String fieldFormat;
        @Injection(name="FIELDLENGTH", group="FIELDS")
        private int fieldLength;
        @Injection(name="FIELDPRECISION", group="FIELDS")
        private int fieldPrecision;
        @Injection(name="CURRENCY", group="FIELDS")
        private String currency;
        @Injection(name="DECIMAL", group="FIELDS")
        private String decimal;
        @Injection(name="GROUP", group="FIELDS")
        private String group;
        @Injection(name="TRIMTYPE", group="FIELDS")
        private int trimType;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getVariableString() {
            return this.variableString;
        }

        public void setVariableString(String variableString) {
            this.variableString = variableString;
        }

        public int getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(int fieldType) {
            this.fieldType = fieldType;
        }

        public String getFieldFormat() {
            return this.fieldFormat;
        }

        public void setFieldFormat(String fieldFormat) {
            this.fieldFormat = fieldFormat;
        }

        public int getFieldLength() {
            return this.fieldLength;
        }

        public void setFieldLength(int fieldLength) {
            this.fieldLength = fieldLength;
        }

        public int getFieldPrecision() {
            return this.fieldPrecision;
        }

        public void setFieldPrecision(int fieldPrecision) {
            this.fieldPrecision = fieldPrecision;
        }

        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public String getDecimal() {
            return this.decimal;
        }

        public void setDecimal(String decimal) {
            this.decimal = decimal;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public int getTrimType() {
            return this.trimType;
        }

        public void setTrimType(int trimType) {
            this.trimType = trimType;
        }

        public FieldDefinition clone() {
            try {
                return (FieldDefinition)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

