/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapinput;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.ldapinput.LDAPInput;
import org.pentaho.di.trans.steps.ldapinput.LDAPInputData;
import org.pentaho.di.trans.steps.ldapinput.LDAPInputField;
import org.pentaho.di.trans.steps.ldapinput.LdapMeta;
import org.pentaho.di.trans.steps.ldapinput.LdapProtocolFactory;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class LDAPInputMeta
extends BaseStepMeta
implements LdapMeta {
    private static Class<?> PKG = LDAPInputMeta.class;
    private boolean useAuthentication;
    private boolean usePaging;
    private String pagesize;
    private boolean includeRowNumber;
    private String rowNumberField;
    private int rowLimit;
    private String Host;
    private String userName;
    private String password;
    private String port;
    private String filterString;
    private String searchBase;
    private LDAPInputField[] inputFields;
    private int timeLimit;
    private String multiValuedSeparator;
    private static final String YES = "Y";
    private boolean dynamicSearch;
    private String dynamicSeachFieldName;
    private boolean dynamicFilter;
    private String dynamicFilterFieldName;
    private int searchScope;
    public static final String[] searchScopeDesc = new String[]{BaseMessages.getString(PKG, (String)"LDAPInputMeta.SearchScope.Object", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LDAPInputMeta.SearchScope.OneLevel", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LDAPInputMeta.SearchScope.Subtree", (String[])new String[0])};
    public static final String[] searchScopeCode = new String[]{"object", "onelevel", "subtree"};
    private String protocol;
    private boolean useCertificate;
    private String trustStorePath;
    private String trustStorePassword;
    private boolean trustAllCertificates;

    @Override
    public boolean isUseCertificate() {
        return this.useCertificate;
    }

    public void setUseCertificate(boolean value) {
        this.useCertificate = value;
    }

    @Override
    public boolean isTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public void setTrustAllCertificates(boolean value) {
        this.trustAllCertificates = value;
    }

    @Override
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String value) {
        this.trustStorePassword = value;
    }

    @Override
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public void setTrustStorePath(String value) {
        this.trustStorePath = value;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String value) {
        this.protocol = value;
    }

    public boolean isDynamicSearch() {
        return this.dynamicSearch;
    }

    public void setDynamicSearch(boolean dynamicSearch) {
        this.dynamicSearch = dynamicSearch;
    }

    public String getDynamicSearchFieldName() {
        return this.dynamicSeachFieldName;
    }

    public void setDynamicSearchFieldName(String dynamicSeachFieldName) {
        this.dynamicSeachFieldName = dynamicSeachFieldName;
    }

    public boolean isDynamicFilter() {
        return this.dynamicFilter;
    }

    public void setDynamicFilter(boolean dynamicFilter) {
        this.dynamicFilter = dynamicFilter;
    }

    public String getDynamicFilterFieldName() {
        return this.dynamicFilterFieldName;
    }

    public void setDynamicFilterFieldName(String dynamicFilterFieldName) {
        this.dynamicFilterFieldName = dynamicFilterFieldName;
    }

    public boolean UseAuthentication() {
        return this.useAuthentication;
    }

    public void setUseAuthentication(boolean useAuthentication) {
        this.useAuthentication = useAuthentication;
    }

    public boolean isPaging() {
        return this.usePaging;
    }

    public void setPaging(boolean usePaging) {
        this.usePaging = usePaging;
    }

    public LDAPInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(LDAPInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    @Override
    public String getHost() {
        return this.Host;
    }

    public void setHost(String host) {
        this.Host = host;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setMultiValuedSeparator(String multiValuedSeparator) {
        this.multiValuedSeparator = multiValuedSeparator;
    }

    public String getMultiValuedSeparator() {
        return this.multiValuedSeparator;
    }

    public void setPageSize(String pagesize) {
        this.pagesize = pagesize;
    }

    public String getPageSize() {
        return this.pagesize;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        LDAPInputMeta retval = (LDAPInputMeta)super.clone();
        int nrFields = this.inputFields.length;
        retval.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (LDAPInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"usepaging", (boolean)this.usePaging));
        retval.append("    ").append(XMLHandler.addTagValue((String)"pagesize", (String)this.pagesize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"useauthentication", (boolean)this.useAuthentication));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"host", (String)this.Host));
        retval.append("    ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("    ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filterstring", (String)this.filterString));
        retval.append("    ").append(XMLHandler.addTagValue((String)"searchbase", (String)this.searchBase));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.inputFields.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.inputFields[i].getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"attribute", (String)this.inputFields[i].getAttribute()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"attribute_fetch_as", (String)this.inputFields[i].getFetchAttributeAsCode()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"sorted_key", (boolean)this.inputFields[i].isSortedKey()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)this.inputFields[i].getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.inputFields[i].getFormat()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.inputFields[i].getLength()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.inputFields[i].getPrecision()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)this.inputFields[i].getCurrencySymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.inputFields[i].getDecimalSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.inputFields[i].getGroupSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)this.inputFields[i].getTrimTypeCode()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"repeat", (boolean)this.inputFields[i].isRepeated()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"limit", (int)this.rowLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"timelimit", (int)this.timeLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"multivaluedseparator", (String)this.multiValuedSeparator));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dynamicsearch", (boolean)this.dynamicSearch));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dynamicseachfieldname", (String)this.dynamicSeachFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dynamicfilter", (boolean)this.dynamicFilter));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dynamicfilterfieldname", (String)this.dynamicFilterFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"searchScope", (String)LDAPInputMeta.getSearchScopeCode(this.searchScope)));
        retval.append("    ").append(XMLHandler.addTagValue((String)"protocol", (String)this.protocol));
        retval.append("    ").append(XMLHandler.addTagValue((String)"trustStorePath", (String)this.trustStorePath));
        retval.append("    ").append(XMLHandler.addTagValue((String)"trustStorePassword", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.trustStorePassword)));
        retval.append("    ").append(XMLHandler.addTagValue((String)"trustAllCertificates", (boolean)this.trustAllCertificates));
        retval.append("    ").append(XMLHandler.addTagValue((String)"useCertificate", (boolean)this.useCertificate));
        return retval.toString();
    }

    private static String getSearchScopeCode(int i) {
        if (i < 0 || i >= searchScopeCode.length) {
            return searchScopeCode[0];
        }
        return searchScopeCode[i];
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.usePaging = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"usepaging"));
            this.pagesize = XMLHandler.getTagValue((Node)stepnode, (String)"pagesize");
            this.useAuthentication = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"useauthentication"));
            this.includeRowNumber = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.Host = XMLHandler.getTagValue((Node)stepnode, (String)"host");
            this.userName = XMLHandler.getTagValue((Node)stepnode, (String)"username");
            this.setPassword(Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"password")));
            this.port = XMLHandler.getTagValue((Node)stepnode, (String)"port");
            this.filterString = XMLHandler.getTagValue((Node)stepnode, (String)"filterstring");
            this.searchBase = XMLHandler.getTagValue((Node)stepnode, (String)"searchbase");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = new LDAPInputField();
                this.inputFields[i].setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                this.inputFields[i].setAttribute(XMLHandler.getTagValue((Node)fnode, (String)"attribute"));
                this.inputFields[i].setFetchAttributeAs(LDAPInputField.getFetchAttributeAsByCode(XMLHandler.getTagValue((Node)fnode, (String)"attribute_fetch_as")));
                String sortedkey = XMLHandler.getTagValue((Node)fnode, (String)"sorted_key");
                if (sortedkey != null) {
                    this.inputFields[i].setSortedKey(YES.equalsIgnoreCase(sortedkey));
                } else {
                    this.inputFields[i].setSortedKey(false);
                }
                this.inputFields[i].setType(ValueMetaFactory.getIdForValueMeta((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
                this.inputFields[i].setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.inputFields[i].setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                String srepeat = XMLHandler.getTagValue((Node)fnode, (String)"repeat");
                if (srepeat != null) {
                    this.inputFields[i].setRepeated(YES.equalsIgnoreCase(srepeat));
                } else {
                    this.inputFields[i].setRepeated(false);
                }
                this.inputFields[i].setTrimType(ValueMetaString.getTrimTypeByCode((String)XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
                this.inputFields[i].setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
                this.inputFields[i].setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
                this.inputFields[i].setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.inputFields[i].setGroupSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
            }
            this.rowLimit = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (int)0);
            this.timeLimit = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"timelimit"), (int)0);
            this.multiValuedSeparator = XMLHandler.getTagValue((Node)stepnode, (String)"multivaluedseparator");
            this.dynamicSearch = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"dynamicsearch"));
            this.dynamicSeachFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"dynamicseachfieldname");
            this.dynamicFilter = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"dynamicfilter"));
            this.dynamicFilterFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"dynamicfilterfieldname");
            this.searchScope = LDAPInputMeta.getSearchScopeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"searchScope"), (String)LDAPInputMeta.getSearchScopeCode(2)));
            this.protocol = XMLHandler.getTagValue((Node)stepnode, (String)"protocol");
            this.trustStorePath = XMLHandler.getTagValue((Node)stepnode, (String)"trustStorePath");
            this.trustStorePassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"trustStorePassword"));
            this.trustAllCertificates = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"trustAllCertificates"));
            this.useCertificate = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"useCertificate"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"LDAPInputMeta.UnableToLoadFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    private static int getSearchScopeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < searchScopeCode.length; ++i) {
            if (!searchScopeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public void allocate(int nrfields) {
        this.inputFields = new LDAPInputField[nrfields];
    }

    @Override
    public void setDefault() {
        this.usePaging = false;
        this.pagesize = "1000";
        this.useAuthentication = false;
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.Host = "";
        this.userName = "";
        this.password = "";
        this.port = "389";
        this.filterString = "objectclass=*";
        this.searchBase = "";
        this.multiValuedSeparator = ";";
        this.dynamicSearch = false;
        this.dynamicSeachFieldName = null;
        this.dynamicFilter = false;
        this.dynamicFilterFieldName = null;
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new LDAPInputField("field" + (i + 1));
        }
        this.rowLimit = 0;
        this.timeLimit = 0;
        this.searchScope = 2;
        this.trustStorePath = null;
        this.trustStorePassword = null;
        this.trustAllCertificates = false;
        this.protocol = LdapProtocolFactory.getConnectionTypes(this.log).get(0);
        this.useCertificate = false;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        for (int i = 0; i < this.inputFields.length; ++i) {
            LDAPInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            try {
                ValueMetaInterface v = ValueMetaFactory.createValueMeta((String)space.environmentSubstitute(field.getName()), (int)type);
                v.setLength(field.getLength(), field.getPrecision());
                v.setOrigin(name);
                r.addValueMeta(v);
                continue;
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        if (this.includeRowNumber) {
            ValueMetaInteger v = new ValueMetaInteger(space.environmentSubstitute(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.usePaging = rep.getStepAttributeBoolean(id_step, "usepaging");
            this.pagesize = rep.getStepAttributeString(id_step, "pagesize");
            this.useAuthentication = rep.getStepAttributeBoolean(id_step, "useauthentication");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.Host = rep.getStepAttributeString(id_step, "host");
            this.userName = rep.getStepAttributeString(id_step, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "password"));
            this.port = rep.getStepAttributeString(id_step, "port");
            this.filterString = rep.getStepAttributeString(id_step, "filterstring");
            this.searchBase = rep.getStepAttributeString(id_step, "searchbase");
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "limit");
            this.timeLimit = (int)rep.getStepAttributeInteger(id_step, "timelimit");
            this.multiValuedSeparator = rep.getStepAttributeString(id_step, "multivaluedseparator");
            this.dynamicSearch = rep.getStepAttributeBoolean(id_step, "dynamicsearch");
            this.dynamicSeachFieldName = rep.getStepAttributeString(id_step, "dynamicseachfieldname");
            this.dynamicFilter = rep.getStepAttributeBoolean(id_step, "dynamicfilter");
            this.dynamicFilterFieldName = rep.getStepAttributeString(id_step, "dynamicfilterfieldname");
            this.protocol = rep.getStepAttributeString(id_step, "protocol");
            this.trustStorePath = rep.getStepAttributeString(id_step, "trustStorePath");
            this.trustStorePassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "trustStorePassword"));
            this.trustAllCertificates = rep.getStepAttributeBoolean(id_step, "trustAllCertificates");
            this.useCertificate = rep.getStepAttributeBoolean(id_step, "useCertificate");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                LDAPInputField field = new LDAPInputField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setAttribute(rep.getStepAttributeString(id_step, i, "field_attribute"));
                field.setFetchAttributeAs(LDAPInputField.getFetchAttributeAsByCode(rep.getStepAttributeString(id_step, i, "field_attribute_fetch_as")));
                field.setSortedKey(rep.getStepAttributeBoolean(id_step, i, "sorted_key"));
                field.setType(ValueMetaFactory.getIdForValueMeta((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(LDAPInputField.getTrimTypeByCode(rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                this.inputFields[i] = field;
            }
            this.searchScope = LDAPInputMeta.getSearchScopeByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "searchScope"), (String)LDAPInputMeta.getSearchScopeCode(2)));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPInputMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    public static String getSearchScopeDesc(int i) {
        if (i < 0 || i >= searchScopeDesc.length) {
            return searchScopeDesc[0];
        }
        return searchScopeDesc[i];
    }

    public static int getSearchScopeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < searchScopeDesc.length; ++i) {
            if (!searchScopeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return LDAPInputMeta.getSearchScopeByCode(tt);
    }

    public void setSearchScope(int value) {
        this.searchScope = value;
    }

    public int getSearchScope() {
        return this.searchScope;
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "usepaging", this.usePaging);
            rep.saveStepAttribute(id_transformation, id_step, "pagesize", this.pagesize);
            rep.saveStepAttribute(id_transformation, id_step, "useauthentication", this.useAuthentication);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "host", this.Host);
            rep.saveStepAttribute(id_transformation, id_step, "username", this.userName);
            rep.saveStepAttribute(id_transformation, id_step, "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveStepAttribute(id_transformation, id_step, "port", this.port);
            rep.saveStepAttribute(id_transformation, id_step, "filterstring", this.filterString);
            rep.saveStepAttribute(id_transformation, id_step, "searchbase", this.searchBase);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "timelimit", this.timeLimit);
            rep.saveStepAttribute(id_transformation, id_step, "multivaluedseparator", this.multiValuedSeparator);
            rep.saveStepAttribute(id_transformation, id_step, "dynamicsearch", this.dynamicSearch);
            rep.saveStepAttribute(id_transformation, id_step, "dynamicseachfieldname", this.dynamicSeachFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "dynamicfilter", this.dynamicFilter);
            rep.saveStepAttribute(id_transformation, id_step, "dynamicfilterfieldname", this.dynamicFilterFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "protocol", this.protocol);
            rep.saveStepAttribute(id_transformation, id_step, "trustStorePath", this.trustStorePath);
            rep.saveStepAttribute(id_transformation, id_step, "trustStorePassword", Encr.encryptPasswordIfNotUsingVariables((String)this.trustStorePassword));
            rep.saveStepAttribute(id_transformation, id_step, "trustAllCertificates", this.trustAllCertificates);
            rep.saveStepAttribute(id_transformation, id_step, "useCertificate", this.useCertificate);
            for (int i = 0; i < this.inputFields.length; ++i) {
                LDAPInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_attribute", field.getAttribute());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_attribute_fetch_as", field.getFetchAttributeAsCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "sorted_key", field.isSortedKey());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_repeat", field.isRepeated());
            }
            rep.saveStepAttribute(id_transformation, id_step, "searchScope", LDAPInputMeta.getSearchScopeCode(this.searchScope));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LDAPInputMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr = this.inputFields.length == 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LDAPInputMeta.CheckResult.NoOutputFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LDAPInputMeta.CheckResult.OutputFieldsOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LDAPInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LDAPInputMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Utils.isEmpty((CharSequence)this.Host) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LDAPInputMeta.CheckResult.HostnameMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LDAPInputMeta.CheckResult.HostnameOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        if (this.isDynamicSearch()) {
            cr = Utils.isEmpty((CharSequence)this.dynamicSeachFieldName) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LDAPInputMeta.CheckResult.DynamicSearchBaseFieldNameMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LDAPInputMeta.CheckResult.DynamicSearchBaseFieldNameOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = Utils.isEmpty((CharSequence)this.searchBase) ? new CheckResult(3, BaseMessages.getString(PKG, (String)"LDAPInputMeta.CheckResult.SearchBaseMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LDAPInputMeta.CheckResult.SearchBaseOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.isDynamicFilter()) {
            cr = Utils.isEmpty((CharSequence)this.dynamicFilterFieldName) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LDAPInputMeta.CheckResult.DynamicFilterFieldNameMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LDAPInputMeta.CheckResult.DynamicFilterFieldNameOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = Utils.isEmpty((CharSequence)this.filterString) ? new CheckResult(3, BaseMessages.getString(PKG, (String)"LDAPInputMeta.CheckResult.FilterStringMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LDAPInputMeta.CheckResult.FilterStringOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new LDAPInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new LDAPInputData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public String toString() {
        return "LDAPConnection " + this.getName();
    }

    @Override
    public String getDerefAliases() {
        return "always";
    }

    @Override
    public String getReferrals() {
        return "follow";
    }
}

