/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.di.www.SlaveServerJobStatus;
import org.pentaho.di.www.SlaveServerStatus;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.pentaho.di.www.StatusServletUtils;
import org.pentaho.di.www.TransformationMap;

public class GetStatusServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static Class<?> PKG = GetStatusServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/status";

    public GetStatusServlet() {
    }

    public GetStatusServlet(TransformationMap transformationMap, JobMap jobMap) {
        super(transformationMap, jobMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GetStatusServlet.StatusRequested", (String[])new String[0]));
        }
        response.setStatus(200);
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        boolean useLightTheme = "Y".equalsIgnoreCase(request.getParameter("useLightTheme"));
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setContentType("text/html;charset=UTF-8");
        }
        PrintWriter out = response.getWriter();
        List<CarteObjectEntry> transEntries = this.getTransformationMap().getTransformationObjects();
        List<CarteObjectEntry> jobEntries = this.getJobMap().getJobObjects();
        if (useXML) {
            String status;
            out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
            SlaveServerStatus serverStatus = new SlaveServerStatus();
            serverStatus.setStatusDescription("Online");
            GetStatusServlet.getSystemInfo(serverStatus);
            for (CarteObjectEntry entry : transEntries) {
                Trans trans = this.getTransformationMap().getTransformation(entry);
                status = trans.getStatus();
                SlaveServerTransStatus sstatus = new SlaveServerTransStatus(entry.getName(), entry.getId(), status);
                sstatus.setLogDate(trans.getLogDate());
                sstatus.setPaused(trans.isPaused());
                serverStatus.getTransStatusList().add(sstatus);
            }
            for (CarteObjectEntry entry : jobEntries) {
                Job job = this.getJobMap().getJob(entry);
                status = job.getStatus();
                SlaveServerJobStatus jobStatus = new SlaveServerJobStatus(entry.getName(), entry.getId(), status);
                jobStatus.setLogDate(job.getLogDate());
                serverStatus.getJobStatusList().add(jobStatus);
            }
            try {
                out.println(serverStatus.getXML());
            }
            catch (KettleException e) {
                throw new ServletException("Unable to get the server status in XML format", (Throwable)e);
            }
        }
        out.println("<HTML>");
        out.println("<HEAD><TITLE>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.KettleSlaveServerStatus", (String[])new String[0]) + "</TITLE>");
        out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        int tableBorder = 1;
        if (!useLightTheme) {
            out.print(StatusServletUtils.getPentahoStyles());
            tableBorder = 0;
        }
        out.println("<style>");
        out.println(".pentaho-table td, tr.cellTableRow, td.gwt-MenuItem {");
        out.println("  cursor: pointer;");
        out.println("}");
        out.println("</style>");
        out.println("</HEAD>");
        out.println("<BODY class=\"pentaho-page-background dragdrop-dropTarget dragdrop-boundary\" style=\"overflow: auto;\">");
        out.println("<div id=\"selectedTableItem\">");
        out.println("<value></value>");
        out.println("</div>");
        out.println("<div class=\"row\" id=\"pucHeader\">");
        String htmlClass = useLightTheme ? "h1" : "div";
        out.println("<" + htmlClass + " class=\"workspaceHeading\" style=\"padding: 0px 0px 0px 10px;\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TopStatus", (String[])new String[0]) + "</" + htmlClass + ">");
        out.println("</div>");
        try {
            String run = BaseMessages.getString(PKG, (String)"CarteStatusServlet.Run", (String[])new String[0]);
            String stop = BaseMessages.getString(PKG, (String)"CarteStatusServlet.StopTrans", (String[])new String[0]);
            String cleanup = BaseMessages.getString(PKG, (String)"CarteStatusServlet.CleanupTrans", (String[])new String[0]);
            String view = BaseMessages.getString(PKG, (String)"CarteStatusServlet.ViewTransDetails", (String[])new String[0]);
            String remove = BaseMessages.getString(PKG, (String)"CarteStatusServlet.RemoveTrans", (String[])new String[0]);
            out.println("<div class=\"row\" style=\"padding: 0px 0px 0px 30px\">");
            htmlClass = useLightTheme ? "h2" : "div";
            out.println("<div class=\"row\" style=\"padding: 25px 30px 75px 0px;\">");
            out.println("<" + htmlClass + " class=\"workspaceHeading\" style=\"padding: 0px 0px 0px 0px;\">Transformations</" + htmlClass + ">");
            out.println("<table id=\"trans-table\" cellspacing=\"0\" cellpadding=\"0\"><tbody><tr><td align=\"left\" width=\"100%\" style=\"vertical-align:middle;\">");
            out.println("<table cellspacing=\"0\" cellpadding=\"0\" class=\"toolbar\" style=\"width: 100%; height: 26px; margin-bottom: 2px; border: 0;\">");
            out.println("<tbody><tr>");
            out.println("<td align=\"left\" style=\"vertical-align: middle; width: 100%\" id=\"trans-align\"></td>");
            out.println("<td onMouseEnter=\"document.getElementById( 'pause' ).className='toolbar-button toolbar-button-hovering'\" onMouseLeave=\"document.getElementById( 'pause' ).className='toolbar-button'\" align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px;\" onClick=\"resumeFunction( this )\" class=\"toolbar-button\" id=\"pause\"><img style=\"width: 22px; height: 22px\" src=\"/pentaho/content/common-ui/resources/themes/images/run_options.svg\" title=\"" + run + "\"/></div></td>");
            out.println("<td onMouseEnter=\"document.getElementById( 'stop' ).className='toolbar-button toolbar-button-hovering'\" onMouseLeave=\"document.getElementById( 'stop' ).className='toolbar-button'\" align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px;\" onClick=\"stopFunction( this )\" class=\"toolbar-button\" id=\"stop\"><img style=\"width: 22px; height: 22px\"src=\"/pentaho/content/common-ui/resources/themes/images/stop.svg\" title=\"" + stop + "\"/></div></td>");
            out.println("<td onMouseEnter=\"document.getElementById( 'cleanup-trans' ).className='toolbar-button toolbar-button-hovering'\" onMouseLeave=\"document.getElementById( 'cleanup-trans' ).className='toolbar-button'\" align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px; margin-left: 10px !important;\" onClick=\"cleanupFunction( this )\" class=\"toolbar-button\" id=\"cleanup-trans\"><img style=\"width: 22px; height: 22px\"src=\"/pentaho/content/common-ui/resources/themes/images/cleanup.svg\" title=\"" + cleanup + "\"/></div></td>");
            out.println("<td onMouseEnter=\"document.getElementById( 'view' ).className='toolbar-button toolbar-button-hovering'\" onMouseLeave=\"document.getElementById( 'view' ).className='toolbar-button'\" align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px; margin-left: 0 !important;\" onClick=\"viewFunction( this )\" class=\"toolbar-button\" id=\"view\"><img style=\"width: 22px; height: 22px\" src=\"/pentaho/content/common-ui/resources/themes/images/view.svg\" title=\"" + view + "\"/></div></td>");
            out.println("<td onMouseEnter=\"document.getElementById( 'close' ).className='toolbar-button toolbar-button-hovering'\" onMouseLeave=\"document.getElementById( 'close' ).className='toolbar-button'\" align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px; margin-right: 10px;\" onClick=\"removeFunction( this )\" class=\"toolbar-button\" id=\"close\"><img style=\"width: 22px; height: 22px\" src=\"/pentaho/content/common-ui/resources/themes/images/close.svg\" title=\"" + remove + "\"/></div></td>");
            out.println("</tr></tbody></table>");
            out.println("<div id=\"runActions\" class=\"custom-dropdown-popup\" style=\"visibility: hidden; overflow: visible; position: fixed;\" onLoad=\"repositionActions( this, document.getElementById( 'pause' ) )\" onMouseLeave=\"this.style='visibility: hidden; overflow: visible; position: fixed;'\"><div class=\"popupContent\"><div style=\"padding: 0;\" class=\"gwt-MenuBar gwt-MenuBar-vertical\"><table><tbody><tr><td class=\"gwt-MenuItem\" onClick=\"runTransSelector( this )\" onMouseEnter=\"this.className='gwt-MenuItem gwt-MenuItem-selected'\" onMouseLeave=\"this.className='gwt-MenuItem'\">Prepare the execution</td></tr><tr><td class=\"gwt-MenuItem\" onClick=\"runTransSelector( this )\" onMouseEnter=\"this.className='gwt-MenuItem gwt-MenuItem-selected'\" onMouseLeave=\"this.className='gwt-MenuItem'\">Run</td></tr></tbody></table></div></div></div>");
            out.println("<div id=\"stopActions\" class=\"custom-dropdown-popup\" style=\"visibility: hidden; overflow: visible; position: fixed;\" onLoad=\"repositionActions( this, document.getElementById( 'stop' ) )\" onMouseLeave=\"this.style='visibility: hidden; overflow: visible; position: fixed;'\"><div class=\"popupContent\"><div style=\"padding: 0;\" class=\"gwt-MenuBar gwt-MenuBar-vertical\"><table><tbody><tr><td class=\"gwt-MenuItem\" onClick=\"stopTransSelector( this )\" onMouseEnter=\"this.className='gwt-MenuItem gwt-MenuItem-selected'\" onMouseLeave=\"this.className='gwt-MenuItem'\">Stop transformation</td></tr><tr><td class=\"gwt-MenuItem\" onClick=\"stopTransSelector( this )\" onMouseEnter=\"this.className='gwt-MenuItem gwt-MenuItem-selected'\" onMouseLeave=\"this.className='gwt-MenuItem'\">Stop input processing</td></tr></tbody></table></div></div></div>");
            out.println("<table class=\"pentaho-table\" border=\"" + tableBorder + "\">");
            out.print("<tr> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.TransName", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.CarteId", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Status", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.LastLogDate", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.LastLogTime", (String[])new String[0]) + "</th> </tr>");
            Comparator<CarteObjectEntry> transComparator = new Comparator<CarteObjectEntry>(){

                @Override
                public int compare(CarteObjectEntry o1, CarteObjectEntry o2) {
                    int logDateCompare;
                    Trans t1 = GetStatusServlet.this.getTransformationMap().getTransformation(o1);
                    Trans t2 = GetStatusServlet.this.getTransformationMap().getTransformation(o2);
                    Date d1 = t1.getLogDate();
                    Date d2 = t2.getLogDate();
                    if (d1 != null && d2 != null && (logDateCompare = d2.compareTo(d1)) != 0) {
                        return logDateCompare;
                    }
                    return o1.compareTo(o2);
                }
            };
            Collections.sort(transEntries, transComparator);
            boolean evenRow = true;
            for (int i = 0; i < transEntries.size(); ++i) {
                String name = transEntries.get(i).getName();
                String id = transEntries.get(i).getId();
                Trans trans = this.getTransformationMap().getTransformation(transEntries.get(i));
                String status = trans.getStatus();
                String trClass = evenRow ? "cellTableEvenRow" : "cellTableOddRow";
                String tdClass = evenRow ? "cellTableEvenRowCell" : "cellTableOddRowCell";
                evenRow = !evenRow;
                String firstColumn = i == 0 ? "cellTableFirstColumn" : "";
                String lastColumn = i == transEntries.size() - 1 ? "cellTableLastColumn" : "";
                out.print("<tr onMouseEnter=\"mouseEnterFunction( this, '" + trClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + trClass + "' )\" onClick=\"clickFunction( this, '" + trClass + "' )\" id=\"cellTableRow" + i + "\" class=\"" + trClass + "\">");
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"cellTableFirstCell" + i + "\" class=\"cellTableCell cellTableFirstColumn " + tdClass + "\">" + name + "</td>");
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"cellTableCell" + i + "\" class=\"cellTableCell " + tdClass + "\">" + id + "</td>");
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"cellTableCellStatus" + i + "\" class=\"cellTableCell " + tdClass + "\">" + status + "</td>");
                String dateStr = XMLHandler.date2string((Date)trans.getLogDate());
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"cellTableCell" + i + "\" class=\"cellTableCell " + tdClass + "\">" + (trans.getLogDate() == null ? "-" : dateStr.substring(0, dateStr.indexOf(32))) + "</td>");
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"cellTableLastCell" + i + "\" class=\"cellTableCell cellTableLastColumn " + tdClass + "\">" + dateStr.substring(dateStr.indexOf(32), dateStr.length()) + "</td>");
                out.print("</tr>");
            }
            out.print("</table></table>");
            out.print("</div>");
            String runJ = BaseMessages.getString(PKG, (String)"CarteStatusServlet.Run", (String[])new String[0]);
            String stopJ = BaseMessages.getString(PKG, (String)"CarteStatusServlet.StopJob", (String[])new String[0]);
            String viewJ = BaseMessages.getString(PKG, (String)"CarteStatusServlet.ViewJobDetails", (String[])new String[0]);
            String removeJ = BaseMessages.getString(PKG, (String)"CarteStatusServlet.RemoveJob", (String[])new String[0]);
            out.println("<div class=\"row\" style=\"padding: 0px 30px 75px 0px;\">");
            out.println("<" + htmlClass + " class=\"workspaceHeading\" style=\"padding: 0px 0px 0px 0px;\">Jobs</" + htmlClass + ">");
            out.println("<table cellspacing=\"0\" cellpadding=\"0\"><tbody><tr><td align=\"left\" width=\"100%\" style=\"vertical-align:middle;\">");
            out.println("<table cellspacing=\"0\" cellpadding=\"0\" class=\"toolbar\" style=\"width: 100%; height: 26px; margin-bottom: 2px; border: 0;\">");
            out.println("<tbody><tr>");
            out.println("<td align=\"left\" style=\"vertical-align: middle; width: 100%\"></td>");
            out.println("<td onMouseEnter=\"document.getElementById( 'j-pause' ).className='toolbar-button toolbar-button-hovering'\" onMouseLeave=\"document.getElementById( 'j-pause' ).className='toolbar-button'\" align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px;\" onClick=\"resumeFunction( this )\" class=\"toolbar-button\" id=\"j-pause\"><img style=\"width: 22px; height: 22px\" src=\"/pentaho/content/common-ui/resources/themes/images/run.svg\" title=\"" + runJ + "\"/></div></td>");
            out.println("<td onMouseEnter=\"document.getElementById( 'j-stop' ).className='toolbar-button toolbar-button-hovering'\" onMouseLeave=\"document.getElementById( 'j-stop' ).className='toolbar-button'\" align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px;\" onClick=\"stopFunction( this )\" class=\"toolbar-button\" id=\"j-stop\"><img style=\"width: 22px; height: 22px\"src=\"/pentaho/content/common-ui/resources/themes/images/stop.svg\" title=\"" + stopJ + "\"/></div></td>");
            out.println("<td onMouseEnter=\"document.getElementById( 'j-view' ).className='toolbar-button toolbar-button-hovering'\" onMouseLeave=\"document.getElementById( 'j-view' ).className='toolbar-button'\" align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px;\" onClick=\"viewFunction( this )\" class=\"toolbar-button\" id=\"j-view\"><img style=\"width: 22px; height: 22px\" src=\"/pentaho/content/common-ui/resources/themes/images/view.svg\" title=\"" + viewJ + "\"/></div></td>");
            out.println("<td onMouseEnter=\"document.getElementById( 'j-close' ).className='toolbar-button toolbar-button-hovering'\" onMouseLeave=\"document.getElementById( 'j-close' ).className='toolbar-button'\" align=\"left\" style=\"vertical-align: middle;\"><div style=\"padding: 2px; margin-right: 10px;\" onClick=\"removeFunction( this )\" class=\"toolbar-button\" id=\"j-close\"><img style=\"width: 22px; height: 22px\" src=\"/pentaho/content/common-ui/resources/themes/images/close.svg\" title=\"" + removeJ + "\"/></div></td>");
            out.println("</tr></tbody></table>");
            out.println("<table class=\"pentaho-table\" border=\"" + tableBorder + "\">");
            out.print("<tr> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.JobName", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.CarteId", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Status", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.LastLogDate", (String[])new String[0]) + "</th> <th class=\"cellTableHeader\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.LastLogTime", (String[])new String[0]) + "</th> </tr>");
            Comparator<CarteObjectEntry> jobComparator = new Comparator<CarteObjectEntry>(){

                @Override
                public int compare(CarteObjectEntry o1, CarteObjectEntry o2) {
                    int logDateCompare;
                    Job t1 = GetStatusServlet.this.getJobMap().getJob(o1);
                    Job t2 = GetStatusServlet.this.getJobMap().getJob(o2);
                    Date d1 = t1.getLogDate();
                    Date d2 = t2.getLogDate();
                    if (d1 != null && d2 != null && (logDateCompare = d2.compareTo(d1)) != 0) {
                        return logDateCompare;
                    }
                    return o1.compareTo(o2);
                }
            };
            Collections.sort(jobEntries, jobComparator);
            evenRow = true;
            for (int i = 0; i < jobEntries.size(); ++i) {
                String name = jobEntries.get(i).getName();
                String id = jobEntries.get(i).getId();
                Job job = this.getJobMap().getJob(jobEntries.get(i));
                String status = job.getStatus();
                String trClass = evenRow ? "cellTableEvenRow" : "cellTableOddRow";
                String tdClass = evenRow ? "cellTableEvenRowCell" : "cellTableOddRowCell";
                evenRow = !evenRow;
                out.print("<tr onMouseEnter=\"mouseEnterFunction( this, '" + trClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + trClass + "' )\" onClick=\"clickFunction( this, '" + trClass + "' )\" id=\"j-cellTableRow" + i + "\" class=\"cellTableCell " + trClass + "\">");
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"j-cellTableFirstCell" + i + "\" class=\"cellTableCell cellTableFirstColumn " + tdClass + "\">" + name + "</a></td>");
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"j-cellTableCell" + i + "\" class=\"cellTableCell " + tdClass + "\">" + id + "</td>");
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"j-cellTableCell" + i + "\" class=\"cellTableCell " + tdClass + "\">" + status + "</td>");
                String dateStr = XMLHandler.date2string((Date)job.getLogDate());
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"j-cellTableCell" + i + "\" class=\"cellTableCell " + tdClass + "\">" + (job.getLogDate() == null ? "-" : dateStr.substring(0, dateStr.indexOf(32))) + "</td>");
                out.print("<td onMouseEnter=\"mouseEnterFunction( this, '" + tdClass + "' )\" onMouseLeave=\"mouseLeaveFunction( this, '" + tdClass + "' )\" onClick=\"clickFunction( this, '" + tdClass + "' )\" id=\"j-cellTableLastCell" + i + "\" class=\"cellTableCell cellTableLastColumn " + tdClass + "\">" + dateStr.substring(dateStr.indexOf(32), dateStr.length()) + "</td>");
                out.print("</tr>");
            }
            out.print("</table></table>");
            out.print("</div>");
        }
        catch (Exception ex) {
            out.println("<pre>");
            ex.printStackTrace(out);
            out.println("</pre>");
        }
        out.println("<div class=\"row\" style=\"padding: 0px 0px 30px 0px;\">");
        htmlClass = useLightTheme ? "h3" : "div";
        out.println("<div><" + htmlClass + " class=\"workspaceHeading\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ConfigurationDetails.Title", (String[])new String[0]) + "</" + htmlClass + "></div>");
        out.println("<table border=\"" + tableBorder + "\">");
        SlaveServerConfig serverConfig = this.getTransformationMap().getSlaveServerConfig();
        if (serverConfig != null) {
            String repositoryName;
            String maxLines = "";
            maxLines = serverConfig.getMaxLogLines() == 0 ? BaseMessages.getString(PKG, (String)"GetStatusServlet.NoLimit", (String[])new String[0]) : serverConfig.getMaxLogLines() + BaseMessages.getString(PKG, (String)"GetStatusServlet.Lines", (String[])new String[0]);
            out.print("<tr style=\"font-size: 12;\"> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableFirstColumn\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.MaxLogLines", (String[])new String[0]) + "</td> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableLastColumn\">" + maxLines + "</td> </tr>");
            String maxAge = "";
            maxAge = serverConfig.getMaxLogTimeoutMinutes() == 0 ? BaseMessages.getString(PKG, (String)"GetStatusServlet.NoLimit", (String[])new String[0]) : serverConfig.getMaxLogTimeoutMinutes() + BaseMessages.getString(PKG, (String)"GetStatusServlet.Minutes", (String[])new String[0]);
            out.print("<tr style=\"font-size: 12;\"> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableFirstColumn\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.MaxLogLinesAge", (String[])new String[0]) + "</td> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableLastColumn\">" + maxAge + "</td> </tr>");
            String maxObjAge = "";
            maxObjAge = serverConfig.getObjectTimeoutMinutes() == 0 ? BaseMessages.getString(PKG, (String)"GetStatusServlet.NoLimit", (String[])new String[0]) : serverConfig.getObjectTimeoutMinutes() + BaseMessages.getString(PKG, (String)"GetStatusServlet.Minutes", (String[])new String[0]);
            out.print("<tr style=\"font-size: 12;\"> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableFirstColumn\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.MaxObjectsAge", (String[])new String[0]) + "</td> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableLastColumn\">" + maxObjAge + "</td> </tr>");
            try {
                repositoryName = serverConfig.getRepository() != null ? serverConfig.getRepository().getName() : "";
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.RepositoryName.UnableToConnect", (String[])new String[]{serverConfig.getRepositoryId()}), e);
                repositoryName = BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.RepositoryName.UnableToConnect", (String[])new String[]{serverConfig.getRepositoryId()});
            }
            out.print("<tr style=\"font-size: 12;\"> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableFirstColumn\">" + BaseMessages.getString(PKG, (String)"GetStatusServlet.Parameter.RepositoryName", (String[])new String[0]) + "</td> <td style=\"padding: 2px 10px 2px 10px\" class=\"cellTableCell cellTableEvenRowCell cellTableLastColumn\">" + repositoryName + "</td> </tr>");
            out.print("</table>");
            String filename = serverConfig.getFilename();
            if (filename == null) {
                filename = BaseMessages.getString(PKG, (String)"GetStatusServlet.ConfigurationDetails.UsingDefaults", (String[])new String[0]);
            }
            out.println("</div>");
            out.print("<div class=\"row\">");
            out.println("<i>" + BaseMessages.getString(PKG, (String)"GetStatusServlet.ConfigurationDetails.Advice", (String[])new String[]{filename}) + "</i>");
            out.print("</div>");
            out.print("</div>");
            out.print("</div>");
        }
        out.println("<script type=\"text/javascript\">");
        out.println("if (!String.prototype.endsWith) {");
        out.println("  String.prototype.endsWith = function(suffix) {");
        out.println("    return this.indexOf(suffix, this.length - suffix.length) !== -1;");
        out.println("  };");
        out.println("}");
        out.println("if (!String.prototype.startsWith) {");
        out.println("  String.prototype.startsWith = function(searchString, position) {");
        out.println("    position = position || 0;");
        out.println("    return this.indexOf(searchString, position) === position;");
        out.println("  };");
        out.println("}");
        out.println("var selectedTransRowIndex = -1;");
        out.println("var selectedJobRowIndex = -1;");
        out.println("function repositionActions( element, elementFrom ) {");
        out.println("element.style.left = ( 10 + elementFrom.getBoundingClientRect().left ) + 'px';");
        out.println("}");
        out.println("function resumeFunction( element ) {");
        out.println("if( element.id.startsWith( 'j-' ) && selectedJobRowIndex != -1 ) {");
        out.println("window.location.replace( '" + this.convertContextPath("/kettle/startJob") + "' + '?name=' + document.getElementById( 'j-cellTableFirstCell' + selectedJobRowIndex ).innerHTML + '&id=' + document.getElementById( 'j-cellTableCell' + selectedJobRowIndex ).innerHTML );");
        out.println("} else if ( !element.id.startsWith( 'j-' ) && selectedTransRowIndex != -1 && document.getElementById( 'cellTableCellStatus' + selectedTransRowIndex ).innerHTML == 'Running') {");
        out.println("window.location.replace( '" + this.convertContextPath("/kettle/pauseTrans") + "' + '?name=' + document.getElementById( 'cellTableFirstCell' + selectedTransRowIndex ).innerHTML + '&id=' + document.getElementById( 'cellTableCell' + selectedTransRowIndex ).innerHTML );");
        out.println("} else if( !element.id.startsWith( 'j-' ) && selectedTransRowIndex != -1 ){");
        out.println("repositionActions( document.getElementById( 'runActions' ), element );");
        out.println("document.getElementById( 'runActions' ).style.visibility = 'visible';");
        out.println("}");
        out.println("}");
        out.println("function stopFunction( element ) {");
        out.println("if( element.id.startsWith( 'j-' ) && selectedJobRowIndex != -1 ) {");
        out.println("window.location.replace( '" + this.convertContextPath("/kettle/stopJob") + "' + '?name=' + document.getElementById( 'j-cellTableFirstCell' + selectedJobRowIndex ).innerHTML + '&id=' + document.getElementById( 'j-cellTableCell' + selectedJobRowIndex ).innerHTML );");
        out.println("} else if ( !element.id.startsWith( 'j-' ) && selectedTransRowIndex != -1 ) {");
        out.println("repositionActions( document.getElementById( 'stopActions' ), element );");
        out.println("document.getElementById( 'stopActions' ).style.visibility = 'visible';");
        out.println("}");
        out.println("}");
        out.println("function runTransSelector( element ) {");
        out.println("if( element.innerHTML == 'Prepare the execution' ){");
        out.println("window.location.replace( '" + this.convertContextPath("/kettle/prepareExec") + "' + '?name=' + document.getElementById( 'cellTableFirstCell' + selectedTransRowIndex ).innerHTML + '&id=' + document.getElementById( 'cellTableCell' + selectedTransRowIndex ).innerHTML );");
        out.println("} else {");
        out.println("window.location.replace( '" + this.convertContextPath("/kettle/startTrans") + "' + '?name=' + document.getElementById( 'cellTableFirstCell' + selectedTransRowIndex ).innerHTML + '&id=' + document.getElementById( 'cellTableCell' + selectedTransRowIndex ).innerHTML );");
        out.println("}");
        out.println("}");
        out.println("function stopTransSelector( element ) {");
        out.println("if( element.innerHTML == 'Stop transformation' ) {");
        out.println("window.location.replace( '" + this.convertContextPath("/kettle/stopTrans") + "' + '?name=' + document.getElementById( 'cellTableFirstCell' + selectedTransRowIndex ).innerHTML + '&id=' + document.getElementById( 'cellTableCell' + selectedTransRowIndex ).innerHTML );");
        out.println("} else if( element.innerHTML == 'Stop input processing' ) {");
        out.println("window.location.replace( '" + this.convertContextPath("/kettle/stopTrans") + "' + '?name=' + document.getElementById( 'cellTableFirstCell' + selectedTransRowIndex ).innerHTML + '&id=' + document.getElementById( 'cellTableCell' + selectedTransRowIndex ).innerHTML + '&inputOnly=Y' );");
        out.println("}");
        out.println("document.getElementById( 'stopActions' ).style.visibility = 'hidden';");
        out.println("}");
        out.println("function cleanupFunction( element ) {");
        out.println("if( selectedTransRowIndex != -1 ) {");
        out.println("window.location.replace( '" + this.convertContextPath("/kettle/cleanupTrans") + "' + '?name=' + document.getElementById( 'cellTableFirstCell' + selectedTransRowIndex ).innerHTML + '&id=' + document.getElementById( 'cellTableCell' + selectedTransRowIndex ).innerHTML );");
        out.println("}");
        out.println("}");
        out.println("function viewFunction( element ) {");
        out.println("if( element.id.startsWith( 'j-' ) && selectedJobRowIndex != -1 ) {");
        out.println("window.location.replace( '" + this.convertContextPath("/kettle/jobStatus") + "' + '?name=' + document.getElementById( 'j-cellTableFirstCell' + selectedJobRowIndex ).innerHTML + '&id=' + document.getElementById( 'j-cellTableCell' + selectedJobRowIndex ).innerHTML );");
        out.println("} else if ( selectedTransRowIndex != -1 ) {");
        out.println("window.location.replace( '" + this.convertContextPath("/kettle/transStatus") + "' + '?name=' + document.getElementById( 'cellTableFirstCell' + selectedTransRowIndex ).innerHTML + '&id=' + document.getElementById( 'cellTableCell' + selectedTransRowIndex ).innerHTML );");
        out.println("}");
        out.println("}");
        out.println("function removeFunction( element ) {");
        out.println("if( element.id.startsWith( 'j-' ) && selectedJobRowIndex != -1 ) {");
        out.println("window.location.replace( '" + this.convertContextPath("/kettle/removeJob") + "' + '?name=' + document.getElementById( 'j-cellTableFirstCell' + selectedJobRowIndex ).innerHTML + '&id=' + document.getElementById( 'j-cellTableCell' + selectedJobRowIndex ).innerHTML );");
        out.println("} else if ( selectedTransRowIndex != -1 ) {");
        out.println("window.location.replace( '" + this.convertContextPath("/kettle/removeTrans") + "' + '?name=' + document.getElementById( 'cellTableFirstCell' + selectedTransRowIndex ).innerHTML + '&id=' + document.getElementById( 'cellTableCell' + selectedTransRowIndex ).innerHTML );");
        out.println("}");
        out.println("}");
        out.println("function clickFunction( element, tableClass ) {");
        out.println("var prefix = element.id.startsWith( 'j-' ) ? 'j-' : '';");
        out.println("if( tableClass.endsWith( 'Row' ) ) {");
        out.println("element.className='cellTableRow ' + tableClass + ' cellTableSelectedRow';");
        out.println("} else {");
        out.println("document.getElementById( prefix + 'cellTableFirstCell' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell cellTableFirstColumn ' + tableClass + ' cellTableSelectedRowCell';");
        out.println("element.className='cellTableCell ' + tableClass + ' cellTableSelectedRowCell';");
        out.println("}");
        out.println("if( element.id.startsWith( 'j-' ) ) {");
        out.println("if( selectedJobRowIndex != -1 && element.id.charAt( element.id.length - 1 ) != selectedJobRowIndex ) {");
        out.println("document.getElementById( prefix + 'cellTableRow' + selectedJobRowIndex ).className='cellTableRow ' + tableClass;");
        out.println("document.getElementById( prefix + 'cellTableFirstCell' + selectedJobRowIndex ).className='cellTableCell cellTableFirstColumn ' + tableClass;");
        out.println("document.getElementById( prefix + 'cellTableCell' + selectedJobRowIndex ).className='cellTableCell ' + tableClass;");
        out.println("document.getElementById( prefix + 'cellTableLastCell' + selectedJobRowIndex ).className='cellTableCell cellTableLastColumn ' + tableClass;");
        out.println("}");
        out.println("selectedJobRowIndex = element.id.charAt( element.id.length - 1 );");
        out.println("} else {");
        out.println("if( selectedTransRowIndex != -1 && element.id.charAt( element.id.length - 1 ) != selectedTransRowIndex ) {");
        out.println("document.getElementById( prefix + 'cellTableRow' + selectedTransRowIndex ).className='cellTableRow ' + tableClass;");
        out.println("document.getElementById( prefix + 'cellTableFirstCell' + selectedTransRowIndex ).className='cellTableCell cellTableFirstColumn ' + tableClass;");
        out.println("document.getElementById( prefix + 'cellTableCell' + selectedTransRowIndex ).className='cellTableCell ' + tableClass;");
        out.println("document.getElementById( prefix + 'cellTableLastCell' + selectedTransRowIndex ).className='cellTableCell cellTableLastColumn ' + tableClass;");
        out.println("}");
        out.println("selectedTransRowIndex = element.id.charAt( element.id.length - 1 );");
        out.println("if( document.getElementById( 'cellTableCellStatus' + selectedTransRowIndex ).innerHTML == 'Running' ) {");
        out.println("document.getElementById( 'pause' ).innerHTML = '<img style=\"width: 22px; height: 22px\" src=\"/pentaho/content/common-ui/resources/themes/images/pause.svg\"/ title=\"Pause transformation\">';");
        out.println("} else if( document.getElementById( 'cellTableCellStatus' + selectedTransRowIndex ).innerHTML == 'Paused' ) {");
        out.println("document.getElementById( 'pause' ).innerHTML = '<img style=\"width: 22px; height: 22px\" src=\"/pentaho/content/common-ui/resources/themes/images/run_options.svg\" title=\"Resume transformation\"/>';");
        out.println("}");
        out.println("}");
        out.println("}");
        out.println("function mouseEnterFunction( element, tableClass ) {");
        out.println("var prefix = '';");
        out.println("var selectedIndex = selectedTransRowIndex;");
        out.println("if( element.id.startsWith( 'j-' ) ) {");
        out.println("prefix = 'j-';");
        out.println("selectedIndex = selectedJobRowIndex;");
        out.println("}");
        out.println("if( element.id.charAt( element.id.length - 1 ) != selectedIndex ) {");
        out.println("if( tableClass.endsWith( 'Row' ) ) {");
        out.println("element.className='cellTableRow ' + tableClass + ' cellTableHoveredRow';");
        out.println("} else {");
        out.println("document.getElementById( prefix + 'cellTableFirstCell' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell cellTableFirstColumn ' + tableClass + ' cellTableHoveredRowCell';");
        out.println("document.getElementById( prefix + 'cellTableCell' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell ' + tableClass + ' cellTableHoveredRowCell';");
        out.println("document.getElementById( prefix + 'cellTableLastCell' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell cellTableLastColumn ' + tableClass + ' cellTableHoveredRowCell';");
        out.println("}");
        out.println("}");
        out.println("}");
        out.println("function mouseLeaveFunction( element, tableClass ) {");
        out.println("var prefix = '';");
        out.println("var selectedIndex = selectedTransRowIndex;");
        out.println("if( element.id.startsWith( 'j-' ) ) {");
        out.println("prefix = 'j-';");
        out.println("selectedIndex = selectedJobRowIndex;");
        out.println("}");
        out.println("if( element.id.charAt( element.id.length - 1 ) != selectedIndex ) {");
        out.println("if( tableClass.endsWith( 'Row' ) ) {");
        out.println("element.className='cellTableRow ' + tableClass;");
        out.println("} else {");
        out.println("document.getElementById( prefix + 'cellTableFirstCell' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell cellTableFirstColumn ' + tableClass;");
        out.println("document.getElementById( prefix + 'cellTableCell' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell ' + tableClass;");
        out.println("document.getElementById( prefix + 'cellTableLastCell' + element.id.charAt( element.id.length - 1 ) ).className='cellTableCell cellTableLastColumn ' + tableClass;");
        out.println("}");
        out.println("}");
        out.println("}");
        out.println("</script>");
        out.println("</BODY>");
        out.println("</HTML>");
    }

    private static void getSystemInfo(SlaveServerStatus serverStatus) {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        int cores = Runtime.getRuntime().availableProcessors();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        String osArch = operatingSystemMXBean.getArch();
        String osName = operatingSystemMXBean.getName();
        String osVersion = operatingSystemMXBean.getVersion();
        double loadAvg = operatingSystemMXBean.getSystemLoadAverage();
        int threadCount = threadMXBean.getThreadCount();
        long allThreadsCpuTime = 0L;
        long[] threadIds = threadMXBean.getAllThreadIds();
        for (int i = 0; i < threadIds.length; ++i) {
            allThreadsCpuTime += threadMXBean.getThreadCpuTime(threadIds[i]);
        }
        long uptime = runtimeMXBean.getUptime();
        serverStatus.setCpuCores(cores);
        serverStatus.setCpuProcessTime(allThreadsCpuTime);
        serverStatus.setUptime(uptime);
        serverStatus.setThreadCount(threadCount);
        serverStatus.setLoadAvg(loadAvg);
        serverStatus.setOsName(osName);
        serverStatus.setOsVersion(osVersion);
        serverStatus.setOsArchitecture(osArch);
        serverStatus.setMemoryFree(freeMemory);
        serverStatus.setMemoryTotal(totalMemory);
    }

    public String toString() {
        return "Status Handler";
    }

    @Override
    public String getService() {
        return "/kettle/status (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

