/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.osgi;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.FileLock;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.math.NumberUtils;
import org.pentaho.platform.osgi.IKarafInstanceResolver;
import org.pentaho.platform.osgi.KarafInstance;
import org.pentaho.platform.osgi.KarafInstancePort;
import org.pentaho.platform.osgi.KarafInstanceResolverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServerSocketBasedKarafInstanceResolver
implements IKarafInstanceResolver {
    private static final int START_PORT_NUMBER = ServerSocketBasedKarafInstanceResolver.determineStartPort();
    public static final String PENTAHO_KARAF_INSTANCE_START_PORT = "pentaho.karaf.instance.start.port";
    private static final int MAX_NUMBER_OF_KARAF_INSTANCES = 1000;
    public static final String DATA = "data";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    ServerSocketBasedKarafInstanceResolver() {
    }

    static int determineStartPort() {
        String portStr = System.getProperty(PENTAHO_KARAF_INSTANCE_START_PORT, "11000");
        int portNo = NumberUtils.toInt((String)portStr);
        return portNo != 0 ? portNo : 11000;
    }

    @Override
    public void resolveInstance(KarafInstance instance) throws KarafInstanceResolverException {
        int latestOffsetTried = 0;
        do {
            latestOffsetTried = this.resolveInstanceNumber(instance, latestOffsetTried);
        } while (!this.resolvePorts(instance));
        this.assignAvailableCacheFolderForType(instance);
    }

    private void assignAvailableCacheFolderForType(KarafInstance instance) {
        String cacheParentFolder = instance.getCacheParentFolder();
        File clientTypeCacheFolder = new File(cacheParentFolder + "/" + instance.getClientType());
        clientTypeCacheFolder.mkdirs();
        File[] dataDirectories = clientTypeCacheFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(ServerSocketBasedKarafInstanceResolver.DATA);
            }
        });
        int maxInstanceNoFound = 0;
        Pattern pattern = Pattern.compile("data\\-([0-9]+)");
        for (File dataDirectory : dataDirectories) {
            boolean locked = true;
            Matcher matcher = pattern.matcher(dataDirectory.getName());
            if (!matcher.matches()) continue;
            int instanceNo = Integer.parseInt(matcher.group(1));
            maxInstanceNoFound = Math.max(maxInstanceNoFound, instanceNo);
            File lockFile = new File(dataDirectory, ".lock");
            FileLock lock = null;
            if (!lockFile.exists()) {
                locked = false;
            } else {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(lockFile);
                    try {
                        lock = fileOutputStream.getChannel().tryLock();
                        if (lock != null) {
                            instance.setCacheLock(lock);
                            locked = false;
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (FileNotFoundException e) {
                    this.logger.error("Error locking file in data cache directory", (Throwable)e);
                }
            }
            if (locked) continue;
            instance.setCachePath(dataDirectory.getPath());
            break;
        }
        if (instance.getCachePath() == null) {
            File newCacheFolder = null;
            while (newCacheFolder == null) {
                File candidate = new File(clientTypeCacheFolder, "data-" + ++maxInstanceNoFound);
                if (candidate.exists()) continue;
                newCacheFolder = candidate;
            }
            FileOutputStream fileOutputStream = null;
            try {
                newCacheFolder.mkdir();
                File lockFile = new File(newCacheFolder, ".lock");
                fileOutputStream = new FileOutputStream(lockFile);
                FileLock lock = fileOutputStream.getChannel().lock();
                instance.setCachePath(newCacheFolder.getPath());
                instance.setCacheLock(lock);
            }
            catch (IOException e) {
                this.logger.error("Error creating data cache folder", (Throwable)e);
            }
        }
    }

    private boolean resolvePorts(KarafInstance instance) {
        List<KarafInstancePort> ports = instance.getPorts();
        int instanceNumber = instance.getInstanceNumber();
        for (KarafInstancePort port : ports) {
            int portNo = port.getStartPort() + instanceNumber;
            if (!this.isPortAvailable(portNo)) {
                return false;
            }
            port.setAssignedPort(portNo);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPortAvailable(int port) {
        try (Socket ignored = new Socket("localhost", port);){
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            return true;
        }
    }

    private int resolveInstanceNumber(KarafInstance instance, int latestOffsetTried) throws KarafInstanceResolverException {
        this.logger.debug("Attempting to resolve available Karaf instance number by way of Server Socket");
        int testInstance = latestOffsetTried + 1;
        Integer instanceNo = null;
        do {
            int candidate = START_PORT_NUMBER + testInstance;
            Socket socket = null;
            try {
                this.logger.debug("Instance test. Trying port " + candidate);
                socket = new Socket("localhost", candidate);
                socket.close();
            }
            catch (ConnectException e) {
                try {
                    ServerSocket ssocket = new ServerSocket(candidate);
                    instanceNo = testInstance;
                    instance.setInstanceSocket(ssocket);
                    instance.setInstanceNumber(instanceNo);
                    this.logger.debug("Karaf instance resolved to: " + instanceNo);
                }
                catch (IOException iOException) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        } while (instanceNo == null && testInstance++ <= 1000);
        if (instanceNo == null) {
            throw new KarafInstanceResolverException("Unable to resolve Karaf Instance number");
        }
        return instanceNo;
    }
}

