/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.chartbeans;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.pentaho.chart.AbstractChartThemeFactory;
import org.pentaho.chart.ChartBeanFactory;
import org.pentaho.chart.ChartBoot;
import org.pentaho.chart.IChartLinkGenerator;
import org.pentaho.chart.model.ChartModel;
import org.pentaho.chart.model.DialPlot;
import org.pentaho.chart.model.PiePlot;
import org.pentaho.chart.model.Theme;
import org.pentaho.chart.model.util.ChartSerializer;
import org.pentaho.chart.plugin.ChartDataOverflowException;
import org.pentaho.chart.plugin.NoChartDataException;
import org.pentaho.chart.plugin.api.IOutput;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.action.IStreamingAction;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.chartbeans.ChartBeansGeneratorUtil;
import org.pentaho.platform.plugin.action.chartbeans.ChartBootException;
import org.pentaho.platform.plugin.action.chartbeans.ChartLinkGenerator;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public class ChartAction
implements IStreamingAction {
    protected static final int DEFAULT_CHART_WIDTH = 400;
    protected static final int DEFAULT_CHART_HEIGHT = 300;
    protected boolean convertNullsToZero = false;
    protected String seriesColumnName = null;
    protected int seriesColumn = -1;
    protected String categoryColumnName = null;
    protected int categoryColumn = -1;
    protected String valueColumnName = null;
    protected int valueColumn = -1;
    protected IPentahoResultSet chartData = null;
    protected String chartEngine;
    protected Exception bootException = null;
    protected String outputType = "";
    protected int chartWidth = -1;
    protected int chartHeight = -1;
    protected String contentLinkingTemplate;
    protected Number scalingFactor = new Double(1.0);
    protected OutputStream chartContentStream = null;
    protected String chartModelJson = null;
    protected String chartModelXml = null;
    protected ChartModel chartModel = null;
    protected String title = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChartAction() {
        ChartBoot chartBoot = ChartBoot.getInstance();
        synchronized (chartBoot) {
            while (!ChartBoot.getInstance().isBootDone()) {
                if (ChartBoot.getInstance().isBootInProgress()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (ChartBoot.getInstance().isBootFailed()) continue;
                ChartBoot.getInstance().start();
            }
            if (ChartBoot.getInstance().isBootFailed()) {
                this.bootException = ChartBoot.getInstance().getBootFailureReason();
            }
        }
    }

    public void execute() throws Exception {
        this.validate();
        if (this.bootException != null) {
            throw new ChartBootException(this.bootException);
        }
        Object[][] data = this.processChartData(this.chartData, this.valueColumn);
        if (this.chartModel.getTheme() != null) {
            Theme chartTheme;
            AbstractChartThemeFactory chartThemeFactory = new AbstractChartThemeFactory(){

                protected List<File> getThemeFiles() {
                    ArrayList<File> themeFiles = new ArrayList<File>();
                    themeFiles.add(new File(PentahoSystem.getApplicationContext().getSolutionPath("system/chartbeans/themes/Theme1.xml")));
                    themeFiles.add(new File(PentahoSystem.getApplicationContext().getSolutionPath("system/chartbeans/themes/Theme2.xml")));
                    themeFiles.add(new File(PentahoSystem.getApplicationContext().getSolutionPath("system/chartbeans/themes/Theme3.xml")));
                    themeFiles.add(new File(PentahoSystem.getApplicationContext().getSolutionPath("system/chartbeans/themes/Theme4.xml")));
                    themeFiles.add(new File(PentahoSystem.getApplicationContext().getSolutionPath("system/chartbeans/themes/Theme5.xml")));
                    themeFiles.add(new File(PentahoSystem.getApplicationContext().getSolutionPath("system/chartbeans/themes/Theme6.xml")));
                    return themeFiles;
                }
            };
            if (!(this.chartModel.getPlot() instanceof DialPlot) && (chartTheme = chartThemeFactory.getTheme(this.chartModel.getTheme())) != null) {
                chartTheme.applyTo(this.chartModel);
            }
        }
        this.loadChartEngine();
        this.chartModel.setChartEngineId(this.chartEngine);
        InputStream is = null;
        try {
            ChartLinkGenerator chartLinkGenerator = this.contentLinkingTemplate == null ? null : new ChartLinkGenerator(this.contentLinkingTemplate);
            is = ChartBeanFactory.createChart((Object[][])data, (Number)this.scalingFactor, (boolean)this.convertNullsToZero, (int)this.valueColumn, (int)this.seriesColumn, (int)this.categoryColumn, (ChartModel)this.chartModel, (IChartLinkGenerator)chartLinkGenerator, (int)this.chartWidth, (int)this.chartHeight, (IOutput.OutputTypes)this.getOutputType());
            if ("OpenFlashChart".equals(this.chartEngine)) {
                StringBuilder sb = new StringBuilder();
                int c = 0;
                while ((c = is.read()) >= 0) {
                    sb.append((char)c);
                }
                IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
                String contextPath = requestContext.getContextPath();
                String flashContent = ChartBeansGeneratorUtil.mergeOpenFlashChartHtmlTemplate(sb.toString().replaceAll("\"", "\\\\\""), contextPath + "/" + this.getSwfPath() + "/" + this.getSwfName());
                is = new ByteArrayInputStream(flashContent.getBytes("utf-8"));
            }
            int val = 0;
            while ((val = is.read()) != -1) {
                this.chartContentStream.write(val);
            }
        }
        catch (NoChartDataException ex) {
            if ("JFreeChart".equals(this.chartEngine)) {
                BufferedImage image = new BufferedImage(this.chartWidth, this.chartHeight, 2);
                Graphics2D graphics = image.createGraphics();
                graphics.setFont(new Font("serif", 1, 14));
                graphics.setColor(Color.BLACK);
                graphics.drawString("The chart data query returned no data.", 5, 5);
                String outputType = this.getMimeType(null).equals("image/jpg") ? "jpeg" : "png";
                ImageIO.write((RenderedImage)image, outputType, this.chartContentStream);
            } else {
                String flashContent = ChartBeansGeneratorUtil.buildEmptyOpenFlashChartHtmlFragment("The chart data query returned no data.");
                is = new ByteArrayInputStream(flashContent.getBytes("utf-8"));
                int val = 0;
                while ((val = is.read()) != -1) {
                    this.chartContentStream.write(val);
                }
            }
        }
        catch (ChartDataOverflowException ex) {
            if ("JFreeChart".equals(this.chartEngine)) {
                BufferedImage image = new BufferedImage(this.chartWidth, this.chartHeight, 2);
                Graphics2D graphics = image.createGraphics();
                graphics.setFont(new Font("serif", 1, 14));
                graphics.setColor(Color.BLACK);
                graphics.drawString(Messages.getInstance().getErrorString("ChartAction.TOO_MANY_DATA_POINTS"), 5, 5);
                graphics.drawString(Messages.getInstance().getErrorString("ChartAction.MAX_ALLOWED_DATA_POINTS", new Object[]{Integer.toString(ex.getMaxAllowedDataPoints())}), 5, 25);
                String outputType = this.getMimeType(null).equals("image/jpg") ? "jpeg" : "png";
                ImageIO.write((RenderedImage)image, outputType, this.chartContentStream);
            }
            String flashContent = ChartBeansGeneratorUtil.buildEmptyOpenFlashChartHtmlFragment(Messages.getInstance().getErrorString("ChartAction.TOO_MANY_DATA_POINTS_HTML", new Object[]{Integer.toString(ex.getMaxAllowedDataPoints())}));
            is = new ByteArrayInputStream(flashContent.getBytes("utf-8"));
            int val = 0;
            while ((val = is.read()) != -1) {
                this.chartContentStream.write(val);
            }
        }
    }

    public void setContentLinkingTemplate(String template) {
        this.contentLinkingTemplate = template;
    }

    protected Object[][] processChartData(IPentahoResultSet resultSet, int valueColumnIndex) {
        if (resultSet == null) {
            return null;
        }
        Object[][] result = null;
        result = new Object[resultSet.getRowCount()][resultSet.getMetaData().getColumnCount()];
        for (int r = 0; r < resultSet.getRowCount(); ++r) {
            for (int c = 0; c < resultSet.getMetaData().getColumnCount(); ++c) {
                result[r][c] = resultSet.getValueAt(r, c);
            }
        }
        return result;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.setChartContentStream(outputStream);
    }

    public void setChartContentStream(OutputStream outStream) {
        this.chartContentStream = outStream;
    }

    public void setChartData(IPentahoResultSet chartDataSet) {
        this.chartData = chartDataSet.memoryCopy();
    }

    public void validate() throws Exception {
        if (this.chartData == null) {
            throw new IllegalArgumentException(Messages.getInstance().getErrorString("ChartComponent.ERROR_0006_PARAM_NOT_SET", new Object[]{"chartData"}));
        }
        if (this.chartContentStream == null) {
            throw new IllegalArgumentException(Messages.getInstance().getErrorString("ChartComponent.ERROR_0006_PARAM_NOT_SET", new Object[]{"chartContentStream"}));
        }
        if (this.seriesColumnName != null) {
            if (!this.seriesColumnName.equals("")) {
                this.seriesColumn = this.chartData.getMetaData().getColumnIndex(this.seriesColumnName);
            }
        } else if (this.seriesColumn < 0) {
            this.seriesColumn = 0;
        }
        if (this.categoryColumnName != null) {
            if (!this.categoryColumnName.equals("")) {
                this.categoryColumn = this.chartData.getMetaData().getColumnIndex(this.categoryColumnName);
            }
        } else if (this.categoryColumn < 0) {
            this.categoryColumn = 1;
        }
        if (this.valueColumnName != null) {
            if (!this.valueColumnName.equals("")) {
                this.valueColumn = this.chartData.getMetaData().getColumnIndex(this.valueColumnName);
            }
        } else if (this.valueColumn < 0) {
            this.valueColumn = 2;
        }
        this.loadChartEngine();
        if (this.chartModel == null) {
            throw new IllegalArgumentException(Messages.getInstance().getErrorString("ChartComponent.ERROR_0006_PARAM_NOT_SET", new Object[]{"chartModel"}));
        }
        if (this.chartModel.getPlot() instanceof DialPlot) {
            if (this.valueColumn < 0) {
                throw new IllegalArgumentException(Messages.getInstance().getErrorString("ChartComponent.ERROR_0007_PARAM_VALUE_CANNOT_BE_NEGATIVE", new Object[]{"valueColumn", DialPlot.class.getSimpleName()}));
            }
        } else if (this.chartModel.getPlot() instanceof PiePlot) {
            if (this.seriesColumn < 0 || this.valueColumn < 0) {
                throw new IllegalArgumentException(Messages.getInstance().getErrorString("ChartComponent.ERROR_0007_PARAM_VALUE_CANNOT_BE_NEGATIVE", new Object[]{"valueColumn or seriesColumn", PiePlot.class.getSimpleName()}));
            }
        } else if (this.seriesColumn < 0 || this.categoryColumn < 0 || this.valueColumn < 0) {
            throw new IllegalArgumentException(Messages.getInstance().getErrorString("ChartComponent.ERROR_0007_PARAM_VALUE_CANNOT_BE_NEGATIVE", new Object[]{"seriesColumn, categoryColumn, or valueColumn", "All"}));
        }
        if (this.chartWidth <= 0) {
            this.chartWidth = 400;
        }
        if (this.chartHeight <= 0) {
            this.chartHeight = 300;
        }
    }

    public void setSeriesColumn(String seriesCol) {
        this.seriesColumnName = seriesCol;
    }

    public void setConvertNullsToZero(boolean convert) {
        this.convertNullsToZero = convert;
    }

    public boolean getConvertNullsToZero() {
        return this.convertNullsToZero;
    }

    public void setCategoryColumn(String categoryCol) {
        this.categoryColumnName = categoryCol;
    }

    public void setValueColumn(String valueCol) {
        this.valueColumnName = valueCol;
    }

    protected IOutput.OutputTypes getOutputType() {
        if (this.outputType.equals("jpg")) {
            return IOutput.OutputTypes.FILE_TYPE_JPEG;
        }
        if (this.outputType.equals("png")) {
            return IOutput.OutputTypes.FILE_TYPE_PNG;
        }
        return null;
    }

    public String getMimeType(String streamPropertyName) {
        this.loadChartEngine();
        if ("JFreeChart".equals(this.chartEngine)) {
            if (this.outputType.equalsIgnoreCase("jpg")) {
                return "image/jpg";
            }
            if (this.outputType.equalsIgnoreCase("png")) {
                return "image/png";
            }
            this.outputType = "png";
            return "image/png";
        }
        if ("OpenFlashChart".equals(this.chartEngine)) {
            this.outputType = "html";
            return "text/html";
        }
        return "text/html";
    }

    protected void loadChartEngine() {
        this.loadChartModel();
        if (this.chartModel != null && this.chartModel.getChartEngineId() != null) {
            this.chartEngine = this.chartModel.getChartEngineId();
            return;
        }
        if (this.chartEngine != null) {
            return;
        }
        String defaultChartEngine = PentahoSystem.getSystemSetting((String)"chartbeans/chartbeans_config.xml", (String)"default-chart-engine", (String)"OpenFlashChart");
        if (defaultChartEngine == null) {
            defaultChartEngine = "OpenFlashChart";
        }
        this.chartEngine = defaultChartEngine;
    }

    protected void loadChartModel() {
        if (this.chartModel == null) {
            if (this.chartModelJson != null) {
                this.chartModel = ChartSerializer.deSerialize((String)this.chartModelJson, (ChartSerializer.ChartSerializationFormat)ChartSerializer.ChartSerializationFormat.JSON);
            } else if (this.chartModelXml != null) {
                this.chartModel = ChartSerializer.deSerialize((String)this.chartModelXml, (ChartSerializer.ChartSerializationFormat)ChartSerializer.ChartSerializationFormat.XML);
            }
        }
    }

    public void setChartModelJson(String chartModelJson) {
        this.chartModelJson = chartModelJson;
    }

    public void setChartModelXmlStream(InputStream chartModelStream) throws IOException {
        this.chartModelXml = IOUtils.toString((InputStream)chartModelStream, (String)LocaleHelper.getSystemEncoding());
    }

    public void setChartModelXml(String chartModelXml) {
        this.chartModelXml = chartModelXml;
    }

    public void setChartModel(ChartModel chartModel) {
        this.chartModel = chartModel;
    }

    public void setChartWidth(int chartWidth) {
        this.chartWidth = chartWidth;
    }

    public void setChartHeight(int chartHeight) {
        this.chartHeight = chartHeight;
    }

    public void setChartWidth(String chartWidth) {
        this.chartWidth = Integer.valueOf(chartWidth);
    }

    public void setChartHeight(String chartHeight) {
        this.chartHeight = Integer.valueOf(chartHeight);
    }

    public String getChartEngine() {
        this.loadChartEngine();
        return this.chartEngine;
    }

    public void setChartEngine(String chartEngine) {
        this.chartEngine = chartEngine;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public void setScalingFactor(Double scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    public String getSwfPath() {
        return "openflashchart";
    }

    public String getSwfName() {
        return "open-flash-chart-full-embedded-font.swf";
    }
}

