/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport.helper;

import java.io.InputStream;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.AbstractResourceData;

public class PentahoResourceData
extends AbstractResourceData {
    private static final long serialVersionUID = 1806026106310340013L;
    private String filename;
    private ResourceKey key;

    public PentahoResourceData(ResourceKey key) throws ResourceLoadingException {
        if (key == null) {
            throw new NullPointerException();
        }
        this.key = key;
        this.filename = (String)key.getIdentifier();
    }

    public InputStream getResourceAsStream(ResourceManager caller) throws ResourceLoadingException {
        int resourceType = 1;
        if (this.filename.contains("://")) {
            resourceType = 2;
        }
        ActionSequenceResource resource = new ActionSequenceResource("", resourceType, "application/binary", (String)this.key.getIdentifier());
        return resource.getInputStream(RepositoryFilePermission.READ, LocaleHelper.getLocale());
    }

    public Object getAttribute(String lookupKey) {
        if (lookupKey.equals("filename")) {
            return this.filename;
        }
        return null;
    }

    public long getVersion(ResourceManager caller) throws ResourceLoadingException {
        ActionSequenceResource resource = new ActionSequenceResource("", 1, "application/binary", (String)this.key.getIdentifier());
        return resource.getLastModifiedDate(null);
    }

    public ResourceKey getKey() {
        return this.key;
    }
}

