/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.mondrian;

import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianException;
import mondrian.olap.OlapElement;
import mondrian.olap.Query;
import mondrian.olap.Schema;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.server.Locus;
import mondrian.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.PentahoConnectionFactory;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogComplementInfo;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogHelper;
import org.pentaho.platform.plugin.services.connections.mondrian.MDXConnection;
import org.pentaho.platform.plugin.services.connections.sql.SQLConnection;
import org.pentaho.platform.util.logging.Logger;

public class MondrianModelComponent
extends ComponentBase {
    private static final long serialVersionUID = -718697500002076945L;

    public Log getLogger() {
        return LogFactory.getLog(MondrianModelComponent.class);
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    public boolean init() {
        return true;
    }

    public boolean validateAction() {
        return true;
    }

    public boolean executeAction() {
        return true;
    }

    public void done() {
    }

    public static String getInitialQuery(Properties properties, String cubeName, IPentahoSession session) throws Throwable {
        MDXConnection mdxConnection;
        Connection connection;
        IMondrianCatalogService mondrianCatalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (String)"IMondrianCatalogService", (IPentahoSession)PentahoSessionHolder.getSession());
        List<MondrianCatalog> catalogs = mondrianCatalogService.listCatalogs(PentahoSessionHolder.getSession(), true);
        String propCat = properties.getProperty(RolapConnectionProperties.Catalog.name());
        for (MondrianCatalog cat : catalogs) {
            if (!cat.getDefinition().equalsIgnoreCase(propCat)) continue;
            Util.PropertyList connectProperties = Util.parseConnectString((String)cat.getDataSourceInfo());
            for (Pair pair : connectProperties) {
                if (properties.containsKey(pair.getKey())) continue;
                properties.put(pair.getKey(), pair.getValue());
            }
        }
        if ((connection = (mdxConnection = (MDXConnection)PentahoConnectionFactory.getConnection((String)"MDX", (Properties)properties, (IPentahoSession)session, null)).getConnection()) == null) {
            Logger.error((String)"MondrianModelComponent", (String)Messages.getInstance().getErrorString("MondrianModel.ERROR_0001_INVALID_CONNECTION", new Object[]{properties.toString()}));
            return null;
        }
        try {
            return MondrianModelComponent.getInitialQuery(connection, cubeName);
        }
        catch (Throwable t) {
            if (t instanceof MondrianException) {
                Throwable cause = ((MondrianException)t).getCause();
                if (cause != null) {
                    throw cause;
                }
                throw t;
            }
            throw t;
        }
    }

    @Deprecated
    public static String getInitialQuery(String modelPath, String connectionString, String driver, String user, String password, String cubeName, IPentahoSession session) throws Throwable {
        return MondrianModelComponent.getInitialQuery(modelPath, connectionString, driver, user, password, cubeName, null, session);
    }

    @Deprecated
    public static String getInitialQuery(String modelPath, String connectionString, String driver, String user, String password, String cubeName, String roleName, IPentahoSession session) throws Throwable {
        Properties properties = new Properties();
        if (driver != null) {
            properties.put("Driver", driver);
        }
        if (user != null) {
            properties.put("User", user);
        }
        if (password != null) {
            properties.put("Password", password);
        }
        if (modelPath.indexOf("http") == 0) {
            properties.put(RolapConnectionProperties.Catalog.name(), modelPath);
        } else if (modelPath.indexOf("http") == 0) {
            properties.put(RolapConnectionProperties.Catalog.name(), modelPath);
        } else {
            if (!modelPath.startsWith("solution:") && !modelPath.startsWith("mondrian:")) {
                modelPath = "solution:" + modelPath;
            }
            properties.put(RolapConnectionProperties.Catalog.name(), modelPath);
        }
        properties.put(RolapConnectionProperties.Provider.name(), "mondrian");
        properties.put(RolapConnectionProperties.PoolNeeded.name(), "false");
        properties.put(RolapConnectionProperties.DataSource.name(), connectionString);
        if (roleName != null) {
            properties.put(RolapConnectionProperties.Role.name(), roleName);
        }
        return MondrianModelComponent.getInitialQuery(properties, cubeName, session);
    }

    @Deprecated
    public static String getInitialQuery(String modelPath, String connectionString, String cubeName, IPentahoSession session) throws Throwable {
        return MondrianModelComponent.getInitialQuery(modelPath, connectionString, cubeName, null, session);
    }

    @Deprecated
    public static String getInitialQuery(String modelPath, String jndi, String cubeName, String roleName, IPentahoSession session) throws Throwable {
        Properties properties = new Properties();
        if (modelPath.indexOf("http") == 0) {
            properties.put(RolapConnectionProperties.Catalog.name(), modelPath);
        } else {
            if (!modelPath.startsWith("solution:") && !modelPath.startsWith("mondrian:")) {
                modelPath = "solution:" + modelPath;
            }
            properties.put(RolapConnectionProperties.Catalog.name(), modelPath);
        }
        properties.put(RolapConnectionProperties.Provider.name(), "mondrian");
        properties.put(RolapConnectionProperties.PoolNeeded.name(), "false");
        properties.put(RolapConnectionProperties.DataSource.name(), jndi);
        if (roleName != null) {
            properties.put(RolapConnectionProperties.Role.name(), roleName);
        }
        return MondrianModelComponent.getInitialQuery(properties, cubeName, session);
    }

    public static String getInitialQuery(final Connection connection, String cubeName) throws Throwable {
        String measuresMdx = null;
        String columnsMdx = null;
        String whereMdx = "";
        StringBuffer rowsMdx = new StringBuffer();
        String catalog = connection.getCatalogName();
        MondrianCatalogComplementInfo catalogComplementInfo = MondrianCatalogHelper.getInstance().getCatalogComplementInfoMap(catalog);
        try {
            Dimension[] dimensions;
            Schema schema = connection.getSchema();
            if (schema == null) {
                Logger.error((String)"MondrianModelComponent", (String)Messages.getInstance().getErrorString("MondrianModel.ERROR_0002_INVALID_SCHEMA", new Object[]{connection.getConnectString()}));
                return null;
            }
            Cube[] cubes = schema.getCubes();
            if (cubes == null || cubes.length == 0) {
                Logger.error((String)"MondrianModelComponent", (String)Messages.getInstance().getErrorString("MondrianModel.ERROR_0003_NO_CUBES", new Object[]{connection.getConnectString()}));
                return null;
            }
            if (cubes.length > 1 && cubeName == null) {
                Logger.error((String)"MondrianModelComponent", (String)Messages.getInstance().getErrorString("MondrianModel.ERROR_0004_CUBE_NOT_SPECIFIED", new Object[]{connection.getConnectString()}));
                return null;
            }
            Cube cube = null;
            if (cubes.length == 1) {
                cube = cubes[0];
            } else {
                for (Cube element : cubes) {
                    if (!element.getName().equals(cubeName)) continue;
                    cube = element;
                    break;
                }
            }
            if (cube == null) {
                Logger.error((String)"MondrianModelComponent", (String)Messages.getInstance().getErrorString("MondrianModel.ERROR_0005_CUBE_NOT_FOUND", new Object[]{cubeName, connection.getConnectString()}));
                return null;
            }
            HashSet<Hierarchy> whereHierarchies = new HashSet<Hierarchy>();
            if (catalogComplementInfo != null && catalogComplementInfo.getWhereCondition(cube.getName()) != null && !catalogComplementInfo.getWhereCondition(cube.getName()).equals("")) {
                String rawString = catalogComplementInfo.getWhereCondition(cube.getName());
                try {
                    String queryStr = "select " + rawString + " on columns, {} on rows from " + cube.getName();
                    Query query = connection.parseQuery(queryStr);
                    Hierarchy[] hierarchies = query.getMdxHierarchiesOnAxis((AxisOrdinal)AxisOrdinal.StandardAxisOrdinal.COLUMNS);
                    boolean isWhereValid = true;
                    for (int i = 0; i < hierarchies.length && isWhereValid; ++i) {
                        Hierarchy hierarchy = hierarchies[i];
                        if (connection.getRole().canAccess((OlapElement)hierarchy)) {
                            whereHierarchies.add(hierarchy);
                            continue;
                        }
                        isWhereValid = false;
                        whereHierarchies.clear();
                    }
                    if (isWhereValid) {
                        whereMdx = " WHERE " + rawString;
                    }
                }
                catch (Exception e) {
                    whereHierarchies.clear();
                }
            }
            if ((dimensions = cube.getDimensions()) == null || dimensions.length == 0) {
                Logger.error((String)"MondrianModelComponent", (String)Messages.getInstance().getErrorString("MondrianModel.ERROR_0006_NO_DIMENSIONS", new Object[]{cubeName, connection.getConnectString()}));
                return null;
            }
            for (Dimension element : dimensions) {
                final Hierarchy hierarchy = element.getHierarchy();
                if (hierarchy == null) {
                    Logger.error((String)"MondrianModelComponent", (String)Messages.getInstance().getErrorString("MondrianModel.ERROR_0007_NO_HIERARCHIES", new Object[]{element.getName(), cubeName, connection.getConnectString()}));
                    return null;
                }
                if (!connection.getRole().canAccess((OlapElement)hierarchy) || whereHierarchies.contains(hierarchy)) continue;
                Member member = (Member)Locus.execute((RolapConnection)((RolapConnection)connection), (String)"Retrieving default members in plugin", (Locus.Action)new Locus.Action<Member>(){

                    public Member execute() {
                        return connection.getSchemaReader().getHierarchyDefaultMember(hierarchy);
                    }
                });
                if (member == null) {
                    Logger.error((String)"MondrianModelComponent", (String)Messages.getInstance().getErrorString("MondrianModel.ERROR_0008_NO_DEFAULT_MEMBER", new Object[]{element.getName(), cubeName, connection.getConnectString()}));
                    return null;
                }
                if (element.isMeasures()) {
                    measuresMdx = "";
                    columnsMdx = " select NON EMPTY {" + member.getUniqueName() + "} ON columns, ";
                    continue;
                }
                if (rowsMdx.length() > 0) {
                    rowsMdx.append(", ");
                }
                rowsMdx.append(member.getUniqueName());
            }
            if (measuresMdx != null && columnsMdx != null && rowsMdx.length() > 0) {
                StringBuffer result = new StringBuffer(measuresMdx.length() + columnsMdx.length() + rowsMdx.length() + 50);
                result.append(measuresMdx).append(columnsMdx).append("NON EMPTY {(").append(rowsMdx).append(")} ON rows ").append("from [" + cube.getName() + "]").append(whereMdx);
                return result.toString();
            }
            return null;
        }
        catch (Throwable t) {
            if (t instanceof MondrianException) {
                Throwable cause = ((MondrianException)t).getCause();
                if (cause != null) {
                    throw cause;
                }
                throw t;
            }
            throw t;
        }
    }

    protected SQLConnection getConnection(String jndiName, String driver, String userId, String password, String connectionInfo) {
        SQLConnection connection = null;
        try {
            if (jndiName != null) {
                connection = (SQLConnection)PentahoConnectionFactory.getConnection((String)"SQL", (String)jndiName, (IPentahoSession)this.getSession(), (ILogger)this);
            }
            if (connection == null) {
                connection = (SQLConnection)PentahoConnectionFactory.getConnection((String)"SQL", (String)driver, (String)connectionInfo, (String)userId, (String)password, (IPentahoSession)this.getSession(), (ILogger)this);
            }
            if (connection == null) {
                Logger.error((String)"MondrianModelComponent", (String)Messages.getInstance().getErrorString("SQLBaseComponent.ERROR_0005_INVALID_CONNECTION"));
                return null;
            }
            return connection;
        }
        catch (Exception e) {
            Logger.error((String)"MondrianModelComponent", (String)Messages.getInstance().getErrorString("SQLBaseComponent.ERROR_0006_EXECUTE_FAILED", new Object[]{""}), (Throwable)e);
            return null;
        }
    }
}

