/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.connections.mondrian;

import java.util.List;
import mondrian.olap.Axis;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Result;
import org.pentaho.commons.connection.AbstractPentahoMetaData;
import org.pentaho.commons.connection.IMultiDimensionalMetaData;
import org.pentaho.commons.connection.MetaDataUtil;

public class MDXMetaData
extends AbstractPentahoMetaData
implements IMultiDimensionalMetaData {
    private static final int AXIS_COLUMN = 0;
    private Object[][] columnHeaders;
    private Object[][] rowHeaders;
    private String[] columnNames;
    private String[] columnNamesFlattened;
    protected String columnNameFormatStr;
    private static final int AXIS_ROW = 1;
    Result nativeResultSet = null;
    private boolean useExtendedColumnNames = false;

    public MDXMetaData() {
    }

    public MDXMetaData(Result nativeResultSet, boolean useExtendedColumnNames) {
        this.useExtendedColumnNames = useExtendedColumnNames;
        this.nativeResultSet = nativeResultSet;
        this.columnHeaders = this.createColumnHeaders();
        this.rowHeaders = this.createRowHeaders();
        this.columnNames = this.createColumnNames();
    }

    public MDXMetaData(Result nativeResultSet) {
        this(nativeResultSet, false);
    }

    protected Object[][] createColumnHeaders() {
        int rowCount = 0;
        int colCount = 0;
        Object[][] result = null;
        Axis[] axes = this.nativeResultSet.getAxes();
        if (axes.length <= 0 || axes[0] == null) {
            return new Object[0][0];
        }
        List positions = axes[0].getPositions();
        if (this.useExtendedColumnNames) {
            if (positions != null && positions.size() > 0) {
                rowCount = ((List)positions.get(0)).size();
                colCount = positions.size();
            }
            result = new Object[rowCount][colCount];
            for (int c = 0; c < colCount; ++c) {
                List members = (List)positions.get(c);
                Member member = null;
                for (int r = 0; r < rowCount; ++r) {
                    member = (Member)members.get(r);
                    result[r][c] = member.getCaption();
                }
            }
        } else {
            if (positions != null && positions.size() > 0) {
                rowCount = ((List)positions.get(0)).size() + 1;
                colCount = positions.size();
            }
            result = new Object[rowCount][colCount];
            for (int c = 0; c < colCount; ++c) {
                List members = (List)positions.get(c);
                Member member = null;
                for (int r = 0; r < rowCount - 1; ++r) {
                    member = (Member)members.get(r);
                    result[r][c] = member.getCaption();
                }
                result[rowCount - 1][c] = member.getHierarchy().getCaption();
            }
        }
        return result;
    }

    protected Object[][] createRowHeaders() {
        int rowCount = 0;
        int colCount = 0;
        Object[][] result = null;
        Axis[] axes = this.nativeResultSet.getAxes();
        if (axes.length <= 1 || axes[1] == null) {
            return new Object[0][0];
        }
        List positions = axes[1].getPositions();
        if (this.useExtendedColumnNames) {
            if (positions != null && positions.size() > 0) {
                rowCount = positions.size();
                colCount = ((List)positions.get(0)).size();
            }
            result = new Object[rowCount][colCount];
            for (int r = 0; r < rowCount; ++r) {
                List members = (List)positions.get(r);
                Member member = null;
                for (int c = 0; c < colCount; ++c) {
                    member = (Member)members.get(c);
                    result[r][c] = member.getCaption();
                }
            }
        } else {
            if (positions != null && positions.size() > 0) {
                rowCount = positions.size();
                colCount = ((List)positions.get(0)).size() + 1;
            }
            result = new Object[rowCount][colCount];
            for (int r = 0; r < rowCount; ++r) {
                List members = (List)positions.get(r);
                Member member = null;
                for (int c = 0; c < colCount - 1; ++c) {
                    member = (Member)members.get(c);
                    result[r][c] = member.getCaption();
                }
                result[r][colCount - 1] = member.getHierarchy().getCaption();
            }
        }
        return result;
    }

    protected String[] createColumnNames() {
        String[] colNames = null;
        if (this.nativeResultSet != null) {
            Axis[] axes = this.nativeResultSet.getAxes();
            if (axes.length <= 1 || axes[1] == null) {
                return new String[0];
            }
            List positions = axes[1].getPositions();
            if (this.useExtendedColumnNames) {
                if (this.rowHeaders.length > 0 && positions != null && positions.size() > 0) {
                    colNames = new String[this.rowHeaders[0].length];
                    for (int i = 0; i < colNames.length; ++i) {
                        Member member = (Member)((List)positions.get(0)).get(i);
                        colNames[i] = "[" + member.getDimension().getName() + "].[" + member.getHierarchy().getName() + "].[" + member.getLevel().getName() + "]";
                    }
                } else {
                    colNames = new String[]{};
                }
            } else if (positions != null && positions.size() > 0) {
                colNames = new String[this.getColumnCount()];
                for (int i = 0; i < colNames.length; ++i) {
                    if (i < ((List)positions.get(0)).size()) {
                        Member member = (Member)((List)positions.get(0)).get(i);
                        Hierarchy hierarchy = member.getHierarchy();
                        colNames[i] = hierarchy.getCaption();
                        continue;
                    }
                    colNames[i] = ((Member)((List)positions.get(0)).get(((List)positions.get(0)).size() - 1)).getHierarchy().getName() + "{" + i + "}";
                }
            } else {
                colNames = new String[]{};
            }
        }
        return colNames;
    }

    public String getColumnName(int columnNumber) {
        return this.columnNames != null && columnNumber >= 0 && columnNumber < this.columnNames.length ? this.columnNames[columnNumber] : "";
    }

    public int getColumnCount() {
        Axis[] axes = this.nativeResultSet.getAxes();
        if (axes.length <= 0 || axes[0] == null) {
            return 0;
        }
        List positions = axes[0].getPositions();
        return positions != null ? positions.size() : 0;
    }

    public Object[][] getColumnHeaders() {
        return this.columnHeaders;
    }

    public Object[][] getRowHeaders() {
        return this.rowHeaders;
    }

    protected void setColumnHeaders(Object[][] columnHeaders) {
        this.columnHeaders = columnHeaders;
    }

    protected void setRowHeaders(Object[][] rowHeaders) {
        this.rowHeaders = rowHeaders;
    }

    public String[] getRowHeaderNames() {
        return this.columnNames;
    }

    public void setColumnNameFormat(String formatStr) {
        this.columnNameFormatStr = formatStr;
    }

    public void generateColumnNames() {
        String[] rowHeaderNames = this.getRowHeaderNames();
        this.columnNamesFlattened = MetaDataUtil.generateColumnNames((Object[][])this.columnHeaders, (Object[][])this.rowHeaders, (String[])rowHeaderNames, (String)this.columnNameFormatStr);
    }

    public String[] getFlattenedColumnNames() {
        if (this.columnNamesFlattened == null) {
            this.generateColumnNames();
        }
        return this.columnNamesFlattened;
    }
}

