/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.connections.sql;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.PoolingDataSource;
import org.pentaho.commons.connection.ILimitableConnection;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.engine.PentahoSystemException;
import org.pentaho.platform.engine.core.system.IPentahoLoggingConnection;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.PooledDatasourceHelper;
import org.pentaho.platform.plugin.services.connections.sql.SQLResultSet;
import org.pentaho.platform.plugin.services.messages.Messages;

public class SQLConnection
implements IPentahoLoggingConnection,
ILimitableConnection {
    protected Connection nativeConnection;
    ArrayList<Statement> stmts = new ArrayList();
    ArrayList<IPentahoResultSet> resultSets = new ArrayList();
    IPentahoResultSet sqlResultSet = null;
    ILogger logger = null;
    private int timeOut = -1;
    private int maxRows = -1;
    private int fetchSize = -1;
    private boolean readOnly;
    private boolean forcedForwardOnly = false;
    private boolean fallBackToNonscrollableOnError = true;
    public static final int RESULTSET_SCROLLABLE = 1004;
    public static final int RESULTSET_FORWARDONLY = 1003;
    public static final int CONCUR_READONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;
    String lastQuery = null;

    public SQLConnection() {
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public void setProperties(Properties props) {
        String jndiName = props.getProperty("jndiName");
        if (jndiName != null) {
            this.initWithJNDI(jndiName);
        } else {
            this.connect(props);
        }
    }

    public void setQueryTimeout(int timeInSec) {
        this.timeOut = timeInSec;
    }

    public void setReadOnly(boolean value) {
        this.readOnly = value;
    }

    public int getQueryTimeout() {
        return this.timeOut;
    }

    public SQLConnection(String driverName, String location, String userName, String password, ILogger logger) {
        this.logger = logger;
        this.init(driverName, location, userName, password);
    }

    protected void init(String driverName, String location, String userName, String password) {
        try {
            Driver driver = null;
            try {
                driver = DriverManager.getDriver(location);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (driver == null) {
                Class<?> driverClass = Class.forName(driverName);
                driver = (Driver)driverClass.newInstance();
                DriverManager.registerDriver(driver);
            }
            Properties info = new Properties();
            info.put("user", userName == null ? "" : userName);
            info.put("password", password == null ? "" : password);
            this.nativeConnection = this.captureConnection(driver.connect(location, info));
            if (this.nativeConnection == null) {
                this.logger.error(Messages.getInstance().getErrorString("ConnectFactory.ERROR_0001_INVALID_CONNECTION2", new Object[]{driverName, location}));
            } else {
                this.enhanceConnection(this.nativeConnection);
            }
        }
        catch (Throwable t) {
            this.logger.error(Messages.getInstance().getErrorString("ConnectFactory.ERROR_0001_INVALID_CONNECTION2", new Object[]{driverName, location}), t);
            this.close();
        }
    }

    public boolean initialized() {
        return this.nativeConnection != null;
    }

    public String getDatasourceType() {
        return "SQL";
    }

    protected void initWithJNDI(String jndiName) {
        try {
            IDBDatasourceService datasourceService = (IDBDatasourceService)PentahoSystem.getObjectFactory().get(IDBDatasourceService.class, null);
            DataSource dataSource = datasourceService.getDataSource(jndiName);
            if (dataSource != null) {
                this.nativeConnection = this.captureConnection(dataSource.getConnection());
                if (this.nativeConnection == null) {
                    this.logger.error(Messages.getInstance().getErrorString("ConnectFactory.ERROR_0001_INVALID_CONNECTION", new Object[]{jndiName}));
                    datasourceService.clearDataSource(jndiName);
                } else {
                    this.enhanceConnection(this.nativeConnection);
                }
            } else {
                this.logger.error(Messages.getInstance().getErrorString("ConnectFactory.ERROR_0001_INVALID_CONNECTION", new Object[]{jndiName}));
                datasourceService.clearDataSource(jndiName);
            }
        }
        catch (Exception e) {
            this.logger.error(Messages.getInstance().getErrorString("ConnectFactory.ERROR_0001_INVALID_CONNECTION", new Object[]{jndiName}), (Throwable)e);
            this.close();
            try {
                IDBDatasourceService datasourceService = (IDBDatasourceService)PentahoSystem.getObjectFactory().get(IDBDatasourceService.class, null);
                datasourceService.clearDataSource(jndiName);
            }
            catch (ObjectFactoryException objface) {
                this.logger.error(Messages.getInstance().getErrorString("ConnectFactory.ERROR_0002_UNABLE_TO_FACTORY_OBJECT=Unable to factory object", new Object[]{jndiName}), (Throwable)e);
            }
        }
    }

    protected void enhanceConnection(Connection connection) throws SQLException {
    }

    protected void unEnhanceConnection(Connection connection) throws SQLException {
    }

    protected Connection captureConnection(Connection connection) throws SQLException {
        return connection;
    }

    protected void enhanceStatement(Statement statement) throws SQLException {
    }

    private void closeStatements() {
        Iterator<Statement> iter = this.stmts.iterator();
        while (iter.hasNext()) {
            Statement stmt = iter.next();
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            iter.remove();
        }
    }

    private void closeResultSets() {
        Iterator<IPentahoResultSet> iter = this.resultSets.iterator();
        while (iter.hasNext()) {
            IPentahoResultSet rset = iter.next();
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            iter.remove();
        }
    }

    public void close() {
        this.closeResultSets();
        this.closeStatements();
        if (this.nativeConnection != null) {
            try {
                this.unEnhanceConnection(this.nativeConnection);
                if (this.getReadOnly()) {
                    try {
                        this.nativeConnection.setReadOnly(false);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.nativeConnection.close();
            }
            catch (SQLException e) {
                this.logger.error(null, (Throwable)e);
            }
        }
        this.nativeConnection = null;
    }

    public String getLastQuery() {
        return this.lastQuery;
    }

    public IPentahoResultSet executeQuery(String query) throws SQLException, InterruptedException, PentahoSystemException {
        return this.executeQuery(query, 1004, 1007);
    }

    public IPentahoResultSet executeQuery(String query, int scrollType, int concur) throws SQLException, InterruptedException, PentahoSystemException {
        ResultSet resultSet;
        block7: {
            if (this.getReadOnly()) {
                try {
                    this.nativeConnection.setReadOnly(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Statement stmt = null;
            resultSet = null;
            try {
                stmt = this.nativeConnection.createStatement(scrollType, concur);
                this.stmts.add(stmt);
                this.enhanceStatement(stmt);
                this.setStatementLimitations(stmt);
                if (this.logger != null && this.logger.getLoggingLevel() == 2) {
                    this.logger.debug("SQLConnection.executeQuery:" + query);
                }
                resultSet = stmt.executeQuery(query);
            }
            catch (Exception e) {
                if (scrollType != 1004 || !this.isFallBackToNonscrollableOnError()) break block7;
                stmt = this.nativeConnection.createStatement(1003, concur);
                this.stmts.add(stmt);
                this.enhanceStatement(stmt);
                this.setStatementLimitations(stmt);
                if (this.logger != null && this.logger.getLoggingLevel() == 2) {
                    this.logger.debug("SQLConnection.executeQuery(e):" + query);
                }
                resultSet = stmt.executeQuery(query);
                this.setForcedForwardOnly(true);
            }
        }
        this.sqlResultSet = new SQLResultSet(resultSet, this);
        this.resultSets.add(this.sqlResultSet);
        this.lastQuery = query;
        return this.sqlResultSet;
    }

    public IPentahoResultSet prepareAndExecuteQuery(String query, List parameters) throws SQLException {
        return this.prepareAndExecuteQuery(query, parameters, 1004, 1007);
    }

    protected void setStatementLimitations(Statement stmt) throws SQLException {
        if (this.getFetchSize() >= 0) {
            try {
                stmt.setFetchSize(this.getFetchSize());
            }
            catch (Exception ex) {
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                throw new UnsupportedOperationException(Messages.getInstance().getErrorString("SQLConnection.ERROR_0003_FETCHSIZE_NOT_SET", new Object[]{Integer.toString(this.getFetchSize())}), ex);
            }
        }
        if (this.getMaxRows() >= 0) {
            try {
                stmt.setMaxRows(this.getMaxRows());
            }
            catch (Exception ex) {
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                throw new UnsupportedOperationException(Messages.getInstance().getErrorString("SQLConnection.ERROR_0002_ROWLIMIT_NOT_SET", new Object[]{Integer.toString(this.getMaxRows())}), ex);
            }
        }
        if (this.getQueryTimeout() >= 0) {
            try {
                stmt.setQueryTimeout(this.getQueryTimeout());
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new UnsupportedOperationException(Messages.getInstance().getErrorString("SQLConnection.ERROR_0001_TIMEOUT_NOT_SET", new Object[]{Integer.toString(this.getQueryTimeout())}), e);
            }
        }
    }

    public IPentahoResultSet prepareAndExecuteQuery(String query, List parameters, int scrollType, int concur) throws SQLException {
        ResultSet resultSet;
        block9: {
            if (this.getReadOnly()) {
                try {
                    this.nativeConnection.setReadOnly(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            PreparedStatement pStmt = null;
            resultSet = null;
            try {
                if (this.logger != null && this.logger.getLoggingLevel() == 2) {
                    this.logger.debug("SQLConnection.prepareAndExecuteQuery:" + query);
                }
                pStmt = this.nativeConnection.prepareStatement(query, scrollType, concur);
                this.stmts.add(pStmt);
                this.enhanceStatement(pStmt);
                this.setStatementLimitations(pStmt);
                for (int i = 0; i < parameters.size(); ++i) {
                    pStmt.setObject(i + 1, parameters.get(i));
                }
                resultSet = pStmt.executeQuery();
            }
            catch (Exception e) {
                this.stmts.remove(pStmt);
                if (scrollType != 1004 || !this.isFallBackToNonscrollableOnError()) break block9;
                if (this.logger != null && this.logger.getLoggingLevel() == 2) {
                    this.logger.debug("SQLConnection.prepareAndExecuteQuery(e):" + query);
                }
                pStmt = this.nativeConnection.prepareStatement(query, 1003, concur);
                this.stmts.add(pStmt);
                this.enhanceStatement(pStmt);
                this.setStatementLimitations(pStmt);
                for (int i = 0; i < parameters.size(); ++i) {
                    pStmt.setObject(i + 1, parameters.get(i));
                }
                resultSet = pStmt.executeQuery();
                this.setForcedForwardOnly(true);
            }
        }
        this.sqlResultSet = new SQLResultSet(resultSet, this);
        this.resultSets.add(this.sqlResultSet);
        this.lastQuery = query;
        return this.sqlResultSet;
    }

    public boolean preparedQueriesSupported() {
        return true;
    }

    public boolean isClosed() {
        try {
            return this.nativeConnection.isClosed();
        }
        catch (SQLException e) {
            this.logger.error(null, (Throwable)e);
            return true;
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    public void clearWarnings() {
        try {
            this.nativeConnection.clearWarnings();
        }
        catch (SQLException e) {
            this.logger.error(null, (Throwable)e);
        }
    }

    public IPentahoResultSet getResultSet() {
        return this.sqlResultSet;
    }

    void initDataSource(IDatabaseConnection databaseConnection) {
        PoolingDataSource dataSource = null;
        try {
            dataSource = PooledDatasourceHelper.setupPooledDataSource((IDatabaseConnection)databaseConnection);
            this.nativeConnection = this.captureConnection(dataSource.getConnection());
        }
        catch (Exception e) {
            this.logger.error("Can't get connection from Pool", (Throwable)e);
        }
    }

    public boolean connect(Properties props) {
        this.close();
        String jndiName = props.getProperty("jndiName");
        if (jndiName != null && jndiName.length() > 0) {
            this.initWithJNDI(jndiName);
        } else {
            String connectionName = props.getProperty("connection_name");
            if (connectionName != null && connectionName.length() > 0) {
                IDatabaseConnection databaseConnection = (IDatabaseConnection)props.get("connection");
                this.initDataSource(databaseConnection);
            } else {
                String driver = props.getProperty("driver");
                String provider = props.getProperty("location");
                String userName = props.getProperty("userName");
                String password = props.getProperty("password");
                this.init(driver, provider, userName, password);
                String query = props.getProperty("query");
                if (query != null && query.length() > 0) {
                    try {
                        this.executeQuery(query);
                    }
                    catch (Exception e) {
                        this.logger.error("Can't execute query", (Throwable)e);
                    }
                }
            }
        }
        return this.nativeConnection != null && !this.isClosed();
    }

    public int execute(String query) throws SQLException {
        return this.execute(query, 1004, 1007);
    }

    public int execute(String query, int scrollType, int concur) throws SQLException {
        Statement stmt = this.nativeConnection.createStatement(scrollType, concur);
        this.enhanceStatement(stmt);
        this.stmts.add(stmt);
        this.setStatementLimitations(stmt);
        if (this.logger != null && this.logger.getLoggingLevel() == 2) {
            this.logger.debug("SQLConnection.execute:" + query);
        }
        int result = stmt.executeUpdate(query);
        this.lastQuery = query;
        return result;
    }

    public Connection getNativeConnection() {
        return this.nativeConnection;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setFallBackToNonscrollableOnError(boolean fallBackToNonscrollableOnError) {
        this.fallBackToNonscrollableOnError = fallBackToNonscrollableOnError;
    }

    public boolean isFallBackToNonscrollableOnError() {
        return this.fallBackToNonscrollableOnError;
    }

    public boolean isForcedForwardOnly() {
        return this.forcedForwardOnly;
    }

    public void setForcedForwardOnly(boolean forcedForwardOnly) {
        this.forcedForwardOnly = forcedForwardOnly;
    }
}

