/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.exporter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.stores.xml.XmlMetaStore;
import org.pentaho.metastore.util.MetaStoreUtil;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.repository.datasource.DatasourceMgmtServiceException;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.scheduler2.IScheduler;
import org.pentaho.platform.api.scheduler2.Job;
import org.pentaho.platform.api.scheduler2.SchedulerException;
import org.pentaho.platform.api.usersettings.IAnyUserSettingService;
import org.pentaho.platform.api.usersettings.IUserSettingService;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.TenantUtils;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.services.exporter.MetaStoreExportUtil;
import org.pentaho.platform.plugin.services.exporter.ScheduleExportUtil;
import org.pentaho.platform.plugin.services.importexport.DefaultExportHandler;
import org.pentaho.platform.plugin.services.importexport.ExportException;
import org.pentaho.platform.plugin.services.importexport.ExportFileNameEncoder;
import org.pentaho.platform.plugin.services.importexport.ExportManifestUserSetting;
import org.pentaho.platform.plugin.services.importexport.RoleExport;
import org.pentaho.platform.plugin.services.importexport.UserExport;
import org.pentaho.platform.plugin.services.importexport.ZipExportProcessor;
import org.pentaho.platform.plugin.services.importexport.exportManifest.Parameters;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.ExportManifestMetaStore;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.ExportManifestMetadata;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.ExportManifestMondrian;
import org.pentaho.platform.plugin.services.importexport.legacy.MondrianCatalogRepositoryHelper;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.plugin.services.metadata.IPentahoMetadataDomainRepositoryExporter;
import org.pentaho.platform.repository2.ClientRepositoryPaths;
import org.pentaho.platform.security.policy.rolebased.IRoleAuthorizationPolicyRoleBindingDao;
import org.pentaho.platform.web.http.api.resources.JobScheduleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetailsService;

public class PentahoPlatformExporter
extends ZipExportProcessor {
    private static final Logger log = LoggerFactory.getLogger(PentahoPlatformExporter.class);
    public static final String ROOT = "/";
    public static final String DATA_SOURCES_PATH_IN_ZIP = "_datasources/";
    public static final String METADATA_PATH_IN_ZIP = "_datasources/metadata/";
    public static final String ANALYSIS_PATH_IN_ZIP = "_datasources/analysis/";
    public static final String CONNECTIONS_PATH_IN_ZIP = "_datasources/connections/";
    public static final String METASTORE = "metastore";
    public static final String METASTORE_BACKUP_EXT = ".mzip";
    private File exportFile;
    protected ZipOutputStream zos;
    private IScheduler scheduler;
    private IMetadataDomainRepository metadataDomainRepository;
    private IDatasourceMgmtService datasourceMgmtService;
    private IMondrianCatalogService mondrianCatalogService;
    private MondrianCatalogRepositoryHelper mondrianCatalogRepositoryHelper;
    private IMetaStore metastore;
    private IUserSettingService userSettingService;

    public PentahoPlatformExporter(IUnifiedRepository repository) {
        super(ROOT, repository, true);
        this.setUnifiedRepository(repository);
        this.addExportHandler(new DefaultExportHandler());
    }

    public File performExport() throws ExportException, IOException {
        return this.performExport(null);
    }

    @Override
    public File performExport(RepositoryFile exportRepositoryFile) throws ExportException, IOException {
        exportRepositoryFile = this.getUnifiedRepository().getFile(ROOT);
        this.exportFile = File.createTempFile("repoExport", ".zip");
        this.exportFile.deleteOnExit();
        this.zos = new ZipOutputStream(new FileOutputStream(this.exportFile));
        this.exportFileContent(exportRepositoryFile);
        this.exportDatasources();
        this.exportMondrianSchemas();
        this.exportMetadataModels();
        this.exportSchedules();
        this.exportUsersAndRoles();
        this.exportMetastore();
        if (this.withManifest) {
            ZipEntry entry = new ZipEntry("exportManifest.xml");
            this.zos.putNextEntry(entry);
            try {
                this.getExportManifest().toXml(this.zos);
            }
            catch (Exception e) {
                log.error("Error generating export XML");
            }
            this.zos.closeEntry();
        }
        this.zos.close();
        this.exportManifest = null;
        this.zos = null;
        return this.exportFile;
    }

    protected void exportDatasources() {
        log.debug("export datasources");
        try {
            List datasources = this.getDatasourceMgmtService().getDatasources();
            for (IDatabaseConnection datasource : datasources) {
                if (!(datasource instanceof DatabaseConnection)) continue;
                this.getExportManifest().addDatasource((DatabaseConnection)datasource);
            }
        }
        catch (DatasourceMgmtServiceException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportMetadataModels() {
        log.debug("export metadata models");
        Set domainIds = this.getMetadataDomainRepository().getDomainIds();
        for (String domainId : domainIds) {
            Map<String, InputStream> domainFilesData = this.getDomainFilesData(domainId);
            for (String fileName : domainFilesData.keySet()) {
                String metadataFilePath = METADATA_PATH_IN_ZIP + fileName;
                if (!metadataFilePath.endsWith(".xmi")) {
                    metadataFilePath = metadataFilePath + ".xmi";
                }
                String metadataZipEntryName = metadataFilePath;
                if (this.withManifest) {
                    metadataZipEntryName = ExportFileNameEncoder.encodeZipPathName(metadataZipEntryName);
                }
                ZipEntry zipEntry = new ZipEntry(metadataZipEntryName);
                InputStream inputStream = domainFilesData.get(fileName);
                try {
                    this.zos.putNextEntry(zipEntry);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)this.zos);
                    ExportManifestMetadata metadata = new ExportManifestMetadata();
                    metadata.setDomainId(domainId);
                    metadata.setFile(metadataFilePath);
                    this.getExportManifest().addMetadata(metadata);
                }
                catch (IOException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                    try {
                        this.zos.closeEntry();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportMondrianSchemas() {
        log.debug("export mondrian schemas");
        List<MondrianCatalog> catalogs = this.getMondrianCatalogService().listCatalogs(this.getSession(), false);
        for (MondrianCatalog catalog : catalogs) {
            Map<String, InputStream> files = this.getMondrianCatalogRepositoryHelper().getModrianSchemaFiles(catalog.getName());
            ExportManifestMondrian mondrian = new ExportManifestMondrian();
            for (String fileName : files.keySet()) {
                String path = ANALYSIS_PATH_IN_ZIP + catalog.getName() + ROOT + fileName;
                ZipEntry zipEntry = new ZipEntry(new ZipEntry(ExportFileNameEncoder.encodeZipPathName(path)));
                InputStream inputStream = files.get(fileName);
                if (fileName.equals("schema.annotated.xml")) continue;
                if ("annotations.xml".equals(fileName)) {
                    mondrian.setAnnotationsFile(path);
                } else {
                    mondrian.setCatalogName(catalog.getName());
                    boolean xmlaEnabled = this.parseXmlaEnabled(catalog.getDataSourceInfo());
                    mondrian.setXmlaEnabled(xmlaEnabled);
                    mondrian.setFile(path);
                    Parameters mondrianParameters = new Parameters();
                    mondrianParameters.put("Provider", "mondrian");
                    mondrianParameters.put("DataSource", StringEscapeUtils.unescapeXml((String)catalog.getJndi()));
                    mondrianParameters.put("EnableXmla", Boolean.toString(xmlaEnabled));
                    StreamSupport.stream(catalog.getConnectProperties().spliterator(), false).filter(p -> !mondrianParameters.containsKey(p.getKey())).forEach(p -> mondrianParameters.put(p.getKey(), StringEscapeUtils.unescapeXml((String)((String)p.getValue()))));
                    mondrian.setParameters(mondrianParameters);
                }
                try {
                    this.zos.putNextEntry(zipEntry);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)this.zos);
                }
                catch (IOException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                    try {
                        this.zos.closeEntry();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (mondrian.getCatalogName() == null || mondrian.getFile() == null) continue;
            this.getExportManifest().addMondrian(mondrian);
        }
    }

    protected boolean parseXmlaEnabled(String dataSourceInfo) {
        String key = "EnableXmla=";
        int pos = dataSourceInfo.indexOf(key);
        if (pos == -1) {
            return false;
        }
        int end = dataSourceInfo.indexOf(";", pos) > -1 ? dataSourceInfo.indexOf(";", pos) : dataSourceInfo.length();
        String xmlaEnabled = dataSourceInfo.substring(pos + key.length(), end);
        return xmlaEnabled == null ? false : Boolean.parseBoolean(xmlaEnabled.replace("\"", ""));
    }

    protected void exportSchedules() {
        log.debug("export schedules");
        try {
            List jobs = this.getScheduler().getJobs(null);
            for (Job job : jobs) {
                if (job.getJobName().equals("PentahoSystemVersionCheck")) continue;
                try {
                    JobScheduleRequest scheduleRequest = ScheduleExportUtil.createJobScheduleRequest(job);
                    this.getExportManifest().addSchedule(scheduleRequest);
                }
                catch (IllegalArgumentException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (SchedulerException e) {
            log.error(Messages.getInstance().getString("PentahoPlatformExporter.ERROR_EXPORTING_JOBS"), (Throwable)e);
        }
    }

    protected void exportUsersAndRoles() {
        List globalUserSettings;
        log.debug("export users & roles");
        IUserRoleListService userRoleListService = (IUserRoleListService)PentahoSystem.get(IUserRoleListService.class);
        UserDetailsService userDetailsService = (UserDetailsService)PentahoSystem.get(UserDetailsService.class);
        IRoleAuthorizationPolicyRoleBindingDao roleBindingDao = (IRoleAuthorizationPolicyRoleBindingDao)PentahoSystem.get(IRoleAuthorizationPolicyRoleBindingDao.class);
        ITenant tenant = TenantUtils.getCurrentTenant();
        IUserSettingService service = this.getUserSettingService();
        List userList = userRoleListService.getAllUsers(tenant);
        for (String user : userList) {
            IAnyUserSettingService userSettings;
            List settings;
            UserExport userExport = new UserExport();
            userExport.setUsername(user);
            userExport.setPassword(userDetailsService.loadUserByUsername(user).getPassword());
            for (String role : userRoleListService.getRolesForUser(tenant, user)) {
                userExport.setRole(role);
            }
            if (service != null && service instanceof IAnyUserSettingService && (settings = (userSettings = (IAnyUserSettingService)service).getUserSettings(user)) != null) {
                for (IUserSetting setting : settings) {
                    userExport.addUserSetting(new ExportManifestUserSetting(setting));
                }
            }
            this.getExportManifest().addUserExport(userExport);
        }
        if (service != null && (globalUserSettings = service.getGlobalUserSettings()) != null) {
            for (IUserSetting setting : globalUserSettings) {
                this.getExportManifest().addGlobalUserSetting(new ExportManifestUserSetting(setting));
            }
        }
        List roles = userRoleListService.getAllRoles();
        for (String role : roles) {
            RoleExport roleExport = new RoleExport();
            roleExport.setRolename(role);
            roleExport.setPermission((List)roleBindingDao.getRoleBindingStruct(null).bindingMap.get(role));
            this.exportManifest.addRoleExport(roleExport);
        }
    }

    protected void exportMetastore() throws IOException {
        log.debug("export the metastore");
        try {
            Path tempDirectory = Files.createTempDirectory(METASTORE, new FileAttribute[0]);
            XmlMetaStore xmlMetaStore = new XmlMetaStore(tempDirectory.toString());
            MetaStoreUtil.copy((IMetaStore)this.getRepoMetaStore(), (IMetaStore)xmlMetaStore);
            File zippedMetastore = Files.createTempFile(METASTORE, ".zip", new FileAttribute[0]).toFile();
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(zippedMetastore));
            this.zipFolder(tempDirectory.toFile(), zipOutputStream, tempDirectory.toString());
            zipOutputStream.close();
            FileInputStream zis = new FileInputStream(zippedMetastore);
            String zipFileLocation = "metastore.mzip";
            ZipEntry metastoreZipFileZipEntry = new ZipEntry(zipFileLocation);
            this.zos.putNextEntry(metastoreZipFileZipEntry);
            try {
                IOUtils.copy((InputStream)zis, (OutputStream)this.zos);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                zis.close();
                this.zos.closeEntry();
            }
            ExportManifestMetaStore exportManifestMetaStore = new ExportManifestMetaStore(zipFileLocation, this.getRepoMetaStore().getName(), this.getRepoMetaStore().getDescription());
            this.getExportManifest().setMetaStore(exportManifestMetaStore);
            zippedMetastore.deleteOnExit();
            tempDirectory.toFile().deleteOnExit();
        }
        catch (Exception e) {
            log.error(Messages.getInstance().getString("PentahoPlatformExporter.ERROR.ExportingMetaStore"));
            log.debug(Messages.getInstance().getString("PentahoPlatformExporter.ERROR.ExportingMetaStore"), (Throwable)e);
        }
    }

    protected IMetaStore getRepoMetaStore() {
        if (this.metastore == null) {
            try {
                this.metastore = MetaStoreExportUtil.connectToRepository(null).getMetaStore();
            }
            catch (KettleException e) {
                log.debug("Can't get the metastore to import into");
            }
        }
        return this.metastore;
    }

    protected void setRepoMetaStore(IMetaStore metastore) {
        this.metastore = metastore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipFolder(File file, ZipOutputStream zos, String pathPrefixToRemove) {
        if (file.isDirectory()) {
            File[] listFiles;
            for (File listFile : listFiles = file.listFiles()) {
                if (listFile.isDirectory()) {
                    this.zipFolder(listFile, zos, pathPrefixToRemove);
                    continue;
                }
                if (!pathPrefixToRemove.endsWith(File.separator)) {
                    pathPrefixToRemove = pathPrefixToRemove + File.separator;
                }
                String path = listFile.getPath().replace(pathPrefixToRemove, "");
                ZipEntry entry = new ZipEntry(path);
                FileInputStream fis = null;
                try {
                    zos.putNextEntry(entry);
                    fis = new FileInputStream(listFile);
                    IOUtils.copy((InputStream)fis, (OutputStream)zos);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        zos.closeEntry();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    IOUtils.closeQuietly((InputStream)fis);
                }
            }
        }
    }

    protected void exportFileContent(RepositoryFile exportRepositoryFile) throws IOException, ExportException {
        String filePath = new File(this.path).getParent();
        if (filePath == null) {
            filePath = ROOT;
        }
        if (exportRepositoryFile == null) {
            throw new FileNotFoundException("JCR file not found: " + this.path);
        }
        if (exportRepositoryFile.isFolder()) {
            this.getExportManifest().getManifestInformation().setRootFolder(this.path.substring(0, this.path.lastIndexOf(ROOT) + 1));
            if (!ClientRepositoryPaths.getRootFolderPath().equals(exportRepositoryFile.getPath())) {
                this.zos.putNextEntry(new ZipEntry(this.getFixedZipEntryName(exportRepositoryFile, filePath)));
            }
            this.exportDirectory(exportRepositoryFile, this.zos, filePath);
        } else {
            this.getExportManifest().getManifestInformation().setRootFolder(this.path.substring(0, this.path.lastIndexOf(ROOT) + 1));
            this.exportFile(exportRepositoryFile, this.zos, filePath);
        }
    }

    protected Map<String, InputStream> getDomainFilesData(String domainId) {
        return ((IPentahoMetadataDomainRepositoryExporter)this.metadataDomainRepository).getDomainFilesData(domainId);
    }

    public IScheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);
        }
        return this.scheduler;
    }

    public void setScheduler(IScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public IMetadataDomainRepository getMetadataDomainRepository() {
        if (this.metadataDomainRepository == null) {
            this.metadataDomainRepository = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, (IPentahoSession)this.getSession());
        }
        return this.metadataDomainRepository;
    }

    public void setMetadataDomainRepository(IMetadataDomainRepository metadataDomainRepository) {
        this.metadataDomainRepository = metadataDomainRepository;
    }

    public IDatasourceMgmtService getDatasourceMgmtService() {
        if (this.datasourceMgmtService == null) {
            this.datasourceMgmtService = (IDatasourceMgmtService)PentahoSystem.get(IDatasourceMgmtService.class, (IPentahoSession)this.getSession());
        }
        return this.datasourceMgmtService;
    }

    public void setDatasourceMgmtService(IDatasourceMgmtService datasourceMgmtService) {
        this.datasourceMgmtService = datasourceMgmtService;
    }

    public MondrianCatalogRepositoryHelper getMondrianCatalogRepositoryHelper() {
        if (this.mondrianCatalogRepositoryHelper == null) {
            this.mondrianCatalogRepositoryHelper = new MondrianCatalogRepositoryHelper(this.getUnifiedRepository());
        }
        return this.mondrianCatalogRepositoryHelper;
    }

    public void setMondrianCatalogRepositoryHelper(MondrianCatalogRepositoryHelper mondrianCatalogRepositoryHelper) {
        this.mondrianCatalogRepositoryHelper = mondrianCatalogRepositoryHelper;
    }

    public IMondrianCatalogService getMondrianCatalogService() {
        if (this.mondrianCatalogService == null) {
            this.mondrianCatalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (IPentahoSession)this.getSession());
        }
        return this.mondrianCatalogService;
    }

    public void setMondrianCatalogService(IMondrianCatalogService mondrianCatalogService) {
        this.mondrianCatalogService = mondrianCatalogService;
    }

    public IUserSettingService getUserSettingService() {
        if (this.userSettingService == null) {
            this.userSettingService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.getSession());
        }
        return this.userSettingService;
    }

    public void setUserSettingService(IUserSettingService userSettingService) {
        this.userSettingService = userSettingService;
    }

    @Override
    protected boolean isExportCandidate(String path) {
        if (path == null) {
            return false;
        }
        String etc = ClientRepositoryPaths.getEtcFolderPath();
        if (path.startsWith(etc)) {
            String etc_operations_mart = etc + ROOT + "operations_mart";
            if (path.equals(etc)) {
                return true;
            }
            return path.startsWith(etc_operations_mart);
        }
        return true;
    }
}

