/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import com.sun.jersey.api.wadl.config.WadlGeneratorConfig;
import com.sun.jersey.api.wadl.config.WadlGeneratorDescription;
import com.sun.jersey.server.wadl.generators.resourcedoc.WadlGeneratorResourceDocSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.util.IWadlDocumentResource;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.servlet.JAXRSPluginServlet;

public class PentahoWadlGeneratorConfig
extends WadlGeneratorConfig {
    public List<WadlGeneratorDescription> configure() {
        WadlGeneratorConfig.WadlGeneratorConfigDescriptionBuilder builder;
        String originalRequest = this.getOriginalRequest();
        Pattern pluginPattern = Pattern.compile(".*\\/plugin\\/([^/]+)\\/api\\/application.wadl");
        Matcher pluginMatcher = pluginPattern.matcher(originalRequest);
        String plugin = null;
        if (pluginMatcher.matches()) {
            plugin = pluginMatcher.group(1);
        }
        if ((builder = this.getBuilder(plugin)) != null) {
            return builder.descriptions();
        }
        return new ArrayList<WadlGeneratorDescription>();
    }

    protected String getOriginalRequest() {
        JAXRSPluginServlet jaxrsPluginServlet = this.getJAXRSPluginServlet();
        String originalRequest = "";
        if (jaxrsPluginServlet != null) {
            originalRequest = (String)JAXRSPluginServlet.requestThread.get();
        }
        if (originalRequest == null || originalRequest.isEmpty()) {
            return "/api/application.wadl";
        }
        return originalRequest;
    }

    protected WadlGeneratorConfig.WadlGeneratorConfigDescriptionBuilder getBuilder(String plugin) {
        List<IWadlDocumentResource> resourceReferences = this.getWadlDocumentResources();
        InputStream is = null;
        try {
            for (IWadlDocumentResource wadlDocumentResource : resourceReferences) {
                if (plugin == null && !wadlDocumentResource.isFromPlugin()) {
                    is = wadlDocumentResource.getResourceAsStream();
                } else {
                    if (!wadlDocumentResource.isFromPlugin() || !wadlDocumentResource.getPluginId().equals(plugin)) continue;
                    is = wadlDocumentResource.getResourceAsStream();
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (is != null) {
            return PentahoWadlGeneratorConfig.generator(WadlGeneratorResourceDocSupport.class).prop("resourceDocStream", is);
        }
        return null;
    }

    protected JAXRSPluginServlet getJAXRSPluginServlet() {
        JAXRSPluginServlet jaxrsPluginServlet;
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
        try {
            jaxrsPluginServlet = (JAXRSPluginServlet)((Object)pluginManager.getBean("api"));
        }
        catch (Exception e) {
            return null;
        }
        return jaxrsPluginServlet;
    }

    protected List<IWadlDocumentResource> getWadlDocumentResources() {
        return PentahoSystem.getAll(IWadlDocumentResource.class);
    }
}

