/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.osgi.registryExtension;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginRegistryExtension;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.RegistryPlugin;
import org.pentaho.di.osgi.OSGIPluginTracker;
import org.pentaho.di.osgi.OSGIPluginType;
import org.pentaho.di.osgi.StatusGetter;
import org.pentaho.di.osgi.service.lifecycle.PluginRegistryOSGIServiceLifecycleListener;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.StandaloneApplicationContext;
import org.pentaho.platform.osgi.KarafBoot;

@RegistryPlugin(id="OSGIRegistryPlugin", name="OSGI")
public class OSGIPluginRegistryExtension
implements PluginRegistryExtension {
    private static OSGIPluginRegistryExtension INSTANCE;
    private OSGIPluginTracker tracker = OSGIPluginTracker.getInstance();
    private Log logger = LogFactory.getLog((String)this.getClass().getName());
    private KarafBoot boot = new KarafBoot();
    private StatusGetter<Boolean> kettleClientEnvironmentInitialized = new StatusGetter<Boolean>(){

        @Override
        public Boolean get() {
            return KettleClientEnvironment.isInitialized();
        }
    };
    private AtomicBoolean initializedKaraf = new AtomicBoolean(false);

    public OSGIPluginRegistryExtension() {
        INSTANCE = this;
    }

    public static OSGIPluginRegistryExtension getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Kettle is supposed to construct this first");
        }
        return INSTANCE;
    }

    protected static void setInstance(OSGIPluginRegistryExtension instance) {
        INSTANCE = instance;
    }

    protected void setTracker(OSGIPluginTracker tracker) {
        this.tracker = tracker;
    }

    protected void setLogger(Log logger) {
        this.logger = logger;
    }

    protected void setKettleClientEnvironmentInitialized(StatusGetter<Boolean> kettleClientEnvironmentInitialized) {
        this.kettleClientEnvironmentInitialized = kettleClientEnvironmentInitialized;
    }

    @VisibleForTesting
    void setKarafBoot(KarafBoot boot) {
        this.boot = boot;
    }

    public KarafBoot getKarafBoot() {
        return this.boot;
    }

    public synchronized void init(PluginRegistry registry) {
        if (PentahoSystem.getInitializedStatus() != 0 && !this.initializedKaraf.getAndSet(true)) {
            String userDir = System.getProperty("pentaho.user.dir", ".");
            StandaloneApplicationContext context = new StandaloneApplicationContext(userDir, userDir);
            PentahoSystem.init((IApplicationContext)context);
            this.boot.startup(null);
        }
        PluginRegistry.addPluginType((PluginTypeInterface)OSGIPluginType.getInstance());
        this.tracker.registerPluginClass(PluginInterface.class);
        this.tracker.addPluginLifecycleListener(PluginInterface.class, new PluginRegistryOSGIServiceLifecycleListener(registry));
    }

    public void searchForType(PluginTypeInterface pluginType) {
        this.tracker.registerPluginClass(pluginType.getClass());
    }

    public String getPluginId(Class<? extends PluginTypeInterface> pluginType, Object pluginClass) {
        try {
            return (String)this.tracker.getBeanPluginProperty(pluginType, pluginClass, "ID");
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

