/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@UDFType(deterministic=false, runtimeConstant=true)
@Description(name="current_date", value="_FUNC_() - Returns the current date at the start of query evaluation. All calls of current_date within the same query return the same value.")
@NDV(maxNdv=1L)
public class GenericUDFCurrentDate
extends GenericUDF {
    protected DateWritableV2 currentDate;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 0) {
            throw new UDFArgumentLengthException("The function CURRENT_DATE does not take any arguments, but found " + arguments.length);
        }
        if (this.currentDate == null) {
            Date dateVal = Date.valueOf((String)SessionState.get().getQueryCurrentTimestamp().toString().substring(0, 10));
            this.currentDate = new DateWritableV2(dateVal);
        }
        return PrimitiveObjectInspectorFactory.writableDateObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        return this.currentDate;
    }

    public DateWritableV2 getCurrentDate() {
        return this.currentDate;
    }

    public void setCurrentDate(DateWritableV2 currentDate) {
        this.currentDate = currentDate;
    }

    @Override
    public String getDisplayString(String[] children) {
        return "CURRENT_DATE()";
    }

    @Override
    public void copyToNewInstance(Object newInstance) throws UDFArgumentException {
        super.copyToNewInstance(newInstance);
        GenericUDFCurrentDate other = (GenericUDFCurrentDate)newInstance;
        if (this.currentDate != null) {
            other.currentDate = new DateWritableV2(this.currentDate);
        }
    }
}

