/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.pig;

import com.pentaho.big.data.bundles.impl.shim.common.ShimBridgingServiceTracker;
import org.osgi.framework.BundleContext;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceFactory;
import org.pentaho.big.data.impl.shim.pig.PigServiceFactoryImpl;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.hadoop.HadoopConfigurationListener;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PigServiceFactoryLoader
implements HadoopConfigurationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PigServiceFactoryLoader.class);
    private final BundleContext bundleContext;
    private final ShimBridgingServiceTracker shimBridgingServiceTracker;

    public PigServiceFactoryLoader(BundleContext bundleContext, ShimBridgingServiceTracker shimBridgingServiceTracker) throws ConfigurationException {
        this(bundleContext, shimBridgingServiceTracker, HadoopConfigurationBootstrap.getInstance());
    }

    public PigServiceFactoryLoader(BundleContext bundleContext, ShimBridgingServiceTracker shimBridgingServiceTracker, HadoopConfigurationBootstrap hadoopConfigurationBootstrap) throws ConfigurationException {
        this.bundleContext = bundleContext;
        this.shimBridgingServiceTracker = shimBridgingServiceTracker;
        hadoopConfigurationBootstrap.registerHadoopConfigurationListener((HadoopConfigurationListener)this);
    }

    public void onConfigurationOpen(HadoopConfiguration hadoopConfiguration, boolean defaultConfiguration) {
        if (hadoopConfiguration == null) {
            return;
        }
        try {
            this.shimBridgingServiceTracker.registerWithClassloader((Object)hadoopConfiguration, NamedClusterServiceFactory.class, PigServiceFactoryImpl.class.getCanonicalName(), this.bundleContext, hadoopConfiguration.getHadoopShim().getClass().getClassLoader(), new Class[]{Boolean.TYPE, HadoopConfiguration.class}, new Object[]{defaultConfiguration, hadoopConfiguration});
        }
        catch (Exception e) {
            LOGGER.error("Unable to register " + hadoopConfiguration.getIdentifier() + " shim", (Throwable)e);
        }
    }

    public void onConfigurationClose(HadoopConfiguration hadoopConfiguration) {
        this.shimBridgingServiceTracker.unregister((Object)hadoopConfiguration);
    }

    public void onClassLoaderAvailable(ClassLoader classLoader) {
    }
}

