/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.libraries.base.LibBaseInfo;
import org.pentaho.reporting.libraries.base.versioning.DependencyInformation;
import org.pentaho.reporting.libraries.base.versioning.ProjectInformation;
import org.pentaho.reporting.libraries.docbundle.LibDocBundleInfo;
import org.pentaho.reporting.libraries.fonts.LibFontInfo;
import org.pentaho.reporting.libraries.formatting.LibFormatInfo;
import org.pentaho.reporting.libraries.formula.LibFormulaInfo;
import org.pentaho.reporting.libraries.repository.LibRepositoryInfo;
import org.pentaho.reporting.libraries.resourceloader.LibLoaderInfo;
import org.pentaho.reporting.libraries.serializer.LibSerializerInfo;
import org.pentaho.reporting.libraries.xmlns.LibXmlInfo;

public final class ClassicEngineInfo
extends ProjectInformation {
    private static ClassicEngineInfo info;

    public static synchronized ClassicEngineInfo getInstance() {
        if (info == null) {
            info = new ClassicEngineInfo();
            info.initialize();
        }
        return info;
    }

    private ClassicEngineInfo() {
        super("classic-core", "Pentaho Reporting Engine Classic");
    }

    private void initialize() {
        this.setInfo("http://reporting.pentaho.org/");
        this.setCopyright("(C)opyright 2000-2011, by Pentaho Corp. and Contributors");
        this.setLicenseName("LGPL");
        this.addLibrary((DependencyInformation)LibBaseInfo.getInstance());
        this.addLibrary((DependencyInformation)LibSerializerInfo.getInstance());
        this.addLibrary((DependencyInformation)LibLoaderInfo.getInstance());
        this.addLibrary((DependencyInformation)LibFormulaInfo.getInstance());
        this.addLibrary((DependencyInformation)LibFontInfo.getInstance());
        this.addLibrary((DependencyInformation)LibFormatInfo.getInstance());
        this.addLibrary((DependencyInformation)LibDocBundleInfo.getInstance());
        this.addLibrary((DependencyInformation)LibXmlInfo.getInstance());
        this.addLibrary((DependencyInformation)LibRepositoryInfo.getInstance());
        this.addOptionalLibrary("org.pentaho.reporting.engine.classic.extensions.ClassicEngineExtensionsInfo");
        this.setBootClass(ClassicEngineBoot.class.getName());
    }

    public static void main(String[] args) {
        ClassicEngineInfo info = new ClassicEngineInfo();
        info.initialize();
        System.out.println(info.getName() + ' ' + info.getVersion());
        System.out.println("----------------------------------------------------------------");
        System.out.println(info.getCopyright());
        System.out.println(info.getInfo());
        System.out.println("----------------------------------------------------------------");
        System.out.println("This project is licenced under the terms of the " + info.getLicenseName() + '.');
        System.exit(0);
    }
}

