/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineInfo;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.core.util.beans.LocaleValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.TimeZoneValueConverter;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class DefaultReportEnvironment
implements ReportEnvironment {
    public static final String ENVIRONMENT_KEY = "org.pentaho.reporting.engine.classic.core.environment.";
    public static final String ENVIRONMENT_TYPE = "org.pentaho.reporting.engine.classic.core.environment-type.";
    private static final Log logger = LogFactory.getLog(DefaultReportEnvironment.class);
    private Configuration configuration;
    private Locale locale;
    private Locale localeFromConfiguration;
    private TimeZone timeZone;
    private TimeZone timeZoneFromConfiguration;

    public DefaultReportEnvironment(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.update(configuration);
    }

    @Override
    public Object getEnvironmentProperty(String key) {
        if ("engine.version".equals(key)) {
            return ClassicEngineInfo.getInstance().getVersion();
        }
        if ("engine.version.major".equals(key)) {
            return ClassicEngineInfo.getInstance().getReleaseMajor();
        }
        if ("engine.version.minor".equals(key)) {
            return ClassicEngineInfo.getInstance().getReleaseMinor();
        }
        if ("engine.version.patch".equals(key)) {
            return ClassicEngineInfo.getInstance().getReleaseMilestone();
        }
        if ("engine.version.candidate-token".equals(key)) {
            return ClassicEngineInfo.getInstance().getReleaseCandidateToken();
        }
        if ("engine.version.buildnumber".equals(key)) {
            return ClassicEngineInfo.getInstance().getReleaseBuildNumber();
        }
        if ("engine.product-id".equals(key)) {
            return ClassicEngineInfo.getInstance().getProductId();
        }
        if ("engine.name".equals(key)) {
            return ClassicEngineInfo.getInstance().getName();
        }
        if ("locale".equals(key)) {
            return this.getLocale().toString();
        }
        if ("locale-short".equals(key)) {
            Locale l = this.getLocale();
            if (StringUtils.isEmpty((String)l.getCountry())) {
                return l.getLanguage();
            }
            return l.getLanguage() + "_" + l.getCountry();
        }
        if ("locale-language".equals(key)) {
            return this.getLocale().getLanguage();
        }
        String configProperty = this.configuration.getConfigProperty(ENVIRONMENT_KEY + key);
        String configType = this.configuration.getConfigProperty(ENVIRONMENT_TYPE + key);
        if (configType == null) {
            return configProperty;
        }
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(DefaultReportEnvironment.class);
            Class<?> aClass = Class.forName(configType, false, loader);
            return ConverterRegistry.toPropertyValue(configProperty, aClass);
        }
        catch (Throwable t) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to convert typed report-environment property");
            }
            return configProperty;
        }
    }

    @Override
    public String getURLEncoding() {
        return this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.URLEncoding");
    }

    public void update(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.configuration = configuration;
        Object localeFromConfig = this.getEnvironmentProperty("designtime.Locale");
        if (localeFromConfig == null) {
            this.localeFromConfiguration = Locale.getDefault();
        } else {
            try {
                this.localeFromConfiguration = (Locale)new LocaleValueConverter().toPropertyValue(String.valueOf(localeFromConfig));
            }
            catch (BeanException e) {
                this.localeFromConfiguration = Locale.getDefault();
            }
        }
        Object timeZoneFromConfig = this.getEnvironmentProperty("designtime.TimeZone");
        if (timeZoneFromConfig == null) {
            this.timeZoneFromConfiguration = TimeZone.getDefault();
        } else {
            try {
                this.timeZoneFromConfiguration = (TimeZone)new TimeZoneValueConverter().toPropertyValue(String.valueOf(timeZoneFromConfig));
            }
            catch (BeanException e) {
                this.timeZoneFromConfiguration = TimeZone.getDefault();
            }
        }
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        this.locale = locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException();
        }
        this.timeZone = timeZone;
    }

    @Override
    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return this.localeFromConfiguration;
    }

    @Override
    public TimeZone getTimeZone() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        return this.timeZoneFromConfiguration;
    }

    @Override
    public Object clone() {
        try {
            DefaultReportEnvironment environment = (DefaultReportEnvironment)super.clone();
            environment.configuration = (Configuration)this.configuration.clone();
            return environment;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException(cne);
        }
    }

    @Override
    public Map<String, String[]> getUrlExtraParameter() {
        return Collections.emptyMap();
    }
}

