/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;

public class ParameterDataRow
extends StaticDataRow {
    private static final String[] EMPTY_NAMES = new String[0];
    private String[] outerNames;

    public ParameterDataRow() {
        this.outerNames = EMPTY_NAMES;
    }

    public ParameterDataRow(String[] names, Object[] values) {
        if (names == null) {
            throw new NullPointerException();
        }
        if (values == null) {
            throw new NullPointerException();
        }
        if (names.length != values.length) {
            throw new NullPointerException();
        }
        int length = names.length;
        System.arraycopy(values, 0, values, 0, length);
        this.setData(names, values);
        this.outerNames = names;
    }

    public ParameterDataRow(ParameterMapping[] parameters, DataRow dataRow) {
        int length = parameters.length;
        String[] outerNames = new String[length];
        String[] innerNames = new String[length];
        Object[] values = new Object[length];
        for (int i = 0; i < length; ++i) {
            ParameterMapping parameter = parameters[i];
            String name = parameter.getName();
            innerNames[i] = parameter.getAlias();
            values[i] = dataRow.get(name);
            outerNames[i] = name;
        }
        this.outerNames = outerNames;
        this.setData(innerNames, values);
    }

    public ParameterDataRow(DataRow dataRow) {
        String[] names = dataRow.getColumnNames();
        int columnCount = names.length;
        String[] innerNames = new String[columnCount];
        int nameCount = 0;
        for (int i = 0; i < columnCount; ++i) {
            String innerName = names[i];
            if (innerName == null || this.contains(innerName, innerNames, nameCount - 1)) continue;
            innerNames[nameCount] = innerName;
            ++nameCount;
        }
        Object[] values = new Object[nameCount];
        for (int i = 0; i < nameCount; ++i) {
            values[i] = dataRow.get(innerNames[i]);
        }
        if (values.length != innerNames.length) {
            this.outerNames = new String[values.length];
            System.arraycopy(innerNames, 0, this.outerNames, 0, values.length);
            this.setData(this.outerNames, values);
        } else {
            this.outerNames = innerNames;
            this.setData(innerNames, values);
        }
    }

    private boolean contains(String name, String[] array, int length) {
        for (int i = 0; i < length; ++i) {
            if (!name.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getParentNames() {
        return (String[])this.outerNames.clone();
    }
}

