/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui;

import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.Query;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.QueryDialogModel;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.QueryDialogModelEvent;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.QueryDialogModelListener;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.ui.Messages;

public class QueryRemoveAction<T>
extends AbstractAction
implements QueryDialogModelListener<T> {
    private QueryDialogModel<T> queries;

    public QueryRemoveAction(QueryDialogModel<T> queries) {
        this.queries = queries;
        this.queries.addQueryDialogModelListener(this);
        URL location = QueryRemoveAction.class.getResource("/org/pentaho/reporting/engine/classic/core/designtime/datafactory/resources/Remove.png");
        if (location != null) {
            this.putValue("SmallIcon", new ImageIcon(location));
        } else {
            this.putValue("Name", Messages.getString("QueryRemoveAction.Name", new Object[0]));
        }
        this.putValue("ShortDescription", Messages.getString("QueryRemoveAction.Description", new Object[0]));
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Query<T> selectedQuery = this.queries.getSelectedQuery();
        if (selectedQuery != null) {
            this.queries.removeQuery(selectedQuery);
        }
    }

    @Override
    public void globalScriptChanged(QueryDialogModelEvent<T> event) {
    }

    @Override
    public void queryAdded(QueryDialogModelEvent<T> event) {
    }

    @Override
    public void queryRemoved(QueryDialogModelEvent<T> event) {
    }

    @Override
    public void queryUpdated(QueryDialogModelEvent<T> event) {
    }

    @Override
    public void queryDataChanged(QueryDialogModelEvent<T> event) {
    }

    @Override
    public void selectionChanged(QueryDialogModelEvent<T> event) {
        this.setEnabled(this.queries.isQuerySelected());
    }
}

