/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.templates;

import java.text.SimpleDateFormat;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.DataRowDataSource;
import org.pentaho.reporting.engine.classic.core.filter.FormatSpecification;
import org.pentaho.reporting.engine.classic.core.filter.RawDataSource;
import org.pentaho.reporting.engine.classic.core.filter.SimpleDateFormatFilter;
import org.pentaho.reporting.engine.classic.core.filter.StringFilter;
import org.pentaho.reporting.engine.classic.core.filter.templates.AbstractTemplate;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;

public class DateFieldTemplate
extends AbstractTemplate
implements RawDataSource {
    private SimpleDateFormatFilter dateFilter;
    private DataRowDataSource dataRowDataSource = new DataRowDataSource();
    private StringFilter stringFilter;

    public DateFieldTemplate() {
        this.dateFilter = new SimpleDateFormatFilter();
        this.dateFilter.setDataSource(this.dataRowDataSource);
        this.stringFilter = new StringFilter();
        this.stringFilter.setDataSource(this.dateFilter);
    }

    public String getFormat() {
        return this.getDateFilter().getFormatString();
    }

    public void setFormat(String format) {
        this.getDateFilter().setFormatString(format);
    }

    public String getField() {
        return this.getDataRowDataSource().getDataSourceColumnName();
    }

    public void setField(String field) {
        this.getDataRowDataSource().setDataSourceColumnName(field);
    }

    public String getFormula() {
        return this.dataRowDataSource.getFormula();
    }

    public void setFormula(String formula) {
        this.dataRowDataSource.setFormula(formula);
    }

    public String getNullValue() {
        return this.getStringFilter().getNullValue();
    }

    public void setNullValue(String nullValue) {
        this.getStringFilter().setNullValue(nullValue);
    }

    public SimpleDateFormat getDateFormat() {
        return (SimpleDateFormat)this.getDateFilter().getFormatter();
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.getDateFilter().setFormatter(dateFormat);
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        return this.getStringFilter().getValue(runtime, element);
    }

    @Override
    public DateFieldTemplate clone() throws CloneNotSupportedException {
        DateFieldTemplate template = (DateFieldTemplate)super.clone();
        template.stringFilter = this.stringFilter.clone();
        template.dateFilter = (SimpleDateFormatFilter)template.stringFilter.getDataSource();
        template.dataRowDataSource = (DataRowDataSource)template.dateFilter.getDataSource();
        return template;
    }

    protected SimpleDateFormatFilter getDateFilter() {
        return this.dateFilter;
    }

    protected DataRowDataSource getDataRowDataSource() {
        return this.dataRowDataSource;
    }

    protected StringFilter getStringFilter() {
        return this.stringFilter;
    }

    @Override
    public Object getRawValue(ExpressionRuntime runtime, ReportElement element) {
        return this.dateFilter.getRawValue(runtime, element);
    }

    @Override
    public FormatSpecification getFormatString(ExpressionRuntime runtime, ReportElement element, FormatSpecification formatSpecification) {
        return this.dateFilter.getFormatString(runtime, element, formatSpecification);
    }
}

