/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.URLEncoder;
import org.pentaho.reporting.libraries.formatting.FastMessageFormat;

public class TextFormatExpression
extends AbstractExpression {
    private static final Log logger = LogFactory.getLog(TextFormatExpression.class);
    private ArrayList fields = new ArrayList();
    private transient Object[] fieldValues;
    private transient Object[] oldFieldValues;
    private transient Locale locale;
    private transient FastMessageFormat messageFormat;
    private String pattern;
    private boolean urlEncodeData;
    private boolean urlEncodeResult;
    private String encoding = "iso-8859-1";
    private String cachedResult;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        this.encoding = encoding;
    }

    public void setUrlEncodeValues(boolean urlEncode) {
        this.urlEncodeData = urlEncode;
    }

    public boolean isUrlEncodeValues() {
        return this.urlEncodeData;
    }

    public boolean isUrlEncodeResult() {
        return this.urlEncodeResult;
    }

    public void setUrlEncodeResult(boolean urlEncodeResult) {
        this.urlEncodeResult = urlEncodeResult;
    }

    @Override
    public Object getValue() {
        if (this.fields.isEmpty()) {
            return this.getPattern();
        }
        ResourceBundleFactory factory = this.getResourceBundleFactory();
        if (this.messageFormat == null || !ObjectUtilities.equal((Object)this.locale, (Object)factory.getLocale())) {
            this.messageFormat = new FastMessageFormat(this.getPattern(), factory.getLocale());
            this.locale = factory.getLocale();
        }
        try {
            String result;
            if (this.oldFieldValues == null || this.oldFieldValues.length != this.fields.size()) {
                this.oldFieldValues = new Object[this.fields.size()];
            } else if (this.fieldValues != null && this.fieldValues.length == this.oldFieldValues.length) {
                System.arraycopy(this.fieldValues, 0, this.oldFieldValues, 0, this.fields.size());
            }
            this.fieldValues = this.getFieldValues(this.fieldValues);
            if (this.cachedResult != null && Arrays.equals(this.oldFieldValues, this.fieldValues)) {
                result = this.cachedResult;
            } else {
                this.cachedResult = result = this.messageFormat.format((Object)this.fieldValues);
            }
            if (this.isUrlEncodeResult()) {
                return URLEncoder.encode((String)result, (String)this.getEncoding());
            }
            return result;
        }
        catch (UnsupportedEncodingException e) {
            logger.debug((Object)("Unsupported Encoding: " + this.encoding));
            return null;
        }
    }

    protected Object[] getFieldValues(Object[] retval) throws UnsupportedEncodingException {
        int size = this.fields.size();
        if (retval == null || retval.length != size) {
            retval = new Object[size];
        }
        DataRow dataRow = this.getDataRow();
        for (int i = 0; i < size; ++i) {
            String field = (String)this.fields.get(i);
            if (field == null) {
                retval[i] = null;
                continue;
            }
            Object fieldValue = dataRow.get(field);
            if (this.isUrlEncodeValues()) {
                if (fieldValue == null) {
                    retval[i] = null;
                    continue;
                }
                if (fieldValue instanceof Date) {
                    retval[i] = fieldValue;
                    continue;
                }
                if (fieldValue instanceof Number) {
                    retval[i] = fieldValue;
                    continue;
                }
                if (this.isUrlEncodeValues()) {
                    retval[i] = URLEncoder.encode((String)String.valueOf(fieldValue), (String)this.encoding);
                    continue;
                }
                retval[i] = fieldValue;
                continue;
            }
            retval[i] = fieldValue;
        }
        return retval;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException();
        }
        this.messageFormat = null;
        this.pattern = pattern;
        this.cachedResult = null;
    }

    @Override
    public Expression getInstance() {
        TextFormatExpression tex = (TextFormatExpression)super.getInstance();
        tex.fields = (ArrayList)this.fields.clone();
        tex.fieldValues = null;
        tex.oldFieldValues = null;
        tex.cachedResult = null;
        return tex;
    }

    public void setField(int index, String field) {
        if (this.fields.size() == index) {
            this.fields.add(field);
        } else {
            this.fields.set(index, field);
        }
        this.fieldValues = null;
        this.oldFieldValues = null;
        this.cachedResult = null;
    }

    public String getField(int index) {
        return (String)this.fields.get(index);
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public String[] getField() {
        return this.fields.toArray(new String[this.fields.size()]);
    }

    public void setField(String[] fields) {
        this.fields.clear();
        this.fields.addAll(Arrays.asList(fields));
        this.fieldValues = null;
        this.oldFieldValues = null;
        this.cachedResult = null;
    }
}

