/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.sys;

import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.FormatSpecification;
import org.pentaho.reporting.engine.classic.core.filter.RawDataSource;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;

public class CellFormatFunction
extends AbstractElementFormatFunction
implements StructureFunction {
    private FormatSpecification formatSpecification;

    @Override
    public int getProcessingPriority() {
        return 30000;
    }

    @Override
    protected boolean isExecutable() {
        return this.getRuntime().getExportDescriptor().startsWith("table/excel");
    }

    @Override
    protected boolean evaluateElement(ReportElement e) {
        ElementType source = e.getElementType();
        if (source instanceof RawDataSource) {
            Object attribute;
            ElementStyleSheet style = e.getStyle();
            String oldFormat = (String)style.getStyleProperty(ElementStyleKeys.EXCEL_DATA_FORMAT_STRING);
            if (oldFormat != null && oldFormat.length() > 0 && !Boolean.TRUE.equals(attribute = e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "excel-cellformat-auto-compute"))) {
                return false;
            }
            RawDataSource rds = (RawDataSource)((Object)source);
            if (this.formatSpecification != null) {
                this.formatSpecification.redefine(0, null);
            }
            this.formatSpecification = rds.getFormatString(this.getRuntime(), e, this.formatSpecification);
            if (this.formatSpecification != null && (this.formatSpecification.getType() == 1 || this.formatSpecification.getType() == 2)) {
                style.setStyleProperty(ElementStyleKeys.EXCEL_DATA_FORMAT_STRING, this.formatSpecification.getFormatString());
                e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "excel-cellformat-auto-compute", Boolean.TRUE);
                return true;
            }
        }
        return false;
    }

    @Override
    public CellFormatFunction getInstance() {
        CellFormatFunction instance = (CellFormatFunction)super.getInstance();
        instance.formatSpecification = null;
        return instance;
    }
}

