/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.SplittableRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.NodeLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.text.ExtendedBaselineInfo;
import org.pentaho.reporting.engine.classic.core.layout.text.Glyph;
import org.pentaho.reporting.engine.classic.core.layout.text.GlyphList;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.text.Spacing;
import org.pentaho.reporting.libraries.fonts.tools.FontStrictGeomUtility;

public final class RenderableText
extends RenderNode
implements SplittableRenderNode {
    private static long conversionFactor;
    private GlyphList glyphs;
    private int offset;
    private int length;
    private int script;
    private long minimumWidth;
    private long preferredWidth;
    private boolean forceLinebreak;
    private ExtendedBaselineInfo baselineInfo;
    private boolean normalTextSpacing;

    public RenderableText(StyleSheet layoutContext, ElementType elementType, InstanceID instanceID, ReportAttributeMap<Object> attributes, ExtendedBaselineInfo baselineInfo, GlyphList glyphs, int offset, int length, int script, boolean forceLinebreak) {
        super(new NodeLayoutProperties(layoutContext, attributes, instanceID, elementType));
        this.initialize(glyphs, offset, length, baselineInfo, script, forceLinebreak);
    }

    protected void initialize(GlyphList glyphs, int offset, int length, ExtendedBaselineInfo baselineInfo, int script, boolean forceLinebreak) {
        if (glyphs == null) {
            throw new NullPointerException();
        }
        if (!forceLinebreak && length == 0) {
            throw new IllegalArgumentException("Do not create zero-length renderable text!");
        }
        if (glyphs.getSize() < offset + length) {
            throw new IllegalArgumentException();
        }
        this.baselineInfo = baselineInfo;
        this.script = script;
        this.glyphs = glyphs;
        this.offset = offset;
        this.length = length;
        this.forceLinebreak = forceLinebreak;
        this.normalTextSpacing = true;
        long wordMinChunkWidth = 0L;
        long minimumChunkWidth = 0L;
        long realCharTotal = 0L;
        long spacerMin = 0L;
        long spacerMax = 0L;
        long spacerOpt = 0L;
        int lastPos = Math.min(glyphs.getSize(), offset + length);
        for (int i = offset; i < lastPos; ++i) {
            Glyph glyph = glyphs.getGlyph(i);
            int kerning = glyph.getKerning();
            int width = glyph.getWidth();
            long realCharSpace = RenderableText.convert(width - kerning);
            realCharTotal += realCharSpace;
            wordMinChunkWidth += realCharSpace;
            if (i != lastPos - 1) {
                Spacing spacing = glyph.getSpacing();
                spacerMax += (long)spacing.getMaximum();
                spacerMin += (long)spacing.getMinimum();
                spacerOpt += (long)spacing.getOptimum();
                if (this.normalTextSpacing && !Spacing.EMPTY_SPACING.equals((Object)spacing)) {
                    this.normalTextSpacing = false;
                }
                wordMinChunkWidth += (long)spacing.getMinimum();
            }
            if (glyph.getBreakWeight() <= 1) continue;
            minimumChunkWidth = Math.max(minimumChunkWidth, wordMinChunkWidth);
            wordMinChunkWidth = 0L;
            if (glyph.getBreakWeight() != 4) continue;
            throw new IllegalStateException("A renderable text cannot and must not contain linebreaks.");
        }
        long wordMinWidth = spacerMin + realCharTotal;
        long wordPrefWidth = spacerOpt + realCharTotal;
        long wordMaxWidth = spacerMax + realCharTotal;
        minimumChunkWidth = Math.max(minimumChunkWidth, wordMinChunkWidth);
        this.minimumWidth = wordMinWidth;
        this.preferredWidth = wordPrefWidth;
        this.setMaximumBoxWidth(wordMaxWidth);
        this.setMinimumChunkWidth(minimumChunkWidth);
    }

    @Override
    public int getNodeType() {
        return 17;
    }

    public boolean isNormalTextSpacing() {
        return this.normalTextSpacing;
    }

    public boolean isForceLinebreak() {
        return this.forceLinebreak;
    }

    public GlyphList getGlyphs() {
        return this.glyphs;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public String getRawText() {
        GlyphList gs = this.getGlyphs();
        return gs.getText(this.offset, this.length, new CodePointBuffer(this.length));
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0 && !this.forceLinebreak;
    }

    @Override
    public boolean isDiscardable() {
        if (this.forceLinebreak) {
            return false;
        }
        return this.glyphs.getSize() == 0;
    }

    public ExtendedBaselineInfo getBaselineInfo() {
        return this.baselineInfo;
    }

    public int getScript() {
        return this.script;
    }

    @Override
    public long getMinimumWidth() {
        return this.minimumWidth;
    }

    public long getPreferredWidth() {
        return this.preferredWidth;
    }

    public String toString() {
        return "RenderableText={glyphs=" + this.glyphs + "'}";
    }

    public static long convert(long fontMetricsValue) {
        return fontMetricsValue * conversionFactor;
    }

    public int computeMaximumTextSize(long contentX2) {
        int length = this.getLength();
        long x = this.getX();
        if (contentX2 >= x + this.getWidth()) {
            return length;
        }
        GlyphList gs = this.getGlyphs();
        long runningPos = x;
        int offset = this.getOffset();
        int maxPos = offset + length;
        for (int i = offset; i < maxPos; ++i) {
            Glyph g = gs.getGlyph(i);
            runningPos += RenderableText.convert(g.getWidth());
            if (i != offset) {
                runningPos += (long)g.getSpacing().getMinimum();
            }
            if (runningPos <= contentX2) continue;
            return Math.max(0, i - offset);
        }
        return length;
    }

    public RenderableText[] splitBy(long widthOfFirst) {
        if (widthOfFirst <= 0L) {
            throw new IllegalArgumentException(String.format("Illegal width: %d. Only text nodes with non-zero width are not allowed!", widthOfFirst));
        }
        if (widthOfFirst >= this.getMinimumWidth()) {
            throw new IllegalStateException(String.format("Split width (%d) should be less than the component's minimum width (%d)!", widthOfFirst, this.getMinimumWidth()));
        }
        if (!this.getStyleSheet().getBooleanStyleProperty(TextStyleKeys.WORDBREAK)) {
            return null;
        }
        int last = this.offset + this.length;
        GlyphList glyphs = this.getGlyphs();
        int index = this.offset;
        for (long currentWidth = 0L; index < last && currentWidth <= widthOfFirst; currentWidth += RenderableText.convert(glyphs.getGlyph(index).getWidth()), ++index) {
        }
        if (--index == this.offset) {
            return null;
        }
        RenderableText first = (RenderableText)this.derive(true);
        int firstLength = index - this.offset;
        first.initialize(glyphs, this.offset, firstLength, this.baselineInfo, this.script, this.forceLinebreak);
        RenderableText rest = (RenderableText)this.derive(true);
        rest.initialize(glyphs, index, this.length - firstLength, this.baselineInfo, this.script, this.forceLinebreak);
        RenderNode[] pair = new RenderableText[]{first, rest};
        RenderBox parent = this.getParent();
        if (parent != null) {
            parent.replaceChilds(this, pair);
        }
        return pair;
    }

    static {
        long value = StrictGeomUtility.toInternalValue(1.0);
        conversionFactor = value / FontStrictGeomUtility.toInternalValue((double)1.0);
    }
}

