/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import java.io.Serializable;
import org.pentaho.reporting.engine.classic.core.layout.output.PhysicalPageKey;

public final class LogicalPageKey
implements Serializable {
    private int position;
    private int width;
    private int height;
    private PhysicalPageKey[] physicalPageKeys;

    public LogicalPageKey(int position, int width, int height) {
        this.position = position;
        this.width = width;
        this.height = height;
        this.physicalPageKeys = new PhysicalPageKey[width * height];
        int pageKeyCount = this.physicalPageKeys.length;
        for (int i = 0; i < pageKeyCount; ++i) {
            this.physicalPageKeys[i] = new PhysicalPageKey(this, i % width, i / width);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPosition() {
        return this.position;
    }

    public PhysicalPageKey getPage(int x, int y) {
        return this.physicalPageKeys[x + y * this.width];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalPageKey that = (LogicalPageKey)o;
        if (this.height != that.height) {
            return false;
        }
        if (this.position != that.position) {
            return false;
        }
        return this.width == that.width;
    }

    public int hashCode() {
        int result = this.position;
        result = 29 * result + this.width;
        result = 29 * result + this.height;
        return result;
    }
}

