/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.PerformanceTags;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.model.FinishedRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnGroupNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.columns.TableColumnModel;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.AbstractMinorAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.MinorAxisLayoutStepUtil;
import org.pentaho.reporting.engine.classic.core.layout.process.text.ComplexTextMinorAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.text.SimpleTextMinorAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.text.TextMinorAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.util.MinorAxisNodeContext;
import org.pentaho.reporting.engine.classic.core.layout.process.util.MinorAxisNodeContextPool;
import org.pentaho.reporting.engine.classic.core.layout.process.util.MinorAxisTableContext;
import org.pentaho.reporting.engine.classic.core.states.PerformanceMonitorContext;
import org.pentaho.reporting.libraries.base.util.PerformanceLoggingStopWatch;

public final class CanvasMinorAxisLayoutStep
extends AbstractMinorAxisLayoutStep {
    private static final Log logger = LogFactory.getLog(CanvasMinorAxisLayoutStep.class);
    private MinorAxisNodeContext nodeContext;
    private MinorAxisNodeContextPool nodeContextPool = new MinorAxisNodeContextPool();
    private PerformanceLoggingStopWatch paragraphLayoutWatch;
    private TextMinorAxisLayoutStep textMinorAxisLayoutStep;

    @Override
    public void initializePerformanceMonitoring(PerformanceMonitorContext monitorContext) {
        super.initializePerformanceMonitoring(monitorContext);
        this.paragraphLayoutWatch = monitorContext.createStopWatch(PerformanceTags.getSummaryTag("pentaho.report.processing.layout.process.", this.getClass().getSimpleName() + ".ParagraphLayout"));
    }

    @Override
    public void close() {
        super.close();
        this.paragraphLayoutWatch.close();
    }

    public void initialize(OutputProcessorMetaData metaData, ProcessingContext processingContext) {
        super.initialize(metaData);
        this.textMinorAxisLayoutStep = metaData.isFeatureSupported(OutputProcessorFeature.COMPLEX_TEXT) ? new ComplexTextMinorAxisLayoutStep(metaData, processingContext.getResourceManager()) : new SimpleTextMinorAxisLayoutStep(metaData);
    }

    @Override
    public void compute(LogicalPageBox root) {
        super.compute(root);
    }

    protected boolean startParagraphBox(RenderBox box) {
        if (box.getNodeType() != 274) {
            return true;
        }
        ParagraphRenderBox paragraphBox = (ParagraphRenderBox)box;
        if (paragraphBox.isLineBoxUnchanged()) {
            this.nodeContext.updateX2(paragraphBox.getCachedMaxChildX2());
            return false;
        }
        this.paragraphLayoutWatch.start();
        try {
            paragraphBox.clearLayout();
            this.textMinorAxisLayoutStep.process(paragraphBox, this.getNodeContext(), this.getPageGrid());
            paragraphBox.updateMinorLayoutAge();
            paragraphBox.setCachedMaxChildX2(this.nodeContext.getMaxChildX2());
        }
        finally {
            this.paragraphLayoutWatch.stop(true);
        }
        return false;
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox box) {
        throw new IllegalStateException("Encountered a paragraph where no paragraph was expected.");
    }

    @Override
    protected MinorAxisNodeContext getNodeContext() {
        return this.nodeContext;
    }

    @Override
    protected boolean startBlockLevelBox(RenderBox box) {
        this.nodeContext = this.nodeContextPool.createContext(box, this.nodeContext, true);
        if (this.checkCacheValid(box)) {
            return false;
        }
        this.startTableContext(box);
        long x = this.nodeContext.getParentX1();
        long left = box.getInsetsLeft();
        long right = box.getInsetsRight();
        long width = MinorAxisLayoutStepUtil.resolveNodeWidthOnStart(box, this.nodeContext, x);
        assert (width >= 0L);
        this.nodeContext.setArea(x, left, right, width);
        return this.startParagraphBox(box);
    }

    @Override
    protected void processBlockLevelNode(RenderNode node) {
        assert (node instanceof FinishedRenderNode);
        node.setCachedX(this.nodeContext.getX1());
        node.setCachedWidth(this.nodeContext.getContentAreaWidth());
    }

    @Override
    protected void finishBlockLevelBox(RenderBox box) {
        try {
            if (this.checkCacheValid(box)) {
                if (box.isVisible()) {
                    this.nodeContext.updateParentX2(box.getCachedX2());
                }
                return;
            }
            box.setCachedX(this.nodeContext.getX());
            box.setContentAreaX1(this.nodeContext.getX1());
            box.setContentAreaX2(this.nodeContext.getX2());
            if (!this.finishTableContext(box)) {
                box.setCachedWidth(MinorAxisLayoutStepUtil.resolveNodeWidthOnFinish(box, this.nodeContext, this.isStrictLegacyMode()));
            }
            if (box.isVisible()) {
                this.nodeContext.updateParentX2(box.getCachedX2());
            }
        }
        finally {
            this.nodeContext = this.nodeContext.pop();
        }
    }

    private long computeCanvasPosition(RenderNode node) {
        long contentAreaX1 = this.nodeContext.getParentX1();
        long bcw = this.nodeContext.getBlockContextWidth();
        double posX = node.getNodeLayoutProperties().getPosX();
        long position = RenderLength.resolveLength(bcw, posX);
        return contentAreaX1 + position;
    }

    @Override
    protected boolean startCanvasLevelBox(RenderBox box) {
        this.nodeContext = this.nodeContextPool.createContext(box, this.nodeContext, false);
        if (this.checkCacheValid(box)) {
            return false;
        }
        this.startTableContext(box);
        long x = this.computeCanvasPosition(box);
        long left = box.getInsetsLeft();
        long right = box.getInsetsRight();
        long width = this.isStrictLegacyMode() && !box.useMinimumChunkWidth() ? MinorAxisLayoutStepUtil.resolveNodeWidthOnStartForCanvasLegacy(box, this.nodeContext, x) : MinorAxisLayoutStepUtil.resolveNodeWidthOnStart(box, this.nodeContext, x);
        assert (width >= 0L);
        this.nodeContext.setArea(x, left, right, width);
        return this.startParagraphBox(box);
    }

    @Override
    protected void processCanvasLevelNode(RenderNode node) {
        assert (node instanceof FinishedRenderNode);
        node.setCachedX(this.computeCanvasPosition(node));
        node.setCachedWidth(node.getMaximumBoxWidth());
        if (node.isVisible()) {
            this.nodeContext.updateParentX2(node.getCachedX2());
        }
    }

    @Override
    protected void finishCanvasLevelBox(RenderBox box) {
        try {
            if (this.checkCacheValid(box)) {
                if (box.isVisible()) {
                    this.nodeContext.updateParentX2(box.getCachedX2());
                }
                return;
            }
            box.setCachedX(this.nodeContext.getX());
            box.setContentAreaX1(this.nodeContext.getX1());
            box.setContentAreaX2(this.nodeContext.getX2());
            if (!this.finishTableContext(box)) {
                box.setCachedWidth(MinorAxisLayoutStepUtil.resolveNodeWidthOnFinish(box, this.nodeContext, this.isStrictLegacyMode()));
            }
            if (box.isVisible()) {
                this.nodeContext.updateParentX2(box.getCachedX2());
            }
        }
        finally {
            this.nodeContext = this.nodeContext.pop();
        }
    }

    private long computeRowPosition(RenderNode node) {
        RenderBox parent = node.getParent();
        if (parent == null) {
            return 0L;
        }
        RenderNode prev = node.getPrev();
        if (prev != null) {
            if (prev.isVisible()) {
                return prev.getCachedX() + prev.getCachedWidth();
            }
            return prev.getCachedX();
        }
        return this.nodeContext.getParentX1();
    }

    @Override
    protected boolean startRowLevelBox(RenderBox box) {
        this.nodeContext = this.nodeContextPool.createContext(box, this.nodeContext, false);
        if (this.checkCacheValid(box)) {
            return false;
        }
        this.startTableContext(box);
        long x = this.computeRowPosition(box);
        long left = box.getInsetsLeft();
        long right = box.getInsetsRight();
        long width = MinorAxisLayoutStepUtil.resolveNodeWidthOnStart(box, this.nodeContext, x);
        assert (width >= 0L);
        this.nodeContext.setArea(x, left, right, width);
        return this.startParagraphBox(box);
    }

    @Override
    protected void processRowLevelNode(RenderNode node) {
        assert (node instanceof FinishedRenderNode);
        node.setCachedX(this.computeRowPosition(node));
        node.setCachedWidth(node.getMaximumBoxWidth());
        if (node.isVisible()) {
            this.nodeContext.updateParentX2(node.getCachedX2());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishRowLevelBox(RenderBox box) {
        try {
            if (this.checkCacheValid(box)) {
                if (box.isVisible()) {
                    this.nodeContext.updateParentX2(box.getCachedX2());
                }
                return;
            }
            box.setCachedX(this.nodeContext.getX());
            box.setContentAreaX1(this.nodeContext.getX1());
            box.setContentAreaX2(this.nodeContext.getX2());
            if (!this.finishTableContext(box)) {
                long cachedWidth = MinorAxisLayoutStepUtil.resolveNodeWidthOnFinish(box, this.nodeContext, this.isStrictLegacyMode());
                box.setCachedWidth(cachedWidth);
            }
            if (box.isVisible()) {
                this.nodeContext.updateParentX2(box.getCachedX2());
            }
        }
        finally {
            this.nodeContext = this.nodeContext.pop();
        }
    }

    @Override
    protected boolean startInlineLevelBox(RenderBox box) {
        throw new InvalidReportStateException("A inline-level box outside of a paragraph box is not allowed.");
    }

    @Override
    protected void processInlineLevelNode(RenderNode node) {
        throw new InvalidReportStateException("A inline-level box outside of a paragraph box is not allowed.");
    }

    @Override
    protected void finishInlineLevelBox(RenderBox box) {
        throw new InvalidReportStateException("A inline-level box outside of a paragraph box is not allowed.");
    }

    @Override
    protected boolean startTableLevelBox(RenderBox box) {
        this.nodeContext = this.nodeContextPool.createContext(box, this.nodeContext, true);
        if (this.checkCacheValid(box)) {
            return false;
        }
        if (box.getNodeType() == 327682) {
            this.startTableColGroup((TableColumnGroupNode)box);
        } else if (box.getNodeType() == 393218) {
            this.startTableCol((TableColumnNode)box);
        } else {
            this.startTableSectionOrRow(box);
        }
        return true;
    }

    private void startTableSectionOrRow(RenderBox box) {
        MinorAxisTableContext tableContext = this.getTableContext();
        long x = this.nodeContext.getParentX1();
        long width = tableContext.isStructureValidated() ? tableContext.getTable().getColumnModel().getCachedSize() : MinorAxisLayoutStepUtil.resolveNodeWidthOnStart(box, this.nodeContext, x);
        this.nodeContext.setArea(x, 0L, 0L, width);
    }

    @Override
    protected void processTableLevelNode(RenderNode node) {
        assert (node instanceof FinishedRenderNode);
        node.setCachedX(this.nodeContext.getX1());
        node.setCachedWidth(this.nodeContext.getContentAreaWidth());
    }

    @Override
    protected void finishTableLevelBox(RenderBox box) {
        try {
            if (this.checkCacheValid(box)) {
                if (box.isVisible()) {
                    this.nodeContext.updateParentX2(box.getCachedX2());
                }
                return;
            }
            if (box.getNodeType() == 327682) {
                this.finishTableColGroup((TableColumnGroupNode)box);
            } else if (box.getNodeType() == 393218) {
                this.finishTableCol((TableColumnNode)box);
            } else {
                box.setCachedX(this.nodeContext.getX());
                box.setContentAreaX1(this.nodeContext.getX1());
                box.setContentAreaX2(this.nodeContext.getX2());
                box.setCachedWidth(this.resolveTableWidthOnFinish(box));
                if (box.isVisible()) {
                    this.nodeContext.updateParentX2(box.getCachedX2());
                }
            }
        }
        finally {
            this.nodeContext = this.nodeContext.pop();
        }
    }

    @Override
    protected boolean startTableSectionLevelBox(RenderBox box) {
        this.nodeContext = this.nodeContextPool.createContext(box, this.nodeContext, true);
        this.startTableSectionOrRow(box);
        return true;
    }

    @Override
    protected void processTableSectionLevelNode(RenderNode node) {
        assert (node instanceof FinishedRenderNode);
        node.setCachedX(this.nodeContext.getX1());
        node.setCachedWidth(this.nodeContext.getContentAreaWidth());
    }

    @Override
    protected void finishTableSectionLevelBox(RenderBox box) {
        try {
            box.setCachedX(this.nodeContext.getX());
            box.setContentAreaX1(this.nodeContext.getX1());
            box.setContentAreaX2(this.nodeContext.getX2());
            box.setCachedWidth(this.resolveTableWidthOnFinish(box));
            if (box.isVisible()) {
                this.nodeContext.updateParentX2(box.getCachedX2());
            }
        }
        finally {
            this.nodeContext = this.nodeContext.pop();
        }
    }

    private long resolveTableWidthOnFinish(RenderBox box) {
        MinorAxisTableContext tableContext = this.getTableContext();
        if (tableContext.isStructureValidated()) {
            return tableContext.getTable().getColumnModel().getCachedSize();
        }
        return MinorAxisLayoutStepUtil.resolveNodeWidthOnFinish(box, this.nodeContext, this.isStrictLegacyMode());
    }

    @Override
    protected boolean startTableRowLevelBox(RenderBox box) {
        this.nodeContext = this.nodeContextPool.createContext(box, this.nodeContext, false);
        if (box.getNodeType() != 294914) {
            this.startTableSectionOrRow(box);
            return true;
        }
        MinorAxisTableContext tableContext = this.getTableContext();
        TableCellRenderBox tableCellRenderBox = (TableCellRenderBox)box;
        int columnIndex = tableCellRenderBox.getColumnIndex();
        TableColumnModel columnModel = tableContext.getColumnModel();
        long startOfRowX = this.nodeContext.getParentX1();
        long x = startOfRowX + columnModel.getCellPosition(columnIndex);
        long insetsLeft = Math.max(box.getInsetsLeft(), columnModel.getBorderSpacing() / 2L);
        long insetsRight = Math.max(box.getInsetsRight(), columnModel.getBorderSpacing() / 2L);
        long width = this.computeCellWidth(tableCellRenderBox);
        this.nodeContext.setArea(x, insetsLeft, insetsRight, width);
        return true;
    }

    @Override
    protected void processTableRowLevelNode(RenderNode node) {
        assert (node instanceof FinishedRenderNode);
        node.setCachedX(this.nodeContext.getX1());
        node.setCachedWidth(this.nodeContext.getContentAreaWidth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishTableRowLevelBox(RenderBox box) {
        try {
            box.setCachedX(this.nodeContext.getX());
            box.setContentAreaX1(this.nodeContext.getX1());
            box.setContentAreaX2(this.nodeContext.getX2());
            if (box.getNodeType() != 294914) {
                box.setCachedWidth(this.resolveTableWidthOnFinish(box));
                if (box.isVisible()) {
                    this.nodeContext.updateParentX2(box.getCachedX2());
                }
            } else {
                box.setCachedWidth(MinorAxisLayoutStepUtil.resolveNodeWidthOnFinish(box, this.nodeContext, this.isStrictLegacyMode()));
                TableCellRenderBox cell = (TableCellRenderBox)box;
                MinorAxisTableContext tableContext = this.getTableContext();
                TableRenderBox table = tableContext.getTable();
                if (!tableContext.isStructureValidated()) {
                    table.getColumnModel().updateCellSize(cell.getColumnIndex(), cell.getColSpan(), box.getCachedWidth() - box.getInsets());
                }
                if (box.isVisible()) {
                    this.nodeContext.updateParentX2(box.getCachedX2());
                }
            }
        }
        finally {
            this.nodeContext = this.nodeContext.pop();
        }
    }

    @Override
    protected boolean startTableCellLevelBox(RenderBox box) {
        return this.startBlockLevelBox(box);
    }

    @Override
    protected void processTableCellLevelNode(RenderNode node) {
        this.processBlockLevelNode(node);
    }

    @Override
    protected void finishTableCellLevelBox(RenderBox box) {
        this.finishBlockLevelBox(box);
    }

    @Override
    protected boolean startTableColGroupLevelBox(RenderBox box) {
        this.nodeContext = this.nodeContextPool.createContext(box, this.nodeContext, false);
        if (this.checkCacheValid(box)) {
            return false;
        }
        if (box.getNodeType() == 393218) {
            this.startTableCol((TableColumnNode)box);
        }
        return true;
    }

    @Override
    protected void finishTableColGroupLevelBox(RenderBox box) {
        try {
            if (this.checkCacheValid(box)) {
                return;
            }
            if (box.getNodeType() == 393218) {
                this.finishTableCol((TableColumnNode)box);
            }
        }
        finally {
            this.nodeContext = this.nodeContext.pop();
        }
    }

    private void startTableCol(TableColumnNode box) {
    }

    private void finishTableCol(TableColumnNode box) {
    }

    private void startTableColGroup(TableColumnGroupNode box) {
    }

    private void finishTableColGroup(TableColumnGroupNode box) {
    }
}

