/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.alignment;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.SplittableRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.AbstractAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineBoxSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineSequenceElement;
import org.pentaho.reporting.engine.classic.core.util.LongList;

public class LeftAlignmentProcessor
extends AbstractAlignmentProcessor {
    private long position;
    private int pageSegment;

    public int getPageSegment() {
        return this.pageSegment;
    }

    public void setPageSegment(int pageSegment) {
        this.pageSegment = pageSegment;
    }

    private long getPosition() {
        return this.position;
    }

    private void setPosition(long position) {
        this.position = position;
    }

    private void addPosition(long width) {
        this.position += width;
    }

    @Override
    public RenderBox next() {
        this.position = this.getStartOfLine();
        this.pageSegment = 0;
        RenderBox retval = super.next();
        this.position = 0L;
        this.pageSegment = 0;
        return retval;
    }

    @Override
    public void performLastLineAlignment() {
        this.position = this.getStartOfLine();
        this.pageSegment = 0;
        super.performLastLineAlignment();
        this.position = 0L;
        this.pageSegment = 0;
    }

    @Override
    protected int handleElement(int start, int count) {
        long elementWidth;
        RenderNode node;
        InlineSequenceElement element;
        int i;
        long lastPageBreak;
        InlineSequenceElement[] sequenceElements = this.getSequenceElements();
        RenderNode[] nodes = this.getNodes();
        long[] elementDimensions = this.getElementDimensions();
        long[] elementPositions = this.getElementPositions();
        long width = 0L;
        int endIndex = start + count;
        InlineSequenceElement contentElement = null;
        int contentIndex = start;
        for (int i2 = start; i2 < endIndex; ++i2) {
            InlineSequenceElement element2 = sequenceElements[i2];
            RenderNode node2 = nodes[i2];
            if (this.isBorderMarker(element2)) {
                width += element2.getMaximumWidth(node2);
                continue;
            }
            width += element2.getMaximumWidth(node2);
            contentElement = element2;
            contentIndex = i2;
        }
        long nextPosition = this.getPosition() + width;
        if (nextPosition > (lastPageBreak = this.getPageBreak(this.getPagebreakCount() - 1))) {
            long position = this.getPosition();
            for (int i3 = start; i3 < endIndex; ++i3) {
                long elementWidth2;
                InlineSequenceElement element3 = sequenceElements[i3];
                RenderNode node3 = nodes[i3];
                elementPositions[i3] = position;
                elementDimensions[i3] = elementWidth2 = element3.getMaximumWidth(node3);
                position += elementWidth2;
            }
            if (nodes[contentIndex] instanceof SplittableRenderNode) {
                this.setSkipIndex(endIndex);
                this.setBreakableIndex(contentIndex);
                this.setBreakableMaxAllowedWidth(nextPosition - lastPageBreak);
                return start;
            }
            if (start == 0) {
                RenderNode node4;
                if (contentElement instanceof InlineBoxSequenceElement && ((node4 = nodes[contentIndex]).getNodeType() & 2) == 2) {
                    long contentPosition = elementPositions[contentIndex];
                    RenderBox box = (RenderBox)node4;
                    long maxWidth = this.getEndOfLine() - contentPosition;
                    this.computeInlineBlock(box, contentPosition, maxWidth);
                    elementDimensions[endIndex - 1] = node4.getCachedWidth();
                }
                this.setSkipIndex(endIndex);
            }
            return start;
        }
        long innerPagebreak = this.getPageBreak(this.getPageSegment());
        if (nextPosition > innerPagebreak) {
            this.setPosition(innerPagebreak);
            this.setPageSegment(this.getPageSegment() + 1);
        }
        if (!(contentElement instanceof InlineBoxSequenceElement)) {
            for (int i4 = start; i4 < endIndex; ++i4) {
                long elementWidth3;
                RenderNode node5 = nodes[i4];
                InlineSequenceElement element4 = sequenceElements[i4];
                elementPositions[i4] = this.getPosition();
                elementDimensions[i4] = elementWidth3 = element4.getMaximumWidth(node5);
                this.addPosition(elementWidth3);
            }
            return endIndex;
        }
        RenderNode contentNode = nodes[contentIndex];
        long itemElementWidth = contentElement.getMaximumWidth(contentNode);
        if ((contentNode.getNodeType() & 2) == 2) {
            RenderBox box = (RenderBox)contentNode;
            this.computeInlineBlock(box, this.getPosition(), itemElementWidth);
        } else {
            contentNode.setCachedX(this.getPosition());
            contentNode.setCachedWidth(itemElementWidth);
        }
        long preferredEndingPos = this.getPosition() + itemElementWidth;
        if (preferredEndingPos > this.getEndOfLine()) {
            if (start == 0) {
                return endIndex;
            }
            return start;
        }
        for (i = start; i < contentIndex; ++i) {
            element = sequenceElements[i];
            node = nodes[contentIndex];
            elementWidth = element.getMaximumWidth(node);
            elementPositions[i] = this.getPosition();
            elementDimensions[i] = elementWidth;
            this.addPosition(elementWidth);
        }
        elementPositions[contentIndex] = this.getPosition();
        elementDimensions[contentIndex] = itemElementWidth;
        this.setPosition(preferredEndingPos);
        for (i = contentIndex + 1; i < endIndex; ++i) {
            element = sequenceElements[i];
            node = nodes[contentIndex];
            elementWidth = element.getMaximumWidth(node);
            elementPositions[i] = this.getPosition();
            elementDimensions[i] = elementWidth;
            this.addPosition(elementWidth);
        }
        return endIndex;
    }

    @Override
    public void performSkipAlignment(int endIndex) {
    }

    @Override
    protected void updateBreaksForLastLineAlignment() {
        long[] horizontalBreaks = this.getPageGrid().getHorizontalBreaks();
        int breakCount = horizontalBreaks.length;
        LongList pageLongList = new LongList(breakCount);
        long endOfLine = this.getEndOfLine();
        long startOfLine = this.getStartOfLine();
        for (int i = 0; i < breakCount; ++i) {
            long pos = horizontalBreaks[i];
            if (pos <= startOfLine) continue;
            if (pos >= endOfLine) break;
            pageLongList.add(pos);
        }
        pageLongList.add(Long.MAX_VALUE);
        long[] pagebreaks = this.getPageBreaks();
        this.updatePageBreaks(pageLongList.toArray(pagebreaks), pageLongList.size());
    }
}

