/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

import org.pentaho.reporting.engine.classic.core.layout.process.util.MinorAxisNodeContextPool;

public class MinorAxisNodeContext {
    private MinorAxisNodeContext parent;
    private MinorAxisNodeContext blockContext;
    private long x;
    private long width;
    private boolean blockNode;
    private boolean horizontal;
    private boolean overflowX;
    private long x1;
    private long x2;
    private boolean blockLevelNode;
    private long maxChildX2;
    private MinorAxisNodeContextPool pool;

    protected MinorAxisNodeContext(MinorAxisNodeContextPool pool) {
        this.pool = pool;
    }

    protected void reuseParent(MinorAxisNodeContext context) {
        this.parent = context;
        this.maxChildX2 = 0L;
        this.width = 0L;
        this.x = 0L;
        this.x1 = 0L;
        this.x2 = 0L;
        if (context != null) {
            this.blockContext = context.blockNode ? context : context.blockContext;
        }
    }

    protected void reuse(boolean horizontal, boolean blockLevelNode, boolean overflowX, boolean blockNode) {
        this.horizontal = horizontal;
        this.blockLevelNode = blockLevelNode;
        this.overflowX = overflowX;
        this.blockNode = blockNode;
    }

    public void setArea(long x, long left, long right, long width) {
        this.x = x;
        this.width = width;
        this.x1 = x + left;
        this.x2 = Math.max(this.x1, x + width - right);
        if (!this.horizontal) {
            this.maxChildX2 = this.x2;
        }
    }

    public long getX1() {
        return this.x1;
    }

    public long getParentX1() {
        if (this.parent == null) {
            return 0L;
        }
        return this.parent.getX1();
    }

    public long getX2() {
        return this.x2;
    }

    public long getMaxChildX2() {
        if (this.horizontal) {
            return Math.max(this.maxChildX2, this.x2);
        }
        return this.maxChildX2;
    }

    public void updateX2(long position) {
        if (this.maxChildX2 < position) {
            this.maxChildX2 = position;
        }
    }

    public void updateParentX2(long position) {
        if (this.parent == null) {
            return;
        }
        if (this.overflowX) {
            return;
        }
        this.parent.updateX2(position);
    }

    public MinorAxisNodeContext pop() {
        MinorAxisNodeContext retval = this.parent;
        this.parent = null;
        if (this.pool != null) {
            this.pool.free(this);
        }
        return retval;
    }

    public long getX() {
        return this.x;
    }

    public long getWidth() {
        return this.width;
    }

    public long getContentAreaWidth() {
        return this.x2 - this.x1;
    }

    public boolean isOverflowX() {
        return this.overflowX;
    }

    public long getResolvedPreferredSize() {
        if (this.parent == null) {
            return 0L;
        }
        if (this.blockLevelNode) {
            return this.parent.getContentAreaWidth();
        }
        return this.getContentAreaWidth();
    }

    public long getBlockContextWidth() {
        if (this.blockContext == null) {
            return 0L;
        }
        return this.blockContext.getContentAreaWidth();
    }

    public long getParentX2() {
        if (this.parent == null) {
            return 0L;
        }
        return this.parent.getX() + this.parent.getWidth();
    }
}

