/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositionList;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;

public final class PaginationResult {
    private PageBreakPositionList allBreaks;
    private boolean overflow;
    private boolean nextPageContainsContent;
    private ReportStateKey lastVisibleState;

    public PaginationResult(PageBreakPositionList allBreaks, boolean overflow, boolean nextPageContainsContent, ReportStateKey lastVisibleState) {
        if (allBreaks == null) {
            throw new NullPointerException();
        }
        this.nextPageContainsContent = nextPageContainsContent;
        this.allBreaks = allBreaks;
        this.overflow = overflow;
        this.lastVisibleState = lastVisibleState;
    }

    public boolean isNextPageContainsContent() {
        return this.nextPageContainsContent;
    }

    public ReportStateKey getLastVisibleState() {
        return this.lastVisibleState;
    }

    public PageBreakPositionList getAllBreaks() {
        return this.allBreaks;
    }

    public boolean isOverflow() {
        return this.overflow;
    }

    public long getLastPosition() {
        return this.allBreaks.getLastMasterBreak();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PaginationResult");
        sb.append("{lastVisibleState=").append(this.lastVisibleState);
        sb.append(", nextPageContainsContent=").append(this.nextPageContainsContent);
        sb.append(", overflow=").append(this.overflow);
        sb.append(", lastPosition=").append(this.getLastPosition());
        sb.append(", allBreaks=").append(this.allBreaks);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaginationResult that = (PaginationResult)o;
        if (this.nextPageContainsContent != that.nextPageContainsContent) {
            return false;
        }
        if (this.overflow != that.overflow) {
            return false;
        }
        return this.allBreaks.equals(that.allBreaks);
    }

    public int hashCode() {
        int result = this.allBreaks.hashCode();
        result = 31 * result + (this.overflow ? 1 : 0);
        result = 31 * result + (this.nextPageContainsContent ? 1 : 0);
        return result;
    }
}

