/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.text;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.text.ExtendedBaselineInfo;
import org.pentaho.reporting.libraries.fonts.registry.BaselineInfo;

public final class DefaultExtendedBaselineInfo
implements ExtendedBaselineInfo {
    private long[] baselines;
    private int dominantBaseline;
    private long underlinePosition;
    private long strikethroughPosition;

    public DefaultExtendedBaselineInfo(int dominantBaseline, BaselineInfo baselines, long beforeEdge, long textBeforeEdge, long textAfterEdge, long afterEdge, long underlinePosition, long strikethroughPosition) {
        if (baselines == null) {
            throw new NullPointerException();
        }
        long[] rawbaselines = baselines.getBaselines();
        this.baselines = new long[10];
        this.baselines[0] = RenderableText.convert(beforeEdge);
        this.baselines[1] = RenderableText.convert(textBeforeEdge);
        this.baselines[2] = RenderableText.convert(rawbaselines[0]);
        this.baselines[3] = RenderableText.convert(rawbaselines[2]);
        this.baselines[4] = RenderableText.convert(rawbaselines[3]);
        this.baselines[5] = RenderableText.convert(rawbaselines[1]);
        this.baselines[6] = RenderableText.convert(rawbaselines[4]);
        this.baselines[7] = RenderableText.convert(rawbaselines[5]);
        this.baselines[8] = RenderableText.convert(textAfterEdge);
        this.baselines[9] = RenderableText.convert(afterEdge);
        this.strikethroughPosition = RenderableText.convert(strikethroughPosition);
        this.underlinePosition = RenderableText.convert(underlinePosition);
        this.dominantBaseline = dominantBaseline;
    }

    @Override
    public long getUnderlinePosition() {
        return this.underlinePosition;
    }

    @Override
    public long getStrikethroughPosition() {
        return this.strikethroughPosition;
    }

    @Override
    public int getDominantBaseline() {
        return this.dominantBaseline;
    }

    @Override
    public long[] getBaselines() {
        return (long[])this.baselines.clone();
    }

    @Override
    public long getBaseline(int baseline) {
        return this.baselines[baseline];
    }

    public String toString() {
        StringBuffer b = new StringBuffer(100);
        b.append("DefaultExtendedBaselineInfo{");
        int length = 10;
        for (int i = 0; i < 10; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append("baselines[");
            b.append(String.valueOf(i));
            b.append("]=");
            b.append(this.getBaseline(i));
        }
        b.append(", dominantBaseline=");
        b.append(this.dominantBaseline);
        b.append('}');
        return b.toString();
    }
}

