/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.AbstractMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyCore;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.MaturityLevel;
import org.pentaho.reporting.engine.classic.core.metadata.ResourceReference;
import org.pentaho.reporting.engine.classic.core.metadata.SharedBeanInfo;
import org.pentaho.reporting.engine.classic.core.metadata.builder.ExpressionPropertyMetaDataBuilder;
import org.pentaho.reporting.engine.classic.core.metadata.propertyeditors.SharedPropertyDescriptorProxy;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.ExpressionPropertyWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.UserDefinedExpressionPropertyReadHandler;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultExpressionPropertyMetaData
extends AbstractMetaData
implements ExpressionPropertyMetaData {
    private static final Log logger = LogFactory.getLog(DefaultExpressionPropertyMetaData.class);
    private boolean mandatory;
    private String propertyRole;
    private Class<? extends PropertyEditor> propertyEditorClass;
    private boolean computed;
    private ExpressionPropertyCore expressionPropertyCore;
    private SharedPropertyDescriptorProxy propertyDescriptor;
    private Class<? extends UserDefinedExpressionPropertyReadHandler> propertyReadHandler;
    private Class<? extends ExpressionPropertyWriteHandler> propertyWriteHandler;
    private boolean designTimeProperty;

    @Deprecated
    public DefaultExpressionPropertyMetaData(String name, String bundleLocation, boolean expert, boolean preferred, boolean hidden, boolean deprecated, boolean mandatory, boolean computed, String propertyRole, SharedBeanInfo beanInfo, String propertyEditorClass, ExpressionPropertyCore expressionPropertyCore, MaturityLevel maturityLevel, int compatibilityLevel, boolean designTimeProperty) {
        super(name, bundleLocation, "property.", expert, preferred, hidden, deprecated, maturityLevel, compatibilityLevel);
        ArgumentNullException.validate((String)"propertyRole", (Object)propertyRole);
        ArgumentNullException.validate((String)"beanInfo", (Object)beanInfo);
        ArgumentNullException.validate((String)"expressionPropertyCore", (Object)expressionPropertyCore);
        this.propertyDescriptor = new SharedPropertyDescriptorProxy(beanInfo, name);
        this.computed = computed;
        this.expressionPropertyCore = expressionPropertyCore;
        this.propertyEditorClass = ObjectUtilities.loadAndValidate((String)propertyEditorClass, DefaultExpressionPropertyMetaData.class, PropertyEditor.class);
        this.mandatory = mandatory;
        this.propertyRole = propertyRole;
        this.designTimeProperty = designTimeProperty;
    }

    public DefaultExpressionPropertyMetaData(ExpressionPropertyMetaDataBuilder builder) {
        super(builder);
        this.propertyDescriptor = builder.getDescriptor();
        this.computed = builder.isComputed();
        this.expressionPropertyCore = builder.getCore();
        this.propertyEditorClass = builder.getEditor();
        this.mandatory = builder.isMandatory();
        this.propertyRole = builder.getValueRole();
        this.propertyReadHandler = builder.getPropertyReadHandler();
        this.propertyWriteHandler = builder.getPropertyWriteHandler();
        this.designTimeProperty = builder.isDesignTime();
        ArgumentNullException.validate((String)"propertyRole", (Object)this.propertyRole);
        ArgumentNullException.validate((String)"propertyDescriptor", (Object)this.propertyDescriptor);
        ArgumentNullException.validate((String)"expressionPropertyCore", (Object)this.expressionPropertyCore);
    }

    @Override
    public boolean isComputed() {
        return this.computed;
    }

    @Override
    public Class<?> getPropertyType() {
        return this.getBeanDescriptor().getPropertyType();
    }

    @Override
    public String getPropertyRole() {
        return this.propertyRole;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public String[] getReferencedFields(Expression element, Object attributeValue) {
        return this.expressionPropertyCore.getReferencedFields(this, element, attributeValue);
    }

    @Override
    public String[] getReferencedGroups(Expression element, Object attributeValue) {
        return this.expressionPropertyCore.getReferencedGroups(this, element, attributeValue);
    }

    @Override
    public String[] getReferencedElements(Expression expression, Object attributeValue) {
        return this.expressionPropertyCore.getReferencedElements(this, expression, attributeValue);
    }

    @Override
    public ResourceReference[] getReferencedResources(Expression expression, Object attributeValue, Element reportElement, ResourceManager resourceManager) {
        return this.expressionPropertyCore.getReferencedResources(this, expression, attributeValue, reportElement, resourceManager);
    }

    @Override
    public PropertyDescriptor getBeanDescriptor() throws IllegalStateException {
        return this.propertyDescriptor.get();
    }

    @Override
    public PropertyEditor getEditor() {
        if (this.propertyEditorClass == null) {
            return null;
        }
        try {
            return this.propertyEditorClass.newInstance();
        }
        catch (Exception e) {
            logger.warn((Object)("Property editor for expression property '" + this.getName() + "' threw an Exception on instantiate"), (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] getExtraCalculationFields() {
        return this.expressionPropertyCore.getExtraCalculationFields(this);
    }

    @Override
    public Class<? extends UserDefinedExpressionPropertyReadHandler> getPropertyReadHandler() {
        return this.propertyReadHandler;
    }

    @Override
    public Class<? extends ExpressionPropertyWriteHandler> getPropertyWriteHandler() {
        return this.propertyWriteHandler;
    }

    @Override
    public boolean isDesignTimeProperty() {
        return this.designTimeProperty;
    }
}

