/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.builder.ElementMetaDataBuilder;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AbstractMetaDataReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AttributeGroupRefReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AttributeReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.GlobalMetaDefinition;
import org.pentaho.reporting.engine.classic.core.metadata.parser.StyleGroupRefReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.StyleReadHandler;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ElementReadHandler
extends AbstractMetaDataReadHandler {
    private ElementMetaDataBuilder builder;
    private ArrayList<StyleReadHandler> styleHandlers;
    private ArrayList<AttributeReadHandler> attributeHandlers;
    private GlobalMetaDefinition globalMetaDefinition;

    public ElementReadHandler(GlobalMetaDefinition globalMetaDefinition) {
        this.globalMetaDefinition = globalMetaDefinition;
        this.attributeHandlers = new ArrayList();
        this.styleHandlers = new ArrayList();
        this.builder = new ElementMetaDataBuilder();
    }

    public ElementMetaDataBuilder getBuilder() {
        return this.builder;
    }

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.getBuilder().namespace(attrs.getValue(this.getUri(), "namespace"));
        this.getBuilder().typeClassification(this.parseTypeClassification(attrs));
        this.getBuilder().elementType(this.parseElementType(attrs));
        this.getBuilder().contentType(this.parseContentType(attrs));
        this.getBuilder().bundle(this.getBundle(), "element.");
    }

    private Class<?> parseContentType(Attributes attrs) throws ParseException {
        String contentType = attrs.getValue(this.getUri(), "content-type");
        if (contentType == null) {
            return Object.class;
        }
        Class aClass = ObjectUtilities.loadAndValidate((String)contentType, ElementReadHandler.class, Object.class);
        if (aClass == null) {
            return Object.class;
        }
        return aClass;
    }

    private Class<? extends ElementType> parseElementType(Attributes attrs) throws ParseException {
        String elementTypeText = attrs.getValue(this.getUri(), "implementation");
        if (elementTypeText == null) {
            throw new ParseException("Attribute 'implementation' is undefined", this.getLocator());
        }
        Class c = ObjectUtilities.loadAndValidate((String)elementTypeText, ElementReadHandler.class, ElementType.class);
        if (c == null) {
            throw new ParseException("Attribute 'implementation' is not valid", this.getLocator());
        }
        return c;
    }

    private ElementMetaData.TypeClassification parseTypeClassification(Attributes attrs) {
        String eType = attrs.getValue(this.getUri(), "type-classification");
        if ("section".equals(eType)) {
            return ElementMetaData.TypeClassification.SECTION;
        }
        if ("data".equals(eType)) {
            return ElementMetaData.TypeClassification.DATA;
        }
        if ("control".equals(eType)) {
            return ElementMetaData.TypeClassification.CONTROL;
        }
        if ("footer".equals(eType)) {
            return ElementMetaData.TypeClassification.FOOTER;
        }
        if ("group-footer".equals(eType)) {
            return ElementMetaData.TypeClassification.RELATIONAL_FOOTER;
        }
        if ("header".equals(eType)) {
            return ElementMetaData.TypeClassification.HEADER;
        }
        if ("group-header".equals(eType)) {
            return ElementMetaData.TypeClassification.RELATIONAL_HEADER;
        }
        if ("subreport".equals(eType)) {
            return ElementMetaData.TypeClassification.SUBREPORT;
        }
        if ("true".equals(attrs.getValue(this.getUri(), "container"))) {
            return ElementMetaData.TypeClassification.SECTION;
        }
        return ElementMetaData.TypeClassification.DATA;
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.getUri().equals(uri)) {
            return null;
        }
        if ("attribute-group-ref".equals(tagName)) {
            return new AttributeGroupRefReadHandler(this.getBuilder().attributesRef(), this.globalMetaDefinition);
        }
        if ("style-group-ref".equals(tagName)) {
            return new StyleGroupRefReadHandler(this.getBuilder().stylesRef(), this.globalMetaDefinition, this.getBundle());
        }
        if ("attribute".equals(tagName)) {
            String prefix = "element." + this.getBuilder().getName() + ".";
            AttributeReadHandler readHandler = new AttributeReadHandler(this.getBundle(), prefix);
            this.attributeHandlers.add(readHandler);
            return readHandler;
        }
        if ("style".equals(tagName)) {
            StyleReadHandler readHandler = new StyleReadHandler(this.getBundle());
            this.styleHandlers.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        MetaData metaData;
        AbstractMetaDataReadHandler handler;
        int i;
        for (i = 0; i < this.attributeHandlers.size(); ++i) {
            handler = this.attributeHandlers.get(i);
            metaData = ((AttributeReadHandler)handler).getMetaData();
            this.getBuilder().attribute((AttributeMetaData)metaData);
        }
        for (i = 0; i < this.styleHandlers.size(); ++i) {
            handler = this.styleHandlers.get(i);
            metaData = ((StyleReadHandler)handler).getMetaData();
            this.getBuilder().style((StyleMetaData)metaData);
        }
    }

    public Object getObject() throws SAXException {
        return new DefaultElementMetaData(this.getBuilder());
    }
}

