/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMap;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMapEntry;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.ParameterReportController;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.ReportController;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.SwingPreviewModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.actions.ZoomAction;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.event.ReportHyperlinkEvent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.event.ReportHyperlinkListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.event.ReportMouseEvent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.event.ReportMouseListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.ActionCategory;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.ActionPluginComparator;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.CategoryTreeItem;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.PageBackgroundDrawable;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.PreviewDrawablePanel;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.PreviewPaneUtilities;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.IconTheme;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.CenterLayout;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportEventSource;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.WindowSizeLimiter;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.PageDrawable;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.PrintReportProcessor;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.Worker;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.KeyedComboBoxModel;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class PreviewPane
extends JPanel
implements ReportEventSource {
    private static final Log logger = LogFactory.getLog(PreviewPane.class);
    private static final double[] ZOOM_FACTORS = new double[]{0.5, 0.75, 1.0, 1.25, 1.5, 2.0};
    private static final int DEFAULT_ZOOM_INDEX = 2;
    public static final String STATUS_TEXT_PROPERTY = "statusText";
    public static final String STATUS_TYPE_PROPERTY = "statusType";
    public static final String REPORT_CONTROLLER_PROPERTY = "reportController";
    public static final String ZOOM_PROPERTY = "zoom";
    public static final String CLOSED_PROPERTY = "closed";
    public static final String ERROR_PROPERTY = "error";
    public static final String REPORT_JOB_PROPERTY = "reportJob";
    public static final String PAGINATING_PROPERTY = "paginating";
    public static final String PAGINATED_PROPERTY = "paginated";
    public static final String PAGE_NUMBER_PROPERTY = "pageNumber";
    public static final String NUMBER_OF_PAGES_PROPERTY = "numberOfPages";
    public static final String ICON_THEME_PROPERTY = "iconTheme";
    public static final String TITLE_PROPERTY = "title";
    public static final String MENU_PROPERTY = "menu";
    public static final String PREVIEW_PREFERRED_WIDTH = "org.pentaho.reporting.engine.classic.core.modules.gui.base.PreferredWidth";
    public static final String PREVIEW_PREFERRED_HEIGHT = "org.pentaho.reporting.engine.classic.core.modules.gui.base.PreferredHeight";
    public static final String PREVIEW_MAXIMUM_WIDTH = "org.pentaho.reporting.engine.classic.core.modules.gui.base.MaximumWidth";
    public static final String PREVIEW_MAXIMUM_HEIGHT = "org.pentaho.reporting.engine.classic.core.modules.gui.base.MaximumHeight";
    public static final String ZOOM_MAXIMUM_KEY = "org.pentaho.reporting.engine.classic.core.modules.gui.base.MaximumZoom";
    public static final String ZOOM_MINIMUM_KEY = "org.pentaho.reporting.engine.classic.core.modules.gui.base.MinimumZoom";
    private static final float ZOOM_MAXIMUM_DEFAULT = 20.0f;
    private static final float ZOOM_MINIMUM_DEFAULT = 0.01f;
    private static final String MENUBAR_AVAILABLE_KEY = "org.pentaho.reporting.engine.classic.core.modules.gui.base.MenuBarAvailable";
    private static final String TOOLBAR_AVAILABLE_KEY = "org.pentaho.reporting.engine.classic.core.modules.gui.base.ToolbarAvailable";
    private static final String TOOLBAR_FLOATABLE_KEY = "org.pentaho.reporting.engine.classic.core.modules.gui.base.ToolbarFloatable";
    private Object paginatingDrawable;
    private Object noReportDrawable;
    private PageBackgroundDrawable pageDrawable;
    private PreviewDrawablePanel drawablePanel;
    private ReportController reportController;
    private JMenu[] menus;
    private JToolBar toolBar;
    private String statusText;
    private Throwable error;
    private String title;
    private StatusType statusType;
    private boolean closed;
    private MasterReport reportJob;
    private int numberOfPages;
    private int pageNumber;
    private SwingGuiContext swingGuiContext;
    private IconTheme iconTheme;
    private double zoom;
    private boolean paginating;
    private boolean paginated;
    private PrintReportProcessor printReportProcessor;
    private Worker paginationWorker;
    private JPanel toolbarHolder;
    private JPanel outerReportControllerHolder;
    private boolean reportControllerInner;
    private String reportControllerLocation;
    private JComponent reportControllerComponent;
    private KeyedComboBoxModel<Double, String> zoomModel;
    private PreviewPaneStatusListener statusListener;
    private static final JMenu[] EMPTY_MENU = new JMenu[0];
    private boolean toolbarFloatable;
    private ArrayList reportProgressListener;
    private double maxZoom;
    private double minZoom;
    private Messages messages = new Messages(this.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.base.messages.messages", ObjectUtilities.getClassLoader(SwingPreviewModule.class));
    private WindowSizeLimiter sizeLimiter = new WindowSizeLimiter();
    private boolean deferredRepagination;
    private ArrayList hyperlinkListeners;
    private transient ReportHyperlinkListener[] cachedHyperlinkListeners;
    private Map<ActionCategory, ActionPlugin[]> actionPlugins;
    private Map<ActionCategory, ZoomAction[]> zoomActions = new HashMap<ActionCategory, ZoomAction[]>();
    private JComboBox zoomSelectorBox;
    private JScrollPane reportPaneScrollPane;
    private int reportControllerSliderSize;
    private boolean performInitializationRunning;

    public PreviewPane() {
        this(true);
    }

    public PreviewPane(boolean init) {
        this.menus = EMPTY_MENU;
        this.setLayout(new BorderLayout());
        this.zoomModel = new KeyedComboBoxModel();
        this.zoomModel.setAllowOtherValue(true);
        this.zoom = ZOOM_FACTORS[2];
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        this.minZoom = this.getMinimumZoom(configuration);
        this.maxZoom = this.getMaximumZoom(configuration);
        this.pageDrawable = new PageBackgroundDrawable();
        this.drawablePanel = new PreviewDrawablePanel();
        this.drawablePanel.setOpaque(false);
        this.drawablePanel.setBackground(null);
        this.drawablePanel.setDoubleBuffered(true);
        this.drawablePanel.setDrawableAsRawObject(this.pageDrawable);
        this.drawablePanel.addReportMouseListener(new HyperLinkEventProcessor());
        this.swingGuiContext = new PreviewGuiContext();
        ScrollablePanel reportPaneHolder = new ScrollablePanel();
        reportPaneHolder.setOpaque(false);
        reportPaneHolder.setBackground(null);
        reportPaneHolder.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        reportPaneHolder.add(this.drawablePanel);
        this.reportPaneScrollPane = new JScrollPane(reportPaneHolder);
        this.reportPaneScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.reportPaneScrollPane.setBackground(null);
        this.reportPaneScrollPane.setOpaque(false);
        this.reportPaneScrollPane.getViewport().setOpaque(false);
        ((JComponent)this.reportPaneScrollPane.getViewport().getView()).setOpaque(false);
        this.toolbarHolder = new JPanel();
        this.toolbarHolder.setLayout(new BorderLayout());
        this.outerReportControllerHolder = new JPanel();
        this.outerReportControllerHolder.setOpaque(false);
        this.outerReportControllerHolder.setBackground(null);
        this.outerReportControllerHolder.setLayout(new BorderLayout());
        this.outerReportControllerHolder.add((Component)this.toolbarHolder, "North");
        this.outerReportControllerHolder.add((Component)this.reportPaneScrollPane, "Center");
        this.add((Component)this.outerReportControllerHolder, "Center");
        this.addPropertyChangeListener(new PreviewUpdateHandler());
        this.addPropertyChangeListener(ZOOM_PROPERTY, new UpdateZoomHandler());
        this.statusListener = new PreviewPaneStatusListener();
        this.zoomSelectorBox = this.createZoomSelector(this);
        this.setReportController(new ParameterReportController());
        if (init) {
            this.initializeWithoutJob();
        }
    }

    protected JComboBox createZoomSelector(PreviewPane pane) {
        JComboBox zoomSelect = new JComboBox(pane.getZoomModel());
        zoomSelect.addActionListener(new ZoomSelectAction(pane.getZoomModel(), pane));
        zoomSelect.setAlignmentX(1.0f);
        return zoomSelect;
    }

    public PreviewDrawablePanel getReportPreviewArea() {
        return this.drawablePanel;
    }

    public boolean isDeferredRepagination() {
        return this.deferredRepagination;
    }

    public void setDeferredRepagination(boolean deferredRepagination) {
        this.deferredRepagination = deferredRepagination;
    }

    public synchronized PrintReportProcessor getPrintReportProcessor() {
        return this.printReportProcessor;
    }

    protected synchronized void setPrintReportProcessor(PrintReportProcessor printReportProcessor) {
        this.printReportProcessor = printReportProcessor;
    }

    public JMenu[] getMenu() {
        return this.menus;
    }

    protected void setMenu(JMenu[] menus) {
        if (menus == null) {
            throw new NullPointerException();
        }
        JMenu[] oldmenu = this.menus;
        this.menus = (JMenu[])menus.clone();
        this.firePropertyChange(MENU_PROPERTY, oldmenu, this.menus);
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String statusText) {
        String oldStatus = this.statusText;
        this.statusText = statusText;
        this.firePropertyChange(STATUS_TEXT_PROPERTY, oldStatus, statusText);
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        Throwable oldError = this.error;
        this.error = error;
        this.firePropertyChange(ERROR_PROPERTY, oldError, error);
    }

    public StatusType getStatusType() {
        return this.statusType;
    }

    public void setStatusType(StatusType statusType) {
        StatusType oldType = this.statusType;
        this.statusType = statusType;
        this.firePropertyChange(STATUS_TYPE_PROPERTY, oldType, statusType);
    }

    public ReportController getReportController() {
        return this.reportController;
    }

    public void setReportController(ReportController reportController) {
        ReportController oldController = this.reportController;
        this.reportController = reportController;
        this.firePropertyChange(REPORT_CONTROLLER_PROPERTY, oldController, reportController);
        if (this.reportController != oldController) {
            if (oldController != null) {
                oldController.deinitialize(this);
            }
            this.refreshReportController(reportController);
        }
    }

    private void refreshReportController(ReportController newReportController) {
        for (int i = 0; i < this.outerReportControllerHolder.getComponentCount(); ++i) {
            Component maybeSplitPane = this.outerReportControllerHolder.getComponent(i);
            if (!(maybeSplitPane instanceof JSplitPane)) continue;
            JSplitPane splitPane = (JSplitPane)maybeSplitPane;
            this.reportControllerSliderSize = splitPane.getDividerLocation();
            break;
        }
        if (newReportController == null) {
            if (this.reportControllerComponent != null) {
                this.outerReportControllerHolder.removeAll();
                this.outerReportControllerHolder.add((Component)this.toolbarHolder, "North");
                this.outerReportControllerHolder.add((Component)this.reportPaneScrollPane, "Center");
                this.reportControllerComponent = null;
                this.reportControllerInner = false;
                this.reportControllerLocation = null;
            }
        } else {
            JComponent rcp = newReportController.getControlPanel();
            if (rcp == null) {
                if (this.reportControllerComponent != null) {
                    this.outerReportControllerHolder.removeAll();
                    this.outerReportControllerHolder.add((Component)this.toolbarHolder, "North");
                    this.outerReportControllerHolder.add((Component)this.reportPaneScrollPane, "Center");
                    this.reportControllerComponent = null;
                    this.reportControllerInner = false;
                    this.reportControllerLocation = null;
                }
            } else if (this.reportControllerComponent != rcp || this.reportControllerInner != newReportController.isInnerComponent() || !ObjectUtilities.equal((Object)this.reportControllerLocation, (Object)newReportController.getControllerLocation())) {
                this.reportControllerLocation = newReportController.getControllerLocation();
                this.reportControllerInner = newReportController.isInnerComponent();
                this.reportControllerComponent = newReportController.getControlPanel();
                this.outerReportControllerHolder.removeAll();
                if (this.reportControllerInner) {
                    JSplitPane innerHolder = new JSplitPane();
                    innerHolder.setOpaque(false);
                    if ("South".equals(this.reportControllerLocation)) {
                        innerHolder.setOrientation(0);
                        innerHolder.setTopComponent(this.reportPaneScrollPane);
                        innerHolder.setBottomComponent(this.reportControllerComponent);
                    } else if ("East".equals(this.reportControllerLocation)) {
                        innerHolder.setOrientation(1);
                        innerHolder.setLeftComponent(this.reportPaneScrollPane);
                        innerHolder.setRightComponent(this.reportControllerComponent);
                    } else if ("West".equals(this.reportControllerLocation)) {
                        innerHolder.setOrientation(1);
                        innerHolder.setRightComponent(this.reportPaneScrollPane);
                        innerHolder.setLeftComponent(this.reportControllerComponent);
                    } else {
                        innerHolder.setOrientation(0);
                        innerHolder.setBottomComponent(this.reportPaneScrollPane);
                        innerHolder.setTopComponent(this.reportControllerComponent);
                    }
                    if (this.reportControllerSliderSize > 0) {
                        innerHolder.setDividerLocation(this.reportControllerSliderSize);
                    }
                    this.outerReportControllerHolder.add((Component)this.toolbarHolder, "North");
                    this.outerReportControllerHolder.add((Component)innerHolder, "Center");
                } else {
                    JPanel reportPaneHolder = new JPanel();
                    reportPaneHolder.setOpaque(false);
                    reportPaneHolder.setLayout(new BorderLayout());
                    reportPaneHolder.add((Component)this.toolbarHolder, "North");
                    reportPaneHolder.add((Component)this.reportPaneScrollPane, "Center");
                    JSplitPane innerHolder = new JSplitPane();
                    if ("South".equals(this.reportControllerLocation)) {
                        innerHolder.setOrientation(0);
                        innerHolder.setTopComponent(reportPaneHolder);
                        innerHolder.setBottomComponent(this.reportControllerComponent);
                    } else if ("East".equals(this.reportControllerLocation)) {
                        innerHolder.setOrientation(1);
                        innerHolder.setLeftComponent(reportPaneHolder);
                        innerHolder.setRightComponent(this.reportControllerComponent);
                    } else if ("West".equals(this.reportControllerLocation)) {
                        innerHolder.setOrientation(1);
                        innerHolder.setRightComponent(reportPaneHolder);
                        innerHolder.setLeftComponent(this.reportControllerComponent);
                    } else {
                        innerHolder.setOrientation(0);
                        innerHolder.setBottomComponent(reportPaneHolder);
                        innerHolder.setTopComponent(this.reportControllerComponent);
                    }
                    if (this.reportControllerSliderSize > 0) {
                        innerHolder.setDividerLocation(this.reportControllerSliderSize);
                    }
                    this.outerReportControllerHolder.add((Component)innerHolder, "Center");
                }
            }
        }
    }

    @Override
    public MasterReport getReportJob() {
        return this.reportJob;
    }

    public void setReportJob(MasterReport reportJob) {
        MasterReport oldJob = this.reportJob;
        this.reportJob = reportJob;
        this.firePropertyChange(REPORT_JOB_PROPERTY, oldJob, reportJob);
        if (reportJob == null) {
            this.killThePaginationWorker();
            this.setPaginated(false);
            this.setPageNumber(0);
            this.setNumberOfPages(0);
            this.refreshReportController(this.reportController);
            this.initializeWithoutJob();
        } else {
            this.refreshReportController(this.reportController);
            this.initializeFromReport();
        }
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        double oldZoom = this.zoom;
        this.zoom = Math.max(Math.min(zoom, this.maxZoom), this.minZoom);
        if (this.zoom != oldZoom) {
            this.firePropertyChange(ZOOM_PROPERTY, oldZoom, zoom);
            this.updateZoomModel(zoom);
        }
    }

    private void updateZoomModel(double zoom) {
        for (int i = 0; i < this.zoomModel.getSize(); ++i) {
            Double d;
            Object o = this.zoomModel.getKeyAt(i);
            if (!(o instanceof Double) || (d = (Double)o) != zoom) continue;
            this.zoomModel.setSelectedKey((Object)d);
            return;
        }
        this.zoomModel.setSelectedItem((Object)this.formatZoomText(zoom));
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        boolean oldClosed = this.closed;
        this.closed = closed;
        this.firePropertyChange(CLOSED_PROPERTY, oldClosed, closed);
        if (closed) {
            this.prepareShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareShutdown() {
        PreviewPane previewPane = this;
        synchronized (previewPane) {
            this.paginationWorker = null;
            if (this.printReportProcessor != null) {
                this.printReportProcessor.cancel();
                this.printReportProcessor.close();
                this.printReportProcessor = null;
            }
            this.closeToolbar();
        }
    }

    private int getUserDefinedCategoryPosition() {
        return ParserUtil.parseInt((String)this.swingGuiContext.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.swing.user-defined-category.position"), (int)15000);
    }

    @Override
    public Locale getLocale() {
        if (this.getParent() == null) {
            try {
                return super.getLocale();
            }
            catch (IllegalComponentStateException ex) {
                return Locale.getDefault();
            }
        }
        return super.getLocale();
    }

    @Override
    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(int numberOfPages) {
        int oldPageNumber = this.numberOfPages;
        this.numberOfPages = numberOfPages;
        this.firePropertyChange(NUMBER_OF_PAGES_PROPERTY, oldPageNumber, numberOfPages);
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        int oldPageNumber = this.pageNumber;
        this.pageNumber = pageNumber;
        this.firePropertyChange(PAGE_NUMBER_PROPERTY, oldPageNumber, pageNumber);
    }

    public IconTheme getIconTheme() {
        return this.iconTheme;
    }

    protected void setIconTheme(IconTheme theme) {
        IconTheme oldTheme = this.iconTheme;
        this.iconTheme = theme;
        this.firePropertyChange(ICON_THEME_PROPERTY, oldTheme, theme);
    }

    protected void initializeFromReport() {
        PageDefinition pageDefinition = this.reportJob.getPageDefinition();
        if (pageDefinition.getPageCount() > 0) {
            PageFormat pageFormat = pageDefinition.getPageFormat(0);
            this.pageDrawable.setDefaultWidth((int)pageFormat.getWidth());
            this.pageDrawable.setDefaultHeight((int)pageFormat.getHeight());
        }
        if (this.reportJob.getTitle() == null) {
            this.setTitle(this.messages.getString("PreviewPane.EMPTY_TITLE"));
        } else {
            this.setTitle(this.messages.getString("PreviewPane.PREVIEW_TITLE", (Object)this.reportJob.getTitle()));
        }
        Configuration configuration = this.reportJob.getConfiguration();
        this.setIconTheme(PreviewPaneUtilities.createIconTheme(configuration));
        this.performInitialization(configuration);
        if (!this.deferredRepagination) {
            this.startPagination();
        }
    }

    protected void initializeWithoutJob() {
        if (this.printReportProcessor != null) {
            this.printReportProcessor.close();
            this.printReportProcessor = null;
        }
        this.setTitle(this.messages.getString("PreviewPane.EMPTY_TITLE"));
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        this.setIconTheme(PreviewPaneUtilities.createIconTheme(configuration));
        this.performInitialization(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void performInitialization(Configuration configuration) {
        if (this.performInitializationRunning) {
            throw new IllegalStateException("This method is not re-entrant");
        }
        try {
            this.performInitializationRunning = true;
            this.applyDefinedDimension(configuration);
            Double key = (Double)this.zoomModel.getSelectedKey();
            this.zoomModel.clear();
            for (int i = 0; i < ZOOM_FACTORS.length; ++i) {
                this.zoomModel.add((Object)new Double(ZOOM_FACTORS[i]), (Object)this.formatZoomText(ZOOM_FACTORS[i]));
            }
            if (key == null) {
                this.updateZoomModel(this.zoom);
            } else {
                this.zoomModel.setSelectedKey((Object)key);
            }
            if (this.actionPlugins != null) {
                for (ActionPlugin[] plugins : this.actionPlugins.values()) {
                    for (int i = 0; i < plugins.length; ++i) {
                        ActionPlugin plugin = plugins[i];
                        plugin.deinitialize(this.swingGuiContext);
                        plugins[i] = null;
                    }
                }
                this.actionPlugins = null;
            }
            this.actionPlugins = PreviewPaneUtilities.loadActions(this.swingGuiContext);
            if ("true".equals(configuration.getConfigProperty(MENUBAR_AVAILABLE_KEY))) {
                this.buildMenu();
            } else {
                this.setMenu(EMPTY_MENU);
            }
            if (this.toolBar != null) {
                this.toolbarHolder.remove(this.toolBar);
            }
            if ("true".equals(configuration.getConfigProperty(TOOLBAR_AVAILABLE_KEY))) {
                boolean floatable = this.isToolbarFloatable() || "true".equals(configuration.getConfigProperty(TOOLBAR_FLOATABLE_KEY));
                this.toolBar = this.buildToolbar(floatable);
            } else {
                this.toolBar = null;
            }
            if (this.toolBar != null) {
                this.toolbarHolder.add((Component)this.toolBar, "North");
            }
        }
        finally {
            this.performInitializationRunning = false;
        }
    }

    private void applyDefinedDimension(Configuration configuration) {
        String width = configuration.getConfigProperty(PREVIEW_PREFERRED_WIDTH);
        String height = configuration.getConfigProperty(PREVIEW_PREFERRED_HEIGHT);
        if (width != null && height != null) {
            try {
                Dimension pref = this.createCorrectedDimensions(Integer.parseInt(width), Integer.parseInt(height));
                this.setPreferredSize(pref);
            }
            catch (Exception nfe) {
                logger.warn((Object)"Preferred viewport size is defined, but the specified values are invalid.");
            }
        }
        width = configuration.getConfigProperty(PREVIEW_MAXIMUM_WIDTH);
        height = configuration.getConfigProperty(PREVIEW_MAXIMUM_HEIGHT);
        this.removeComponentListener(this.sizeLimiter);
        if (width != null || height != null) {
            try {
                int iWidth = width == null ? Short.MAX_VALUE : (int)this.parseRelativeFloat(width);
                int iHeight = height == null ? Short.MAX_VALUE : (int)this.parseRelativeFloat(height);
                Dimension pref = this.createCorrectedDimensions(iWidth, iHeight);
                this.setMaximumSize(pref);
                this.addComponentListener(this.sizeLimiter);
            }
            catch (Exception nfe) {
                logger.warn((Object)"Maximum viewport size is defined, but the specified values are invalid.");
            }
        }
    }

    protected float parseRelativeFloat(String value) {
        if (value == null) {
            throw new NumberFormatException();
        }
        String tvalue = value.trim();
        if (tvalue.length() > 0 && tvalue.charAt(tvalue.length() - 1) == '%') {
            String number = tvalue.substring(0, tvalue.length() - 1);
            return Float.parseFloat(number) * -1.0f;
        }
        return Float.parseFloat(tvalue);
    }

    private Dimension createCorrectedDimensions(int w, int h) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (w < 0) {
            w = w * screenSize.width / -100;
        }
        if (h < 0) {
            h = h * screenSize.height / -100;
        }
        return new Dimension(w, h);
    }

    protected Action[] getToolbarPreActions() {
        return new Action[0];
    }

    protected JToolBar buildToolbar(boolean floatable) {
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(floatable);
        Action[] preActions = this.getToolbarPreActions();
        if (preActions != null && preActions.length > 0) {
            for (int i = 0; i < preActions.length; ++i) {
                this.toolBar.add(preActions[i]);
            }
            this.toolBar.addSeparator();
        }
        ArrayList<ActionPlugin> list = new ArrayList<ActionPlugin>();
        for (ActionPlugin[] plugins : this.actionPlugins.values()) {
            list.addAll(Arrays.asList(plugins));
        }
        ActionPlugin[] plugins = list.toArray(new ActionPlugin[list.size()]);
        Arrays.sort(plugins, new ActionPluginComparator());
        PreviewPaneUtilities.addActionsToToolBar(this.toolBar, plugins, this.zoomSelectorBox, this);
        return this.toolBar;
    }

    public void setToolbarFloatable(boolean toolbarFloatable) {
        this.toolbarFloatable = toolbarFloatable;
    }

    public boolean isToolbarFloatable() {
        return this.toolbarFloatable;
    }

    private void closeToolbar() {
        Window w;
        if (this.toolBar == null) {
            return;
        }
        if (this.toolBar.getParent() != this.toolbarHolder && (w = SwingUtilities.windowForComponent(this.toolBar)) != null) {
            w.setVisible(false);
            w.dispose();
        }
        this.toolBar.setVisible(false);
    }

    public SwingGuiContext getSwingGuiContext() {
        return this.swingGuiContext;
    }

    public KeyedComboBoxModel<Double, String> getZoomModel() {
        return this.zoomModel;
    }

    protected final String formatZoomText(double zoom) {
        NumberFormat numberFormat = NumberFormat.getPercentInstance(this.swingGuiContext.getLocale());
        return numberFormat.format(zoom);
    }

    private void buildMenu() {
        for (ZoomAction[] zoomActions : this.zoomActions.values()) {
            for (int i = 0; i < zoomActions.length; ++i) {
                ZoomAction zoomAction = zoomActions[i];
                zoomAction.deinitialize();
            }
        }
        this.zoomActions.clear();
        HashMap<ActionCategory, JMenu> menus = new HashMap<ActionCategory, JMenu>();
        int userPos = this.getUserDefinedCategoryPosition();
        boolean insertedUserDefinedActions = false;
        ArrayList<ActionCategory> collectedCategories = new ArrayList<ActionCategory>();
        for (Map.Entry<ActionCategory, ActionPlugin[]> entry : this.actionPlugins.entrySet()) {
            ActionCategory cat = entry.getKey();
            collectedCategories.add(cat);
            ActionPlugin[] plugins = entry.getValue();
            if (plugins.length > 0 && plugins[0] == null) {
                throw new NullPointerException();
            }
            if (!insertedUserDefinedActions && cat.getPosition() > userPos) {
                ReportController controller = this.getReportController();
                if (controller != null) {
                    controller.initialize(this);
                    JMenu[] controlerMenus = controller.getMenus();
                    for (int i = 0; i < controlerMenus.length; ++i) {
                        ActionCategory userCategory = new ActionCategory();
                        userCategory.setName("X-User-Category-" + i);
                        userCategory.setPosition(userPos + i);
                        userCategory.setUserDefined(true);
                        menus.put(userCategory, controlerMenus[i]);
                        collectedCategories.add(userCategory);
                    }
                }
                insertedUserDefinedActions = true;
            }
            JMenu menu = PreviewPaneUtilities.createMenu(cat);
            this.zoomActions.put(cat, PreviewPaneUtilities.buildMenu(menu, plugins, this));
            menus.put(cat, menu);
        }
        ActionCategory[] categories = collectedCategories.toArray(new ActionCategory[collectedCategories.size()]);
        CategoryTreeItem[] categoryTreeItems = PreviewPaneUtilities.buildMenuTree(categories);
        ArrayList<CategoryTreeItem> menuList = new ArrayList<CategoryTreeItem>();
        for (int i = 0; i < categoryTreeItems.length; ++i) {
            CategoryTreeItem item = categoryTreeItems[i];
            JMenu menu = (JMenu)menus.get(item.getCategory());
            Object[] childs = item.getChilds();
            Arrays.sort(childs);
            for (int j = 0; j < childs.length; ++j) {
                Object child = childs[j];
                JMenu childMenu = (JMenu)menus.get(((CategoryTreeItem)child).getCategory());
                if (childMenu == null) continue;
                menu.add(childMenu);
            }
            if (item.getParent() != null) continue;
            menuList.add(item);
        }
        Collections.sort(menuList);
        ArrayList<JMenu> retval = new ArrayList<JMenu>();
        for (int i = 0; i < menuList.size(); ++i) {
            CategoryTreeItem item = (CategoryTreeItem)menuList.get(i);
            JMenu menu = (JMenu)menus.get(item.getCategory());
            if (!item.getCategory().isUserDefined() && menu.getItemCount() <= 0) continue;
            retval.add(menu);
        }
        this.setMenu(retval.toArray(new JMenu[retval.size()]));
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String oldTitle = this.title;
        this.title = title;
        this.firePropertyChange(TITLE_PROPERTY, oldTitle, title);
    }

    public double[] getZoomFactors() {
        return (double[])ZOOM_FACTORS.clone();
    }

    @Override
    public boolean isPaginated() {
        return this.paginated;
    }

    public void setPaginated(boolean paginated) {
        boolean oldPaginated = this.paginated;
        this.paginated = paginated;
        this.firePropertyChange(PAGINATED_PROPERTY, oldPaginated, paginated);
    }

    @Override
    public boolean isPaginating() {
        return this.paginating;
    }

    public void setPaginating(boolean paginating) {
        boolean oldPaginating = this.paginating;
        this.paginating = paginating;
        this.firePropertyChange(PAGINATING_PROPERTY, oldPaginating, paginating);
    }

    public synchronized void startPagination() {
        this.killThePaginationWorker();
        if (this.printReportProcessor != null) {
            this.printReportProcessor.close();
            this.printReportProcessor = null;
        }
        this.deferredRepagination = false;
        try {
            MasterReport reportJob = this.getReportJob();
            this.printReportProcessor = new PrintReportProcessor(reportJob);
            this.paginationWorker = this.createWorker();
            this.paginationWorker.setWorkload(new RepaginationRunnable(this.printReportProcessor));
        }
        catch (ReportProcessingException e) {
            logger.error((Object)"Unable to start report pagination:", (Throwable)e);
            this.setStatusType(StatusType.ERROR);
            this.setStatusText(this.messages.getString("PreviewPane.ERROR_ON_PAGINATION"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killThePaginationWorker() {
        if (this.printReportProcessor != null) {
            this.printReportProcessor.cancel();
        }
        if (this.paginationWorker != null) {
            Worker paginationWorker = this.paginationWorker;
            while (!paginationWorker.isAvailable() && !paginationWorker.isFinish()) {
                try {
                    Worker worker = paginationWorker;
                    synchronized (worker) {
                        paginationWorker.wait(500L);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            this.paginationWorker = null;
        }
    }

    protected Worker createWorker() {
        return new Worker();
    }

    public Object getNoReportDrawable() {
        return this.noReportDrawable;
    }

    public void setNoReportDrawable(Object noReportDrawable) {
        this.noReportDrawable = noReportDrawable;
    }

    public Object getPaginatingDrawable() {
        return this.paginatingDrawable;
    }

    public void setPaginatingDrawable(Object paginatingDrawable) {
        this.paginatingDrawable = paginatingDrawable;
    }

    protected void updateVisiblePage(int pageNumber) {
        if (this.printReportProcessor == null) {
            throw new IllegalStateException();
        }
        int pageIndex = this.getPageNumber() - 1;
        if (pageIndex < 0 || pageIndex >= this.printReportProcessor.getNumberOfPages()) {
            this.pageDrawable.setBackend(null);
            this.drawablePanel.setDrawableAsRawObject(this.pageDrawable);
        } else {
            PageDrawable drawable = this.printReportProcessor.getPageDrawable(pageIndex);
            this.pageDrawable.setBackend(drawable);
            this.drawablePanel.setDrawableAsRawObject(this.pageDrawable);
        }
    }

    protected StatusListener getStatusListener() {
        return this.statusListener;
    }

    public void addReportProgressListener(ReportProgressListener progressListener) {
        if (progressListener == null) {
            throw new NullPointerException();
        }
        if (this.reportProgressListener == null) {
            this.reportProgressListener = new ArrayList();
        }
        this.reportProgressListener.add(progressListener);
    }

    public void removeReportProgressListener(ReportProgressListener progressListener) {
        if (this.reportProgressListener == null) {
            return;
        }
        this.reportProgressListener.remove(progressListener);
    }

    protected void forwardReportStartedEvent(ReportProgressEvent event) {
        if (this.reportProgressListener == null) {
            return;
        }
        for (int i = 0; i < this.reportProgressListener.size(); ++i) {
            ReportProgressListener listener = (ReportProgressListener)this.reportProgressListener.get(i);
            listener.reportProcessingStarted(event);
        }
    }

    protected void forwardReportUpdateEvent(ReportProgressEvent event) {
        if (this.reportProgressListener == null) {
            return;
        }
        for (int i = 0; i < this.reportProgressListener.size(); ++i) {
            ReportProgressListener listener = (ReportProgressListener)this.reportProgressListener.get(i);
            listener.reportProcessingUpdate(event);
        }
    }

    protected void forwardReportFinishedEvent(ReportProgressEvent event) {
        if (this.reportProgressListener == null) {
            return;
        }
        for (int i = 0; i < this.reportProgressListener.size(); ++i) {
            ReportProgressListener listener = (ReportProgressListener)this.reportProgressListener.get(i);
            listener.reportProcessingFinished(event);
        }
    }

    private double getMaximumZoom(Configuration configuration) {
        String value = configuration.getConfigProperty(ZOOM_MAXIMUM_KEY);
        return ParserUtil.parseFloat((String)value, (float)20.0f);
    }

    private double getMinimumZoom(Configuration configuration) {
        String value = configuration.getConfigProperty(ZOOM_MINIMUM_KEY);
        return ParserUtil.parseFloat((String)value, (float)0.01f);
    }

    public void addReportHyperlinkListener(ReportHyperlinkListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.hyperlinkListeners == null) {
            this.hyperlinkListeners = new ArrayList();
        }
        this.hyperlinkListeners.add(listener);
        this.cachedHyperlinkListeners = null;
    }

    public void removeReportHyperlinkListener(ReportHyperlinkListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.hyperlinkListeners == null) {
            return;
        }
        this.hyperlinkListeners.remove(listener);
        this.cachedHyperlinkListeners = null;
    }

    protected boolean isHyperlinkSystemActive() {
        if (this.hyperlinkListeners == null) {
            return false;
        }
        return !this.hyperlinkListeners.isEmpty();
    }

    protected void fireReportHyperlinkEvent(ReportHyperlinkEvent event) {
        if (this.hyperlinkListeners == null) {
            return;
        }
        if (this.cachedHyperlinkListeners == null) {
            this.cachedHyperlinkListeners = this.hyperlinkListeners.toArray(new ReportHyperlinkListener[this.hyperlinkListeners.size()]);
        }
        ReportHyperlinkListener[] myListeners = this.cachedHyperlinkListeners;
        for (int i = 0; i < myListeners.length; ++i) {
            ReportHyperlinkListener listener = myListeners[i];
            listener.hyperlinkActivated(event);
        }
    }

    protected Configuration computeContextConfiguration() {
        MasterReport report = this.getReportJob();
        if (report != null) {
            return report.getConfiguration();
        }
        return ClassicEngineBoot.getInstance().getGlobalConfig();
    }

    private static class ZoomSelectAction
    extends AbstractAction {
        private KeyedComboBoxModel source;
        private PreviewPane pane;

        protected ZoomSelectAction(KeyedComboBoxModel source, PreviewPane pane) {
            this.source = source;
            this.pane = pane;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Double selected = (Double)this.source.getSelectedKey();
            if (selected != null) {
                this.pane.setZoom(selected);
            }
        }
    }

    private static class ScrollablePanel
    extends JPanel
    implements Scrollable {
        private ScrollablePanel() {
            this.setLayout(new CenterLayout());
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 100;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private class HyperLinkEventProcessor
    implements ReportMouseListener {
        private boolean mouseLinkActive;

        private HyperLinkEventProcessor() {
        }

        @Override
        public void reportMouseClicked(ReportMouseEvent event) {
            RenderNode renderNode = event.getSourceNode();
            String target = this.extractLink(renderNode, event);
            if (target == null) {
                return;
            }
            String window = (String)renderNode.getStyleSheet().getStyleProperty(ElementStyleKeys.HREF_WINDOW);
            String title = (String)renderNode.getStyleSheet().getStyleProperty(ElementStyleKeys.HREF_TITLE);
            ReportHyperlinkEvent hyEvent = new ReportHyperlinkEvent(PreviewPane.this, renderNode, target, window, title);
            PreviewPane.this.fireReportHyperlinkEvent(hyEvent);
        }

        private String extractLink(RenderNode node, ReportMouseEvent event) {
            String target;
            ImageMap imageMap;
            if (node instanceof RenderableReplacedContentBox && (imageMap = RenderUtility.extractImageMap((RenderableReplacedContentBox)node)) != null) {
                PageDrawable physicalPageDrawable = PreviewPane.this.drawablePanel.getPageDrawable();
                PageFormat pf = physicalPageDrawable.getPageFormat();
                float x1 = (float)((double)event.getSourceEvent().getX() / PreviewPane.this.zoom);
                float y1 = (float)((double)event.getSourceEvent().getY() / PreviewPane.this.zoom);
                float imageMapX = (float)((double)x1 - pf.getImageableX() - StrictGeomUtility.toExternalValue(node.getX()));
                float imageMapY = (float)((double)y1 - pf.getImageableY() - StrictGeomUtility.toExternalValue(node.getY()));
                ImageMapEntry[] imageMapEntries = imageMap.getEntriesForPoint(imageMapX, imageMapY);
                for (int i = 0; i < imageMapEntries.length; ++i) {
                    ImageMapEntry entry = imageMapEntries[i];
                    String imageMapTarget = entry.getAttribute("http://www.w3.org/1999/xhtml", "href");
                    if (imageMapTarget == null) continue;
                    return String.valueOf(imageMapTarget);
                }
            }
            if ((target = (String)node.getStyleSheet().getStyleProperty(ElementStyleKeys.HREF_TARGET)) == null) {
                return null;
            }
            return target;
        }

        @Override
        public void reportMousePressed(ReportMouseEvent event) {
        }

        @Override
        public void reportMouseReleased(ReportMouseEvent event) {
        }

        @Override
        public void reportMouseMoved(ReportMouseEvent event) {
            if (!PreviewPane.this.isHyperlinkSystemActive()) {
                return;
            }
            RenderNode renderNode = event.getSourceNode();
            String target = this.extractLink(renderNode, event);
            if (target == null) {
                if (this.mouseLinkActive) {
                    PreviewPane.this.setCursor(Cursor.getDefaultCursor());
                    this.mouseLinkActive = false;
                }
                return;
            }
            if (!this.mouseLinkActive) {
                PreviewPane.this.setCursor(Cursor.getPredefinedCursor(12));
                this.mouseLinkActive = true;
            }
        }

        @Override
        public void reportMouseDragged(ReportMouseEvent event) {
        }
    }

    private class UpdateZoomHandler
    implements PropertyChangeListener {
        protected UpdateZoomHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!PreviewPane.ZOOM_PROPERTY.equals(evt.getPropertyName())) {
                return;
            }
            double zoom = PreviewPane.this.getZoom();
            PreviewPane.this.pageDrawable.setZoom(zoom);
            KeyedComboBoxModel<Double, String> zoomModel = PreviewPane.this.getZoomModel();
            zoomModel.setSelectedKey((Object)new Double(zoom));
            if (zoomModel.getSelectedKey() == null) {
                zoomModel.setSelectedItem((Object)PreviewPane.this.formatZoomText(zoom));
            }
            PreviewPane.this.drawablePanel.revalidate();
        }
    }

    private class PreviewUpdateHandler
    implements PropertyChangeListener {
        protected PreviewUpdateHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (PreviewPane.PAGINATING_PROPERTY.equals(propertyName)) {
                if (PreviewPane.this.isPaginating()) {
                    PreviewPane.this.getReportPreviewArea().setDrawableAsRawObject(PreviewPane.this.getPaginatingDrawable());
                } else {
                    PreviewPane.this.updateVisiblePage(PreviewPane.this.getPageNumber());
                }
            } else if (PreviewPane.REPORT_JOB_PROPERTY.equals(propertyName)) {
                if (PreviewPane.this.getReportJob() == null) {
                    PreviewPane.this.getReportPreviewArea().setDrawableAsRawObject(PreviewPane.this.getNoReportDrawable());
                }
            } else if (PreviewPane.PAGE_NUMBER_PROPERTY.equals(propertyName)) {
                if (PreviewPane.this.isPaginating()) {
                    return;
                }
                PreviewPane.this.updateVisiblePage(PreviewPane.this.getPageNumber());
            }
        }
    }

    private class UpdatePaginatingPropertyHandler
    implements Runnable {
        private boolean paginating;
        private boolean paginated;
        private int pageCount;
        private PrintReportProcessor processor;

        protected UpdatePaginatingPropertyHandler(PrintReportProcessor processor, boolean paginating, boolean paginated, int pageCount) {
            this.processor = processor;
            this.paginating = paginating;
            this.paginated = paginated;
            this.pageCount = pageCount;
        }

        @Override
        public void run() {
            if (this.processor != PreviewPane.this.getPrintReportProcessor()) {
                logger.debug((Object)PreviewPane.this.messages.getString("PreviewPane.DEBUG_NO_LONGER_VALID"));
                return;
            }
            logger.debug((Object)PreviewPane.this.messages.getString("PreviewPane.DEBUG_PAGINATION", (Object)String.valueOf(this.paginating), (Object)String.valueOf(this.pageCount)));
            if (!this.paginating) {
                PreviewPane.this.setNumberOfPages(this.pageCount);
                if (PreviewPane.this.getPageNumber() < 1) {
                    PreviewPane.this.setPageNumber(1);
                } else if (PreviewPane.this.getPageNumber() > this.pageCount) {
                    PreviewPane.this.setPageNumber(this.pageCount);
                }
            }
            PreviewPane.this.setPaginating(this.paginating);
            PreviewPane.this.setPaginated(this.paginated);
            if (this.processor.isError()) {
                PreviewPane.this.setError(this.processor.getErrorReason());
                PreviewPane.this.setStatusType(StatusType.ERROR);
                PreviewPane.this.setStatusText(this.processor.getErrorReason().getLocalizedMessage());
            }
        }
    }

    private class RepaginationRunnable
    implements Runnable,
    ReportProgressListener {
        private PrintReportProcessor processor;

        protected RepaginationRunnable(PrintReportProcessor processor) {
            this.processor = processor;
        }

        @Override
        public void reportProcessingStarted(ReportProgressEvent event) {
            PreviewPane.this.forwardReportStartedEvent(event);
        }

        @Override
        public void reportProcessingUpdate(ReportProgressEvent event) {
            PreviewPane.this.forwardReportUpdateEvent(event);
        }

        @Override
        public void reportProcessingFinished(ReportProgressEvent event) {
            PreviewPane.this.forwardReportFinishedEvent(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.processor.addReportProgressListener(this);
            try {
                UpdatePaginatingPropertyHandler startPaginationNotify = new UpdatePaginatingPropertyHandler(this.processor, true, false, 0);
                if (SwingUtilities.isEventDispatchThread()) {
                    startPaginationNotify.run();
                } else {
                    SwingUtilities.invokeLater(startPaginationNotify);
                }
                int pageCount = this.processor.getNumberOfPages();
                UpdatePaginatingPropertyHandler endPaginationNotify = new UpdatePaginatingPropertyHandler(this.processor, false, true, pageCount);
                if (SwingUtilities.isEventDispatchThread()) {
                    endPaginationNotify.run();
                } else {
                    SwingUtilities.invokeLater(endPaginationNotify);
                }
            }
            catch (Exception e) {
                UpdatePaginatingPropertyHandler endPaginationNotify = new UpdatePaginatingPropertyHandler(this.processor, false, false, 0);
                if (SwingUtilities.isEventDispatchThread()) {
                    endPaginationNotify.run();
                } else {
                    SwingUtilities.invokeLater(endPaginationNotify);
                }
                logger.error((Object)"Pagination failed.", (Throwable)e);
            }
            finally {
                this.processor.removeReportProgressListener(this);
            }
        }
    }

    private class PreviewPaneStatusListener
    implements StatusListener {
        protected PreviewPaneStatusListener() {
        }

        @Override
        public void setStatus(StatusType type, String text, Throwable error) {
            if (SwingUtilities.isEventDispatchThread()) {
                PreviewPane.this.setStatusType(type);
                PreviewPane.this.setStatusText(text);
                PreviewPane.this.setError(error);
            } else {
                SwingUtilities.invokeLater(new PreviewPaneStatusUpdater(type, text, error));
            }
        }
    }

    private class PreviewPaneStatusUpdater
    implements Runnable {
        private StatusType type;
        private String text;
        private Throwable error;

        protected PreviewPaneStatusUpdater(StatusType type, String text, Throwable error) {
            this.type = type;
            this.text = text;
            this.error = error;
        }

        public Throwable getError() {
            return this.error;
        }

        public StatusType getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }

        @Override
        public void run() {
            PreviewPane.this.setStatusType(this.type);
            PreviewPane.this.setStatusText(this.text);
            PreviewPane.this.setError(this.error);
        }
    }

    private class PreviewGuiContext
    implements SwingGuiContext {
        protected PreviewGuiContext() {
        }

        @Override
        public Window getWindow() {
            return LibSwingUtil.getWindowAncestor((Component)PreviewPane.this);
        }

        @Override
        public Locale getLocale() {
            MasterReport report = PreviewPane.this.getReportJob();
            if (report != null) {
                Locale bundleLocale = report.getResourceBundleFactory().getLocale();
                if (bundleLocale != null) {
                    return bundleLocale;
                }
                return report.getReportEnvironment().getLocale();
            }
            return Locale.getDefault();
        }

        @Override
        public IconTheme getIconTheme() {
            return PreviewPane.this.getIconTheme();
        }

        @Override
        public Configuration getConfiguration() {
            return PreviewPane.this.computeContextConfiguration();
        }

        @Override
        public StatusListener getStatusListener() {
            return PreviewPane.this.getStatusListener();
        }

        @Override
        public ReportEventSource getEventSource() {
            return PreviewPane.this;
        }
    }
}

