/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.csv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.AbstractExportDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.EncodingComboBoxModel;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.JStatusBar;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.LengthLimitingDocument;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;

public class CSVDataExportDialog
extends AbstractExportDialog {
    public static final String CSV_OUTPUT_ENCODING_DEFAULT = EncodingRegistry.getPlatformDefaultEncoding();
    private JTextField txFilename;
    private JComboBox cbEncoding;
    private EncodingComboBoxModel encodingModel;
    private JCheckBox cbxEnableReportHeader;
    private JCheckBox cbxEnableReportFooter;
    private JCheckBox cbxEnableGroupHeader;
    private JCheckBox cbxEnableGroupFooter;
    private JCheckBox cbxEnableItemband;
    private JCheckBox cbxWriteStateColumns;
    private JCheckBox cbxColumnNamesAsFirstRow;
    private JRadioButton rbSeparatorTab;
    private JRadioButton rbSeparatorColon;
    private JRadioButton rbSeparatorSemicolon;
    private JRadioButton rbSeparatorOther;
    private JTextField txSeparatorOther;
    private JStatusBar statusBar;
    private JFileChooser fileChooser;
    private static final String COMMA_SEPARATOR = ",";
    private static final String SEMICOLON_SEPARATOR = ";";
    private static final String TAB_SEPARATOR = "\t";
    private static final String CSV_FILE_EXTENSION = ".csv";

    public CSVDataExportDialog(Frame owner) {
        super(owner);
        this.initConstructor();
    }

    public CSVDataExportDialog(Dialog owner) {
        super(owner);
        this.initConstructor();
    }

    public CSVDataExportDialog() {
        this.initConstructor();
    }

    private void initConstructor() {
        this.statusBar = new JStatusBar();
        this.setTitle(this.getResources().getString("csvexportdialog.dialogtitle"));
        this.initialize();
        this.clear();
        this.getFormValidator().setEnabled(true);
    }

    @Override
    public JStatusBar getStatusBar() {
        return this.statusBar;
    }

    @Override
    protected String getResourceBaseName() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.csv.messages.messages";
    }

    private void initialize() {
        this.cbxWriteStateColumns = new JCheckBox(this.getResources().getString("csvexportdialog.write-state-columns"));
        this.cbxColumnNamesAsFirstRow = new JCheckBox(this.getResources().getString("cvsexportdialog.export.columnnames"));
        this.getFormValidator().registerButton(this.cbxColumnNamesAsFirstRow);
        this.cbxEnableReportHeader = new JCheckBox(this.getResources().getString("csvexportdialog.enable-report-header"));
        this.cbxEnableReportFooter = new JCheckBox(this.getResources().getString("csvexportdialog.enable-report-footer"));
        this.cbxEnableItemband = new JCheckBox(this.getResources().getString("csvexportdialog.enable-itemband"));
        this.cbxEnableGroupHeader = new JCheckBox(this.getResources().getString("csvexportdialog.enable-group-header"));
        this.cbxEnableGroupFooter = new JCheckBox(this.getResources().getString("csvexportdialog.enable-group-footer"));
        this.getFormValidator().registerButton(this.cbxEnableGroupFooter);
        this.getFormValidator().registerButton(this.cbxEnableGroupHeader);
        this.getFormValidator().registerButton(this.cbxEnableItemband);
        this.getFormValidator().registerButton(this.cbxEnableReportFooter);
        this.getFormValidator().registerButton(this.cbxEnableReportHeader);
        this.txFilename = new JTextField();
        this.txFilename.setColumns(30);
        this.encodingModel = EncodingComboBoxModel.createDefaultModel(Locale.getDefault());
        this.encodingModel.sort();
        this.cbEncoding = new JComboBox(this.encodingModel);
        JPanel exportPane = this.createExportPane();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(this.getResources().getString("csvexportdialog.export-settings"), exportPane);
        tabbedPane.add(this.getResources().getString("csvexportdialog.parameters"), this.getParametersPanel());
        Configuration config = ClassicEngineBoot.getInstance().getGlobalConfig();
        if ("true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.csv.data.AdvancedSettingsAvailable"))) {
            tabbedPane.add(this.getResources().getString("csvexportdialog.advanced-settings"), this.createAdvancedOptionsPanel());
        }
        this.setContentPane(this.createContentPane(tabbedPane));
        this.getFormValidator().registerTextField(this.txFilename);
        this.getFormValidator().registerComboBox(this.cbEncoding);
    }

    private JPanel createAdvancedOptionsPanel() {
        JPanel advancedOptionsPane = new JPanel();
        advancedOptionsPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(10, 1, 1, 1);
        advancedOptionsPane.add((Component)this.createExportOptionsPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(10, 1, 1, 1);
        advancedOptionsPane.add((Component)this.createSeparatorPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(10, 1, 1, 1);
        advancedOptionsPane.add((Component)this.createExportTypePanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 1, 1, 1);
        advancedOptionsPane.add((Component)new JPanel(), gbc);
        return advancedOptionsPane;
    }

    private JPanel createExportPane() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JLabel lblFileName = new JLabel(this.getResources().getString("csvexportdialog.filename"));
        JButton btnSelect = new JButton(new ActionSelectFile(this.getResources()));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 5);
        contentPane.add((Component)lblFileName, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(3, 1, 5, 1);
        contentPane.add((Component)this.txFilename, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.insets = new Insets(1, 5, 5, 1);
        contentPane.add((Component)btnSelect, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 1, 1, 1);
        contentPane.add((Component)new JPanel(), gbc);
        return contentPane;
    }

    private JPanel createExportTypePanel() {
        JPanel exportTypePanel = new JPanel();
        exportTypePanel.setLayout(new BorderLayout());
        TitledBorder tb = new TitledBorder(this.getResources().getString("csvexportdialog.exported-bands"));
        exportTypePanel.setBorder(tb);
        JPanel rowTypePanel = new JPanel();
        rowTypePanel.setLayout(new GridLayout(2, 3, 5, 2));
        rowTypePanel.add(this.cbxEnableReportHeader);
        rowTypePanel.add(this.cbxEnableGroupHeader);
        rowTypePanel.add(this.cbxEnableItemband);
        rowTypePanel.add(this.cbxEnableReportFooter);
        rowTypePanel.add(this.cbxEnableGroupFooter);
        exportTypePanel.add((Component)rowTypePanel, "West");
        return exportTypePanel;
    }

    private JPanel createExportOptionsPanel() {
        JPanel exportTypePanel = new JPanel();
        exportTypePanel.setLayout(new GridBagLayout());
        JLabel lblEncoding = new JLabel(this.getResources().getString("csvexportdialog.encoding"));
        TitledBorder tb = new TitledBorder(this.getResources().getString("csvexportdialog.export-options"));
        exportTypePanel.setBorder(tb);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 5);
        exportTypePanel.add((Component)lblEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 1, 1, 1);
        exportTypePanel.add((Component)this.cbEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 1, 1, 1);
        exportTypePanel.add((Component)this.cbxColumnNamesAsFirstRow, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        exportTypePanel.add((Component)this.cbxWriteStateColumns, gbc);
        return exportTypePanel;
    }

    private JPanel createSeparatorPanel() {
        JPanel separatorPanel = new JPanel();
        separatorPanel.setLayout(new GridBagLayout());
        TitledBorder tb = new TitledBorder(this.getResources().getString("csvexportdialog.separatorchar"));
        separatorPanel.setBorder(tb);
        this.rbSeparatorTab = new JRadioButton(this.getResources().getString("csvexportdialog.separator.tab"));
        this.rbSeparatorColon = new JRadioButton(this.getResources().getString("csvexportdialog.separator.colon"));
        this.rbSeparatorSemicolon = new JRadioButton(this.getResources().getString("csvexportdialog.separator.semicolon"));
        this.rbSeparatorOther = new JRadioButton(this.getResources().getString("csvexportdialog.separator.other"));
        this.getFormValidator().registerButton(this.rbSeparatorColon);
        this.getFormValidator().registerButton(this.rbSeparatorOther);
        this.getFormValidator().registerButton(this.rbSeparatorSemicolon);
        this.getFormValidator().registerButton(this.rbSeparatorTab);
        ButtonGroup btg = new ButtonGroup();
        btg.add(this.rbSeparatorTab);
        btg.add(this.rbSeparatorColon);
        btg.add(this.rbSeparatorSemicolon);
        btg.add(this.rbSeparatorOther);
        ActionSelectSeparator selectAction = new ActionSelectSeparator();
        this.rbSeparatorTab.addActionListener(selectAction);
        this.rbSeparatorColon.addActionListener(selectAction);
        this.rbSeparatorSemicolon.addActionListener(selectAction);
        this.rbSeparatorOther.addActionListener(selectAction);
        LengthLimitingDocument ldoc = new LengthLimitingDocument(1);
        this.txSeparatorOther = new JTextField();
        this.txSeparatorOther.setDocument(ldoc);
        this.txSeparatorOther.setColumns(5);
        this.getFormValidator().registerTextField(this.txSeparatorOther);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorTab, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorColon, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorSemicolon, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorOther, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.txSeparatorOther, gbc);
        return separatorPanel;
    }

    public String getFilename() {
        return this.txFilename.getText();
    }

    public void setFilename(String filename) {
        this.txFilename.setText(filename);
    }

    @Override
    public void clear() {
        this.txFilename.setText("");
        this.cbEncoding.setSelectedIndex(this.encodingModel.indexOf(EncodingRegistry.getPlatformDefaultEncoding()));
        this.rbSeparatorColon.setSelected(true);
        this.cbxColumnNamesAsFirstRow.setSelected(false);
        this.performSeparatorSelection();
    }

    @Override
    protected Configuration grabDialogContents(boolean full) {
        DefaultConfiguration config = new DefaultConfiguration();
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.Separator", this.getSeparatorString());
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.WriteDatarowNames", String.valueOf(this.isColumnNamesAsFirstRow()));
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.Encoding", this.getEncoding());
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.EnableGroupFooters", String.valueOf(this.isEnableGroupFooter()));
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.EnableGroupHeaders", String.valueOf(this.isEnableGroupHeader()));
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.EnableItembands", String.valueOf(this.isEnableItembands()));
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.EnableReportFooter", String.valueOf(this.isEnableReportFooter()));
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.EnableReportHeader", String.valueOf(this.isEnableReportHeader()));
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.csv.FileName", this.getFilename());
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.WriteStateColumns", "false");
        return config;
    }

    @Override
    protected void setDialogContents(Configuration config) {
        String tableCSVSeparator = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.csv.Separator", COMMA_SEPARATOR);
        this.setSeparatorString(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.Separator", tableCSVSeparator));
        String colNames = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.WriteDatarowNames", "false");
        this.setColumnNamesAsFirstRow("true".equals(colNames));
        String encoding = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.Encoding", CSV_OUTPUT_ENCODING_DEFAULT);
        this.encodingModel.ensureEncodingAvailable(encoding);
        this.setEncoding(encoding);
        String stateCols = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.WriteStateColumns", "false");
        this.setWriteStateColumns("true".equals(stateCols));
        String enableReportHeader = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.EnableReportHeader", "false");
        this.setEnableReportHeader("true".equals(enableReportHeader));
        String enableReportFooter = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.EnableReportFooter", "false");
        this.setEnableReportFooter("true".equals(enableReportFooter));
        String enableGroupHeader = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.EnableGroupHeaders", "false");
        this.setEnableGroupHeader("true".equals(enableGroupHeader));
        String enableGroupFooter = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.EnableGroupFooters", "false");
        this.setEnableGroupFooter("true".equals(enableGroupFooter));
        String enableItemBand = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.EnableItembands", "false");
        this.setEnableItembands("true".equals(enableItemBand));
        String defaultFileName = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.csv.FileName");
        if (defaultFileName != null) {
            this.setFilename(this.resolvePath(defaultFileName).getAbsolutePath());
        } else {
            this.setFilename("");
        }
    }

    public String getSeparatorString() {
        if (this.rbSeparatorColon.isSelected()) {
            return COMMA_SEPARATOR;
        }
        if (this.rbSeparatorSemicolon.isSelected()) {
            return SEMICOLON_SEPARATOR;
        }
        if (this.rbSeparatorTab.isSelected()) {
            return TAB_SEPARATOR;
        }
        if (this.rbSeparatorOther.isSelected()) {
            return this.txSeparatorOther.getText();
        }
        return "";
    }

    public void setSeparatorString(String s) {
        if (s == null) {
            this.rbSeparatorOther.setSelected(true);
            this.txSeparatorOther.setText("");
        } else if (s.equals(COMMA_SEPARATOR)) {
            this.rbSeparatorColon.setSelected(true);
        } else if (s.equals(SEMICOLON_SEPARATOR)) {
            this.rbSeparatorSemicolon.setSelected(true);
        } else if (s.equals(TAB_SEPARATOR)) {
            this.rbSeparatorTab.setSelected(true);
        } else {
            this.rbSeparatorOther.setSelected(true);
            this.txSeparatorOther.setText(s);
        }
        this.performSeparatorSelection();
    }

    public String getEncoding() {
        if (this.cbEncoding.getSelectedIndex() == -1) {
            return EncodingRegistry.getPlatformDefaultEncoding();
        }
        return this.encodingModel.getEncoding(this.cbEncoding.getSelectedIndex());
    }

    public void setEncoding(String encoding) {
        this.cbEncoding.setSelectedIndex(this.encodingModel.indexOf(encoding));
    }

    protected void performSelectFile() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            FilesystemFilter filter = new FilesystemFilter(CSV_FILE_EXTENSION, this.getResources().getString("csvexportdialog.csv-file-description"));
            this.fileChooser.addChoosableFileFilter((FileFilter)filter);
            this.fileChooser.setMultiSelectionEnabled(false);
        }
        this.fileChooser.setSelectedFile(new File(this.getFilename()));
        int option = this.fileChooser.showSaveDialog(this);
        if (option == 0) {
            File selFile = this.fileChooser.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!StringUtils.endsWithIgnoreCase((String)selFileName, (String)CSV_FILE_EXTENSION)) {
                selFileName = selFileName + CSV_FILE_EXTENSION;
            }
            this.setFilename(selFileName);
        }
    }

    @Override
    protected boolean performValidate() {
        this.getStatusBar().clear();
        String filename = this.getFilename();
        if (filename.trim().length() == 0) {
            this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("csvexportdialog.targetIsEmpty"));
            return false;
        }
        File f = new File(filename);
        if (f.exists()) {
            if (!f.isFile()) {
                this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("csvexportdialog.targetIsNoFile"));
                return false;
            }
            if (!f.canWrite()) {
                this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("csvexportdialog.targetIsNotWritable"));
                return false;
            }
            String message = MessageFormat.format(this.getResources().getString("csvexportdialog.targetExistsWarning"), filename);
            this.getStatusBar().setStatus(StatusType.WARNING, message);
        }
        if (!(this.cbxEnableGroupFooter.isSelected() || this.cbxEnableGroupHeader.isSelected() || this.cbxEnableReportFooter.isSelected() || this.cbxEnableReportHeader.isSelected() || this.cbxEnableItemband.isSelected())) {
            this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("csvexportdialog.noContentForExport"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean performConfirm() {
        File f = new File(this.getFilename());
        if (f.exists()) {
            String key1 = "csvexportdialog.targetOverwriteConfirmation";
            String key2 = "csvexportdialog.targetOverwriteTitle";
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResources().getString("csvexportdialog.targetOverwriteConfirmation"), this.getFilename()), this.getResources().getString("csvexportdialog.targetOverwriteTitle"), 0, 3) == 1) {
                return false;
            }
        }
        return true;
    }

    protected void performSeparatorSelection() {
        if (this.rbSeparatorOther.isSelected()) {
            this.txSeparatorOther.setEnabled(true);
        } else {
            this.txSeparatorOther.setEnabled(false);
        }
    }

    public boolean isColumnNamesAsFirstRow() {
        return this.cbxColumnNamesAsFirstRow.isSelected();
    }

    public void setColumnNamesAsFirstRow(boolean colsAsFirstRow) {
        this.cbxColumnNamesAsFirstRow.setSelected(colsAsFirstRow);
    }

    public boolean isWriteStateColumns() {
        return this.cbxWriteStateColumns.isSelected();
    }

    public void setWriteStateColumns(boolean writeStateColumns) {
        this.cbxWriteStateColumns.setSelected(writeStateColumns);
    }

    public boolean isEnableGroupFooter() {
        return this.cbxEnableGroupFooter.isSelected();
    }

    public void setEnableGroupFooter(boolean enableGroupFooter) {
        this.cbxEnableGroupFooter.setSelected(enableGroupFooter);
    }

    public boolean isEnableGroupHeader() {
        return this.cbxEnableGroupHeader.isSelected();
    }

    public void setEnableGroupHeader(boolean enableGroupHeader) {
        this.cbxEnableGroupHeader.setSelected(enableGroupHeader);
    }

    public boolean isEnableItembands() {
        return this.cbxEnableItemband.isSelected();
    }

    public void setEnableItembands(boolean enableItembands) {
        this.cbxEnableItemband.setSelected(enableItembands);
    }

    public boolean isEnableReportFooter() {
        return this.cbxEnableReportFooter.isSelected();
    }

    public void setEnableReportFooter(boolean enableReportFooter) {
        this.cbxEnableReportFooter.setSelected(enableReportFooter);
    }

    public boolean isEnableReportHeader() {
        return this.cbxEnableReportHeader.isSelected();
    }

    public void setEnableReportHeader(boolean enableReportHeader) {
        this.cbxEnableReportHeader.setSelected(enableReportHeader);
    }

    @Override
    protected String getConfigurationSuffix() {
        return "_csvexport";
    }

    @Override
    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.csv.";
    }

    private class ActionSelectFile
    extends AbstractAction {
        protected ActionSelectFile(ResourceBundle resources) {
            this.putValue("Name", resources.getString("csvexportdialog.selectFile"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CSVDataExportDialog.this.performSelectFile();
        }
    }

    private class ActionSelectSeparator
    extends AbstractAction {
        protected ActionSelectSeparator() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CSVDataExportDialog.this.performSeparatorSelection();
        }
    }
}

