/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.DataFactoryScriptingSupport;

public abstract class AbstractScriptableDataFactory
extends AbstractDataFactory {
    private static final Log logger = LogFactory.getLog(AbstractScriptableDataFactory.class);
    private final DataFactoryScriptingSupport scriptingSupport = new DataFactoryScriptingSupport();

    protected AbstractScriptableDataFactory() {
    }

    @Override
    public final TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        if (query == null) {
            throw new NullPointerException("Query is null.");
        }
        String realQuery = this.scriptingSupport.computeQuery(query, parameters);
        if (realQuery == null) {
            throw new ReportDataFactoryException("Query '" + query + "' is not recognized.");
        }
        return this.queryDataInternal(realQuery, parameters);
    }

    protected abstract TableModel queryDataInternal(String var1, DataRow var2) throws ReportDataFactoryException;

    @Override
    public boolean isQueryExecutable(String query, DataRow dataRow) {
        return this.scriptingSupport.containsQuery(query);
    }

    public void setQuery(String name, String queryString) {
        this.setQuery(name, queryString, null, null);
    }

    public void setQuery(String name, String queryString, String queryScriptLanguage, String queryScript) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.scriptingSupport.setQuery(name, queryString, queryScriptLanguage, queryScript);
    }

    public void remove(String name) {
        this.scriptingSupport.remove(name);
    }

    public String getGlobalScriptLanguage() {
        return this.scriptingSupport.getGlobalScriptLanguage();
    }

    public void setGlobalScriptLanguage(String scriptLanguage) {
        this.scriptingSupport.setGlobalScriptLanguage(scriptLanguage);
    }

    public String getGlobalScript() {
        return this.scriptingSupport.getGlobalScript();
    }

    public void setGlobalScript(String globalScript) {
        this.scriptingSupport.setGlobalScript(globalScript);
    }

    public String getScriptingLanguage(String name) {
        return this.scriptingSupport.getScriptingLanguage(name);
    }

    public String getScript(String name) {
        return this.scriptingSupport.getScript(name);
    }

    public String getQuery(String name) {
        return this.scriptingSupport.getQuery(name);
    }

    @Override
    public String[] getQueryNames() {
        return this.scriptingSupport.getQueryNames();
    }

    @Override
    public void initialize(DataFactoryContext dataFactoryContext) throws ReportDataFactoryException {
        super.initialize(dataFactoryContext);
        this.scriptingSupport.initialize(this, dataFactoryContext);
    }

    @Override
    public final String[] getReferencedFields(String query, DataRow parameter) {
        try {
            String[] additionalFields = this.scriptingSupport.computeAdditionalQueryFields(query, parameter);
            if (additionalFields == null) {
                return null;
            }
            String realQuery = this.scriptingSupport.computeQuery(query, parameter);
            if (realQuery == null) {
                throw new ReportDataFactoryException("Query '" + query + "' is not recognized.");
            }
            String[] referencedFieldsInternal = this.getReferencedFieldsInternal(realQuery, parameter);
            if (referencedFieldsInternal == null) {
                return null;
            }
            LinkedHashSet<String> fields = new LinkedHashSet<String>();
            fields.addAll(Arrays.asList(referencedFieldsInternal));
            fields.addAll(Arrays.asList(additionalFields));
            return fields.toArray(new String[fields.size()]);
        }
        catch (ReportDataFactoryException rx) {
            logger.debug((Object)"Failed to compute referenced fields", (Throwable)rx);
            return null;
        }
    }

    protected abstract String[] getReferencedFieldsInternal(String var1, DataRow var2) throws ReportDataFactoryException;

    @Override
    public final Object getQueryHash(String query, DataRow parameter) {
        try {
            String realQuery = this.scriptingSupport.computeQuery(query, parameter);
            if (realQuery == null) {
                throw new ReportDataFactoryException("Query '" + query + "' is not recognized.");
            }
            Object queryHashInternal = this.getQueryHashInternal(realQuery, parameter);
            if (queryHashInternal == null) {
                return null;
            }
            ArrayList<Object> queryHash = new ArrayList<Object>();
            queryHash.add(this.getClass().getName());
            queryHash.add(queryHashInternal);
            queryHash.add(this.scriptingSupport.getScriptingLanguage(query));
            queryHash.add(this.scriptingSupport.getScript(query));
            return queryHash;
        }
        catch (ReportDataFactoryException rx) {
            logger.debug((Object)"Failed to compute query hash", (Throwable)rx);
            return null;
        }
    }

    protected abstract Object getQueryHashInternal(String var1, DataRow var2) throws ReportDataFactoryException;
}

