/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.ScriptValueConverter;

public class JavascriptValueConverter
implements ScriptValueConverter {
    private static final Log logger = LogFactory.getLog(JavascriptValueConverter.class);

    @Override
    public Object convert(Object o) {
        if (o == null) {
            return null;
        }
        String classString = o.getClass().getName();
        if ("sun.org.mozilla.javascript.internal.Wrapper".equals(classString) || "sun.org.mozilla.javascript.Wrapper".equals(classString)) {
            try {
                Method unwrap = o.getClass().getMethod("unwrap", new Class[0]);
                return unwrap.invoke(o, new Object[0]);
            }
            catch (Throwable e) {
                logger.debug((Object)"Unable to call 'unwrap' on suspected javascript object.");
                return null;
            }
        }
        if ("sun.org.mozilla.javascript.internal.NativeArray".equals(classString)) {
            String scriptableClassName = "sun.org.mozilla.javascript.internal.Scriptable";
            return this.unwrapArray(o, "sun.org.mozilla.javascript.internal.Scriptable");
        }
        if ("sun.org.mozilla.javascript.NativeArray".equals(classString)) {
            String scriptableClassName = "sun.org.mozilla.javascript.Scriptable";
            return this.unwrapArray(o, "sun.org.mozilla.javascript.Scriptable");
        }
        return null;
    }

    private Object unwrapArray(Object o, String scriptableClassName) {
        try {
            Method getLength = o.getClass().getMethod("getLength", new Class[0]);
            Long length = (Long)getLength.invoke(o, new Object[0]);
            Object[] result = new Object[length.intValue()];
            Method getIds = o.getClass().getMethod("getIds", new Class[0]);
            Object[] ids = (Object[])getIds.invoke(o, new Object[0]);
            Method get = o.getClass().getMethod("get", Integer.TYPE, Class.forName(scriptableClassName));
            for (Object val : ids) {
                int index = (Integer)val;
                result[index] = get.invoke(o, index, null);
            }
            return result;
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.debug((Object)"Unable to call 'unwrap' on suspected javascript array.");
            return null;
        }
    }
}

