/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.filter.MessageFormatSupport;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.AbstractFormattedDataBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FastTextExtractor;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.CSVQuoter;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class CsvFormattedDataBuilder
extends AbstractFormattedDataBuilder {
    private HashMap<InstanceID, String> idMapping;
    private HashMap<String, Object> values;
    private final MessageFormatSupport messageFormatSupport;
    private CSVQuoter csvQuoter;
    private String encoding;
    private FastTextExtractor textExtractor;

    public CsvFormattedDataBuilder(HashMap<InstanceID, String> idMapping, MessageFormatSupport messageFormatSupport, CSVQuoter csvQuoter, String encoding) {
        this.idMapping = idMapping;
        this.messageFormatSupport = messageFormatSupport;
        this.csvQuoter = csvQuoter;
        this.encoding = encoding;
        this.values = new HashMap();
    }

    @Override
    public void compute(Band band, ExpressionRuntime runtime, OutputStream out) throws ReportProcessingException, ContentProcessingException, IOException {
        String text = this.messageFormatSupport.performFormat(this.computeData(band, runtime));
        out.write(text.getBytes(this.encoding));
    }

    protected DataRow computeData(Band band, ExpressionRuntime runtime) {
        if (!band.getComputedStyle().getBooleanStyleProperty(ElementStyleKeys.VISIBLE)) {
            return new StaticDataRow();
        }
        this.values.clear();
        this.compute(band, runtime);
        return new StaticDataRow(this.values);
    }

    @Override
    protected void inspectElement(ReportElement element) {
        String uuid = this.idMapping.get(element.getObjectID());
        if (uuid == null) {
            return;
        }
        if (!element.getComputedStyle().getBooleanStyleProperty(ElementStyleKeys.VISIBLE)) {
            return;
        }
        if (this.textExtractor == null) {
            this.textExtractor = new FastTextExtractor();
        }
        try {
            this.textExtractor.compute(element, this.getRuntime());
            String text = this.textExtractor.getText();
            if (!StringUtils.isEmpty((String)text)) {
                this.values.put(uuid, this.csvQuoter.doQuoting(text));
            }
        }
        catch (ContentProcessingException rse) {
            throw new InvalidReportStateException(rse);
        }
    }
}

