/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.xls;

import java.awt.Image;
import java.awt.Shape;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.DefaultImageReference;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.model.PhysicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.CellLayoutInfo;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FastSheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.SheetPropertyCollector;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.xls.FastExcelCellStyleProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.xls.FastExcelTextExtractor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackground;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableRectangle;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.CellStyleProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelPrinterBase;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.RotatedTextDrawable;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class FastExcelPrinter
extends ExcelPrinterBase {
    private static final Log logger = LogFactory.getLog(FastExcelPrinter.class);
    private Workbook workbook;
    private Sheet sheet;
    private PageDefinition pageDefinition;
    private int rowOffset;
    private long rowHeightOffset;
    private FastExcelTextExtractor textExtractor;
    private FastSheetLayout sheetLayout;
    private long[] cellHeights;

    public FastExcelPrinter(SheetLayout sheetLayout) {
        this.sheetLayout = new FastSheetLayout(sheetLayout);
    }

    public void init(OutputProcessorMetaData metaData, ResourceManager resourceManager, ReportDefinition report) {
        this.pageDefinition = report.getPageDefinition();
        super.init(metaData, resourceManager);
        this.workbook = this.createWorkbook();
        this.initializeStyleProducers(this.workbook);
        this.textExtractor = new FastExcelTextExtractor(this.getColorProducer(), this.getCellStyleProducer().getFontFactory(), this.workbook.getCreationHelper());
    }

    @Override
    protected Sheet getSheet() {
        return this.sheet;
    }

    @Override
    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void startSection(Band band, long[] cellHeights) {
        this.cellHeights = cellHeights;
        this.sheetLayout.reinit(this.rowHeightOffset, cellHeights);
        if (band.getComputedStyle().getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE)) {
            this.closeSheet();
        }
        if (cellHeights.length > 0 && this.sheet == null) {
            SheetPropertyCollector collector = new SheetPropertyCollector();
            String sheetName = collector.compute(band);
            this.sheet = this.openSheet(sheetName);
            this.configureSheetColumnWidths(this.sheet, this.sheetLayout, this.sheetLayout.getColumnCount());
            this.configureSheetPaperSize(this.sheet, new PhysicalPageBox(this.pageDefinition.getPageFormat(0), 0L, 0L));
            this.configureSheetProperties(this.sheet, collector);
            this.rowOffset = 0;
        }
        for (int r = 0; r < cellHeights.length; ++r) {
            this.getRowAt(r + this.rowOffset).setHeightInPoints((float)StrictGeomUtility.toExternalValue(cellHeights[r]));
        }
    }

    public void endSection(Band band, ArrayList<CellLayoutInfo> backgroundCells) {
        for (CellLayoutInfo layoutInfo : backgroundCells) {
            int col = layoutInfo.getX1();
            int row = layoutInfo.getY1() + this.rowOffset;
            Cell cell = this.getCellAt(col, row);
            CellStyle style = this.getCellStyleProducer().createCellStyle(null, null, layoutInfo.getBackground());
            if (style == null) continue;
            cell.setCellStyle(style);
        }
        if (band.getComputedStyle().getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER)) {
            this.closeSheet();
        }
        this.rowOffset += this.cellHeights.length;
        for (int i = 0; i < this.cellHeights.length; ++i) {
            this.rowHeightOffset += this.cellHeights[i];
        }
    }

    @Override
    protected CellStyleProducer createCellStyleProducer(Workbook workbook) {
        return new FastExcelCellStyleProducer(super.createCellStyleProducer(workbook));
    }

    public void closeSheet() {
        this.sheet = null;
    }

    public void print(CellLayoutInfo tableRectangle, ReportElement element, ExpressionRuntime runtime) throws ContentProcessingException {
        TableRectangle rect = new TableRectangle();
        rect.setRect(tableRectangle.getX1(), tableRectangle.getY1() + this.rowOffset, tableRectangle.getX2(), tableRectangle.getY2() + this.rowOffset);
        Cell cellAt = this.getCellAt(rect.getX1(), rect.getY1());
        CellBackground bg = tableRectangle.getBackground();
        CellStyle cellStyle = this.getCellStyleProducer().createCellStyle(element.getObjectID(), element.getComputedStyle(), bg);
        if (cellStyle != null) {
            cellAt.setCellStyle(cellStyle);
        }
        if (this.applyCellValue(element, cellAt, rect, runtime)) {
            this.mergeCellRegion(rect, cellStyle);
        }
    }

    private void mergeCellRegion(TableRectangle rectangle, CellStyle spannedStyle) {
        int rowSpan = rectangle.getRowSpan();
        int columnSpan = rectangle.getColumnSpan();
        if (rowSpan <= 1 && columnSpan <= 1) {
            return;
        }
        int row = rectangle.getY1();
        int col = rectangle.getX1();
        this.sheet.addMergedRegion(new CellRangeAddress(row, row + rowSpan - 1, col, col + columnSpan - 1));
        for (int spannedRow = 0; spannedRow < rowSpan; ++spannedRow) {
            for (int spannedCol = 0; spannedCol < columnSpan; ++spannedCol) {
                Cell regionCell = this.getCellAt(col + spannedCol, row + spannedRow);
                if (spannedStyle == null) continue;
                regionCell.setCellStyle(spannedStyle);
            }
        }
    }

    private boolean applyCellValue(ReportElement content, Cell cell, TableRectangle rectangle, ExpressionRuntime runtime) throws ContentProcessingException {
        Object attr1;
        Object value = this.textExtractor.compute(content, runtime);
        if (this.handleImageValues(content, rectangle, value)) {
            return false;
        }
        String linkTarget = (String)content.getComputedStyle().getStyleProperty(ElementStyleKeys.HREF_TARGET);
        if (linkTarget != null) {
            RotatedTextDrawable extracted = RotatedTextDrawable.extract(value);
            String linkText = extracted == null ? this.textExtractor.getText() : extracted.getText();
            String formula = "HYPERLINK(" + FastExcelPrinter.splitAndQuoteExcelFormula(linkTarget) + "," + FastExcelPrinter.splitAndQuoteExcelFormula(linkText) + ")";
            if (formula.length() < 1024) {
                cell.setCellFormula(formula);
                return true;
            }
            logger.warn((Object)"Excel-Cells cannot contain formulas longer than 1023 characters. Converting hyperlink into plain text");
        }
        if ((attr1 = content.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/excel", "formula")) != null) {
            String formula = String.valueOf(attr1);
            if (formula.length() < 1024) {
                cell.setCellFormula(formula);
                return true;
            }
            logger.warn((Object)"Excel-Cells cannot contain formulas longer than 1023 characters. Converting excel formula into plain text");
        }
        this.handleValueType(cell, this.getValueIfVisible(content, value), this.workbook);
        return true;
    }

    protected Object getValueIfVisible(ReportElement content, Object value) {
        if (content instanceof Element) {
            SimpleStyleSheet style = ((Element)content).getComputedStyle();
            Boolean visible = (Boolean)style.getStyleProperty(ElementStyleKeys.VISIBLE, Boolean.TRUE);
            return visible != false ? value : null;
        }
        return value;
    }

    private boolean handleImageValues(ReportElement content, TableRectangle rectangle, Object value) {
        SimpleStyleSheet rawSource = content.getComputedStyle();
        if (RotatedTextDrawable.extract(value) != null) {
            return false;
        }
        if (value instanceof Image) {
            try {
                StrictBounds contentBounds = this.sheetLayout.getBounds(rectangle);
                DefaultImageReference imageContainer = new DefaultImageReference((Image)value);
                this.createImageCell(rawSource, imageContainer, this.sheetLayout, rectangle, contentBounds);
            }
            catch (IOException ioe) {
                logger.warn((Object)"Failed to process AWT-Image in Excel-Export", (Throwable)ioe);
            }
            return true;
        }
        if (value instanceof ImageContainer) {
            ImageContainer imageContainer = (ImageContainer)value;
            StrictBounds contentBounds = this.sheetLayout.getBounds(rectangle);
            this.createImageCell(rawSource, imageContainer, this.sheetLayout, rectangle, contentBounds);
            return true;
        }
        if (value instanceof DrawableWrapper) {
            DrawableWrapper drawable = (DrawableWrapper)value;
            StrictBounds contentBounds = this.sheetLayout.getBounds(rectangle);
            DefaultImageReference imageFromDrawable = RenderUtility.createImageFromDrawable(drawable, contentBounds, content.getComputedStyle(), this.getMetaData());
            this.createImageCell(rawSource, imageFromDrawable, this.sheetLayout, rectangle, contentBounds);
            return true;
        }
        return value instanceof Shape;
    }

    public void closeWorkbook(OutputStream outputStream) throws IOException {
        this.workbook.write(outputStream);
    }
}

