/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal;

import org.pentaho.reporting.engine.classic.core.layout.output.AbstractOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ExtendedConfigurationWrapper;
import org.pentaho.reporting.libraries.fonts.awt.AWTFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontStorage;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public class GraphicsOutputProcessorMetaData
extends AbstractOutputProcessorMetaData {
    public GraphicsOutputProcessorMetaData() {
        this((FontStorage)new DefaultFontStorage((FontRegistry)new AWTFontRegistry()));
    }

    public GraphicsOutputProcessorMetaData(FontStorage storage) {
        super(storage);
    }

    @Override
    public void initialize(Configuration configuration) {
        ExtendedConfigurationWrapper extendedConfig;
        double deviceResolution;
        super.initialize(configuration);
        this.addFeature(OutputProcessorFeature.FAST_FONTRENDERING);
        this.addFeature(OutputProcessorFeature.BACKGROUND_IMAGE);
        this.addFeature(OutputProcessorFeature.PAGE_SECTIONS);
        this.addFeature(OutputProcessorFeature.PAGEBREAKS);
        this.addFeature(OutputProcessorFeature.SPACING_SUPPORTED);
        this.addFeature(OutputProcessorFeature.DIRECT_RICHTEXT_RENDERING);
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.WatermarkPrinted"))) {
            this.addFeature(OutputProcessorFeature.WATERMARK_SECTION);
        }
        if ((deviceResolution = (double)(extendedConfig = new ExtendedConfigurationWrapper(configuration)).getIntProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.DeviceResolution", 0)) > 0.0) {
            this.setNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION, deviceResolution);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.AssumeOverflowX"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_X);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.AssumeOverflowY"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_Y);
        }
        if (this.isFeatureSupported(OutputProcessorFeature.COMPLEX_TEXT)) {
            this.addFeature(OutputProcessorFeature.STRICT_TEXT_PROCESSING);
        }
    }

    @Override
    public String getExportDescriptor() {
        return "pageable/X-AWT-Graphics";
    }
}

