/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.base.common;

import java.beans.IntrospectionException;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.MetaDataLookupException;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.ExpressionPropertyReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.UserDefinedExpressionPropertyReadHandler;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.SAXException;

public class ExpressionPropertiesReadHandler
extends AbstractPropertyXmlReadHandler {
    private BeanUtility beanUtility;
    private Expression expression;
    private String originalExpressionClass;
    private String expressionClass;

    public ExpressionPropertiesReadHandler(Expression expression, String originalExpressionClass, String expressionClass) throws IntrospectionException {
        this.originalExpressionClass = originalExpressionClass;
        this.expressionClass = expressionClass;
        this.beanUtility = new BeanUtility(expression);
        this.expression = expression;
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes attrs) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("property".equals(tagName)) {
            String propertyName = attrs.getValue(this.getUri(), "name");
            return this.createReadHandler(propertyName);
        }
        return null;
    }

    private XmlReadHandler createReadHandler(String propertyName) throws ParseException {
        try {
            Class<? extends UserDefinedExpressionPropertyReadHandler> propertyReadHandler;
            ExpressionMetaData expressionMetaData = ExpressionRegistry.getInstance().getExpressionMetaData(this.expressionClass);
            ExpressionPropertyMetaData propertyDescription = expressionMetaData.getPropertyDescription(propertyName);
            if (propertyDescription != null && (propertyReadHandler = propertyDescription.getPropertyReadHandler()) != null) {
                UserDefinedExpressionPropertyReadHandler xmlReadHandler = propertyReadHandler.newInstance();
                xmlReadHandler.init(this.beanUtility, this.originalExpressionClass, this.expressionClass, this.expression.getName());
                return xmlReadHandler;
            }
            return new ExpressionPropertyReadHandler(this.beanUtility, this.originalExpressionClass, this.expressionClass, this.expression.getName());
        }
        catch (MetaDataLookupException e) {
            return new ExpressionPropertyReadHandler(this.beanUtility, this.originalExpressionClass, this.expressionClass, this.expression.getName());
        }
        catch (Exception e) {
            throw new ParseException("Unable to read metadata for property '" + propertyName + "'.", this.getLocator());
        }
    }

    public Object getObject() {
        return this;
    }
}

