/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements;

import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.CrosstabCell;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabHeader;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.CrosstabColumnGroupType;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.AbstractElementReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.CrosstabCellBodyReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.CrosstabColumnSubGroupBodyReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.CrosstabHeaderBandReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.CrosstabSummaryHeaderBandReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.CrosstabTitleHeaderBandReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.DataGroupBodyReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.GroupHeaderReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.StringReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CrosstabColumnGroupReadHandler
extends AbstractElementReadHandler {
    private CrosstabHeaderBandReadHandler headerReadHandler;
    private CrosstabSummaryHeaderBandReadHandler summaryHeaderBandReadHandler;
    private CrosstabTitleHeaderBandReadHandler titleHeaderBandReadHandler;
    private CrosstabColumnSubGroupBodyReadHandler columnSubGroupBodyReadHandler;
    private DataGroupBodyReadHandler groupBodyReadHandler;
    private CrosstabCellBodyReadHandler cellBodyReadHandler;
    private GroupHeaderReadHandler legacyHeaderReadHandler;
    private StringReadHandler fieldReadHandler;

    public CrosstabColumnGroupReadHandler() throws ParseException {
        super(CrosstabColumnGroupType.INSTANCE);
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if ("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0".equals(uri)) {
            if ("crosstab-header".equals(tagName)) {
                if (this.headerReadHandler == null) {
                    this.headerReadHandler = new CrosstabHeaderBandReadHandler();
                }
                return this.headerReadHandler;
            }
            if ("group-header".equals(tagName)) {
                if (this.legacyHeaderReadHandler == null) {
                    this.legacyHeaderReadHandler = new GroupHeaderReadHandler();
                }
                return this.legacyHeaderReadHandler;
            }
            if ("field".equals(tagName)) {
                if (this.fieldReadHandler == null) {
                    this.fieldReadHandler = new StringReadHandler();
                }
                return this.fieldReadHandler;
            }
            if ("crosstab-title-header".equals(tagName)) {
                if (this.titleHeaderBandReadHandler == null) {
                    this.titleHeaderBandReadHandler = new CrosstabTitleHeaderBandReadHandler();
                }
                return this.titleHeaderBandReadHandler;
            }
            if ("crosstab-summary-header".equals(tagName)) {
                if (this.summaryHeaderBandReadHandler == null) {
                    this.summaryHeaderBandReadHandler = new CrosstabSummaryHeaderBandReadHandler();
                }
                return this.summaryHeaderBandReadHandler;
            }
            if ("crosstab-column-group-body".equals(tagName)) {
                this.columnSubGroupBodyReadHandler = new CrosstabColumnSubGroupBodyReadHandler();
                return this.columnSubGroupBodyReadHandler;
            }
            if ("data-body".equals(tagName)) {
                this.groupBodyReadHandler = new DataGroupBodyReadHandler();
                return this.groupBodyReadHandler;
            }
            if ("crosstab-cell-body".equals(tagName)) {
                this.cellBodyReadHandler = new CrosstabCellBodyReadHandler();
                return this.cellBodyReadHandler;
            }
            if ("crosstab-title-footer".equals(tagName) || "crosstab-summary-footer".equals(tagName) || "group-footer".equals(tagName)) {
                return new IgnoreAnyChildReadHandler();
            }
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    @Override
    protected void doneParsing() throws SAXException {
        super.doneParsing();
        CrosstabColumnGroup group = this.getElement();
        if (this.fieldReadHandler != null) {
            group.setField(this.fieldReadHandler.getResult());
        }
        if (this.headerReadHandler != null) {
            group.setHeader(this.headerReadHandler.getElement());
        } else if (this.legacyHeaderReadHandler != null) {
            CrosstabHeader header = new CrosstabHeader();
            this.legacyHeaderReadHandler.getElement().copyInto(header);
            header.addElements(Arrays.asList(this.legacyHeaderReadHandler.getElement().getElementArray()));
            group.setHeader(header);
        }
        if (this.summaryHeaderBandReadHandler != null) {
            group.setSummaryHeader(this.summaryHeaderBandReadHandler.getElement());
        }
        if (this.titleHeaderBandReadHandler != null) {
            group.setTitleHeader(this.titleHeaderBandReadHandler.getElement());
        }
        if (this.columnSubGroupBodyReadHandler != null) {
            group.setBody(this.columnSubGroupBodyReadHandler.getElement());
        } else if (this.cellBodyReadHandler != null) {
            group.setBody(this.cellBodyReadHandler.getElement());
        } else {
            GroupDataBody element = this.groupBodyReadHandler.getElement();
            ItemBand itemBand = element.getItemBand();
            CrosstabCell cell = new CrosstabCell();
            itemBand.copyInto(cell);
            cell.addElements(Arrays.asList(itemBand.getElementArray()));
            CrosstabCellBody body = new CrosstabCellBody();
            body.addElement(cell);
            group.setBody(body);
        }
    }

    @Override
    public CrosstabColumnGroup getElement() {
        return (CrosstabColumnGroup)super.getElement();
    }
}

