/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.parameters;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.parameters.FormulaParameterEvaluator;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterExpressionRuntime;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public abstract class AbstractParameter
implements ParameterDefinitionEntry {
    private static final Log logger = LogFactory.getLog(AbstractParameter.class);
    private String name;
    private ReportAttributeMap attributeMap;
    private boolean mandatory;
    private Class valueType;
    private Object defaultValue;

    protected AbstractParameter(String name) {
        this(name, String.class);
    }

    protected AbstractParameter(String name, Class valueType) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (valueType == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.valueType = valueType;
        this.attributeMap = new ReportAttributeMap();
        this.setRole("user");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setParameterAttribute(String domain, String name, String value) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.attributeMap.setAttribute(domain, name, value);
    }

    public String getParameterAttribute(String domain, String name) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        return (String)this.attributeMap.getAttribute(domain, name);
    }

    @Override
    public String getParameterAttribute(String domain, String name, ParameterContext parameterContext) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        return (String)this.attributeMap.getAttribute(domain, name);
    }

    @Override
    public String[] getParameterAttributeNamespaces() {
        return this.attributeMap.getNameSpaces();
    }

    @Override
    public String[] getParameterAttributeNames(String domain) {
        if (domain == null) {
            throw new NullPointerException();
        }
        return this.attributeMap.getNames(domain);
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    @Override
    public Class getValueType() {
        return this.valueType;
    }

    public void setValueType(Class valueType) {
        if (valueType == null) {
            throw new NullPointerException();
        }
        this.valueType = valueType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object getDefaultValue(ParameterContext context) throws ReportDataFactoryException {
        String formula = (String)this.attributeMap.getAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "default-value-formula");
        if (!StringUtils.isEmpty((String)formula, (boolean)false)) {
            try {
                Object defaultValue = FormulaParameterEvaluator.computeValue(new ParameterExpressionRuntime(context, context.getParameterData()), formula, null, this, this.defaultValue);
                if (defaultValue != null) {
                    return defaultValue;
                }
            }
            catch (ReportProcessingException e) {
                logger.debug((Object)("Unable to compute default value for parameter '" + this.name + '\"'), (Throwable)e);
            }
        }
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractParameter o = (AbstractParameter)super.clone();
        o.attributeMap = this.attributeMap.clone();
        return o;
    }

    public boolean isHidden() {
        return "true".equals(this.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "hidden"));
    }

    public void setHidden(boolean hidden) {
        this.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "hidden", String.valueOf(hidden));
    }

    public boolean isDeprecated() {
        return "true".equals(this.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "deprecated"));
    }

    public void setDeprecated(boolean deprecated) {
        this.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "deprecated", String.valueOf(deprecated));
    }

    public String getRole() {
        return this.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "role");
    }

    public void setRole(String role) {
        this.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "role", role);
    }
}

