/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.parameters;

import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ReportEnvironmentDataRow;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.cache.CachingDataFactory;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DesignTimeDataFactoryContext;
import org.pentaho.reporting.engine.classic.core.parameters.CompoundDataRow;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.states.PerformanceMonitorContext;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultParameterContext
implements ParameterContext {
    private ReportEnvironment reportEnvironment;
    private CompoundDataRow parameterValues;
    private ResourceBundleFactory resourceBundleFactory;
    private Configuration configuration;
    private CachingDataFactory dataFactory;
    private ResourceKey contentBase;
    private ResourceManager resourceManager;
    private DocumentMetaData documentMetaData;
    private ReportEnvironmentDataRow envDataRow;

    public DefaultParameterContext(MasterReport report) throws ReportProcessingException {
        this(report, report.getParameterValues());
    }

    public DefaultParameterContext(MasterReport report, ReportParameterValues parameterValues) throws ReportProcessingException {
        if (report == null) {
            throw new NullPointerException("Report parameter must not be null");
        }
        if (parameterValues == null) {
            throw new NullPointerException("ParameterValues parameter must not be null");
        }
        this.configuration = report.getConfiguration();
        this.resourceBundleFactory = MasterReport.computeAndInitResourceBundleFactory(report.getResourceBundleFactory(), report.getReportEnvironment());
        this.contentBase = report.getContentBase();
        this.resourceManager = report.getResourceManager();
        this.reportEnvironment = report.getReportEnvironment();
        Object dataCacheEnabledRaw = report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "data-cache");
        boolean dataCacheEnabled = !Boolean.FALSE.equals(dataCacheEnabledRaw);
        this.dataFactory = new CachingDataFactory(report.getDataFactory(), dataCacheEnabled);
        DocumentBundle bundle = report.getBundle();
        if (bundle != null) {
            this.documentMetaData = bundle.getMetaData();
        }
        this.dataFactory.initialize(new DesignTimeDataFactoryContext(this.configuration, this.resourceManager, this.contentBase, this.resourceBundleFactory, this.dataFactory));
        ReportEnvironmentDataRow envDataRow = new ReportEnvironmentDataRow(this.reportEnvironment);
        this.parameterValues = new CompoundDataRow(envDataRow, parameterValues);
    }

    public DefaultParameterContext(DataFactory dataFactory, DataRow parameterValues, Configuration configuration, ResourceBundleFactory resourceBundleFactory, ResourceManager resourceManager, ResourceKey resourceKey, ReportEnvironment reportEnvironment) throws ReportDataFactoryException {
        this.configuration = configuration;
        this.resourceBundleFactory = resourceBundleFactory;
        this.resourceManager = resourceManager;
        this.contentBase = resourceKey;
        this.reportEnvironment = reportEnvironment;
        this.dataFactory = new CachingDataFactory(dataFactory, false);
        this.dataFactory.initialize(new DesignTimeDataFactoryContext(configuration, resourceManager, resourceKey, resourceBundleFactory, dataFactory));
        this.envDataRow = new ReportEnvironmentDataRow(reportEnvironment);
        this.parameterValues = new CompoundDataRow(this.envDataRow, parameterValues);
    }

    @Override
    public DocumentMetaData getDocumentMetaData() {
        return this.documentMetaData;
    }

    @Override
    public ReportEnvironment getReportEnvironment() {
        return this.reportEnvironment;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public DataRow getParameterData() {
        return this.parameterValues;
    }

    public DataRow getParameterValues() {
        return this.parameterValues.getDataRow();
    }

    public void setParameterValues(DataRow parameterValues) {
        if (parameterValues == null) {
            throw new NullPointerException();
        }
        this.parameterValues = new CompoundDataRow(this.envDataRow, parameterValues);
    }

    @Override
    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    @Override
    public ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    @Override
    public void close() throws ReportDataFactoryException {
        this.dataFactory.close();
    }

    @Override
    public ResourceKey getContentBase() {
        return this.contentBase;
    }

    @Override
    public PerformanceMonitorContext getPerformanceMonitorContext() {
        return (PerformanceMonitorContext)ClassicEngineBoot.getInstance().getObjectFactory().get(PerformanceMonitorContext.class);
    }
}

