/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.parameters;

import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterValues;

public class DefaultParameterValues
implements ParameterValues {
    private TableModel parent;
    private int keyColumnIdx;
    private int valueColumnIdx;
    private String keyColumn;
    private String valueColumn;

    public DefaultParameterValues(TableModel parent, String keyColumn, String valueColumn) {
        if (parent == null) {
            throw new NullPointerException();
        }
        if (keyColumn == null) {
            throw new NullPointerException();
        }
        if (valueColumn == null) {
            throw new NullPointerException();
        }
        this.keyColumn = keyColumn;
        this.valueColumn = valueColumn;
        this.parent = parent;
        int colCount = parent.getColumnCount();
        this.keyColumnIdx = -1;
        this.valueColumnIdx = -1;
        for (int i = 0; i < colCount; ++i) {
            String colName = parent.getColumnName(i);
            if (colName.equals(keyColumn)) {
                this.keyColumnIdx = i;
            }
            if (!colName.equals(valueColumn)) continue;
            this.valueColumnIdx = i;
        }
        if (this.keyColumnIdx == -1) {
            throw new IllegalArgumentException("Unable to locate the key column in the dataset.");
        }
        if (this.valueColumnIdx == -1) {
            throw new IllegalArgumentException("Unable to locate the value column in the dataset.");
        }
    }

    public String getValueColumn() {
        return this.valueColumn;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    @Override
    public int getRowCount() {
        return this.parent.getRowCount();
    }

    @Override
    public Object getKeyValue(int row) {
        return this.parent.getValueAt(row, this.keyColumnIdx);
    }

    @Override
    public Object getTextValue(int row) {
        return this.parent.getValueAt(row, this.valueColumnIdx);
    }
}

