/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style.css;

import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.style.css.FixNamespaceConditionFactory;
import org.pentaho.reporting.engine.classic.core.style.css.FixNamespaceSelectorFactory;
import org.pentaho.reporting.engine.classic.core.style.css.namespaces.NamespaceCollection;
import org.pentaho.reporting.engine.classic.core.style.css.selector.CSSSelectorFactory;
import org.pentaho.reporting.engine.classic.core.style.css.selector.conditions.CSSConditionFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.helpers.ParserFactory;

public class CSSParserFactory {
    private static CSSParserFactory parserFactory;

    public static synchronized CSSParserFactory getInstance() {
        if (parserFactory == null) {
            parserFactory = new CSSParserFactory();
        }
        return parserFactory;
    }

    private CSSParserFactory() {
    }

    public Parser createCSSParser(NamespaceCollection namespaceCollection) throws InstantiationException {
        Parser p;
        Configuration config = ClassicEngineBoot.getInstance().getGlobalConfig();
        String parserClass = config.getConfigProperty("org.w3c.css.sac.Parser");
        if (parserClass != null && (p = (Parser)ObjectUtilities.loadAndInstantiate((String)parserClass, CSSParserFactory.class, Parser.class)) != null) {
            p.setConditionFactory((ConditionFactory)new FixNamespaceConditionFactory(new CSSConditionFactory(), namespaceCollection));
            p.setSelectorFactory((SelectorFactory)new FixNamespaceSelectorFactory(new CSSSelectorFactory(), namespaceCollection));
            return p;
        }
        try {
            p = new ParserFactory().makeParser();
            if (p == null) {
                return null;
            }
            p.setConditionFactory((ConditionFactory)new FixNamespaceConditionFactory(new CSSConditionFactory(), namespaceCollection));
            p.setSelectorFactory((SelectorFactory)new FixNamespaceSelectorFactory(new CSSSelectorFactory(), namespaceCollection));
            return p;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InstantiationException(e.getMessage());
        }
    }
}

