/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style.css.selector.conditions;

import org.pentaho.reporting.engine.classic.core.style.css.namespaces.NamespaceCollection;
import org.pentaho.reporting.engine.classic.core.style.css.namespaces.NamespaceDefinition;
import org.pentaho.reporting.engine.classic.core.style.css.selector.conditions.CSSCondition;
import org.w3c.css.sac.AttributeCondition;

public class AttributeCSSCondition
implements AttributeCondition,
CSSCondition {
    private String name;
    private String namespace;
    private boolean specified;
    private String value;

    public AttributeCSSCondition(String name, String namespace, boolean specified, String value) {
        this.name = name;
        this.namespace = namespace;
        this.specified = specified;
        this.value = value;
    }

    public short getConditionType() {
        return 4;
    }

    public String getNamespaceURI() {
        return this.namespace;
    }

    public String getLocalName() {
        return this.name;
    }

    public final boolean getSpecified() {
        return this.isSpecified();
    }

    public boolean isSpecified() {
        return this.specified;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String print(NamespaceCollection namespaces) {
        StringBuilder b = new StringBuilder();
        b.append("[");
        if (this.namespace != null) {
            if ("*".equals(this.namespace)) {
                b.append("*|");
            } else if ("".equals(this.namespace)) {
                b.append("|");
            } else {
                NamespaceDefinition definition = namespaces.getDefinition(this.namespace);
                if (definition == null) {
                    b.append("\"");
                    b.append(this.namespace);
                    b.append("\"");
                    b.append("|");
                } else {
                    b.append(definition.getPrefix());
                    b.append("|");
                }
            }
        }
        b.append(this.name);
        if (this.value != null) {
            b.append(this.getSelectorIndicator());
            b.append(this.quoteValue(this.value));
        }
        b.append("]");
        return b.toString();
    }

    private String quoteValue(String raw) {
        StringBuilder b = new StringBuilder();
        b.append('\"');
        char[] chars = raw.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\n') {
                b.append('\\');
                b.append('n');
                continue;
            }
            if (c == '\r') {
                b.append('\\');
                b.append('r');
                continue;
            }
            if (c == '\t') {
                b.append('\\');
                b.append('t');
                continue;
            }
            if (c == '\"') {
                b.append('\\');
            }
            if (c == '\\') {
                b.append('\\');
            }
            b.append(c);
        }
        b.append('\"');
        return b.toString();
    }

    protected String getSelectorIndicator() {
        return "=";
    }
}

