/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.pms.mql.ExtendedMetaData;
import org.pentaho.pms.mql.Query;
import org.pentaho.pms.mql.Selection;

public class MappedQuery
implements Query {
    protected String query;
    protected Map columnsMap;
    protected List<? extends Selection> selections;

    public MappedQuery(String sql, Map columnsMap, List<? extends Selection> selections) {
        this.query = sql;
        this.selections = selections;
        this.columnsMap = columnsMap;
    }

    public String getDisplayQuery() {
        String execQuery = new String(this.query);
        for (String element : this.columnsMap.keySet()) {
            String identifier = (String)this.columnsMap.get(element);
            execQuery = this.wholeWordReplaceAll(execQuery, element, identifier);
        }
        return execQuery;
    }

    private String wholeWordReplaceAll(String source, String search, String repl) {
        Pattern p = Pattern.compile("(\\W)" + search + "(\\W)");
        Matcher m = p.matcher(source);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, m.group(1) + repl + m.group(2));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public Map getMap() {
        return this.columnsMap;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public IPentahoMetaData generateMetadata(IPentahoMetaData nativeMetadata) {
        return new ExtendedMetaData(this.columnsMap, nativeMetadata.getColumnHeaders(), nativeMetadata.getRowHeaders(), this.selections);
    }
}

