/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql.graph;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.pms.mql.graph.Arc;
import org.pentaho.pms.mql.graph.ConsistencyException;
import org.pentaho.pms.mql.graph.GraphElement;
import org.pentaho.pms.mql.graph.GraphElementChangeListener;
import org.pentaho.pms.mql.graph.GraphElementDomain;
import org.pentaho.pms.mql.graph.GraphElementRequirement;
import org.pentaho.pms.schema.BusinessTable;

public class Node
implements GraphElement,
Comparable {
    private static final Log logger = LogFactory.getLog(Node.class);
    private int id;
    private BusinessTable table;
    private GraphElementChangeListener listener;
    private GraphElementDomain domain;
    private List<Arc> arcs;
    private List<Arc> requiredArcs;
    private boolean queued;

    public Node(int id, BusinessTable table, GraphElementChangeListener listener) {
        this.id = id;
        this.table = table;
        this.listener = listener;
        this.domain = new GraphElementDomain(this);
        this.arcs = new ArrayList<Arc>();
    }

    @Override
    public boolean isRequired() {
        return this.domain.getRequirement() == GraphElementRequirement.REQUIRED;
    }

    @Override
    public boolean isNotRequired() {
        return this.domain.getRequirement() == GraphElementRequirement.NOT_REQUIRED;
    }

    @Override
    public boolean isRequirementKnown() {
        return this.domain.getRequirement() != GraphElementRequirement.UNKNOWN;
    }

    public BusinessTable getTable() {
        return this.table;
    }

    @Override
    public boolean isQueued() {
        return this.queued;
    }

    @Override
    public void setQueued(boolean queued) {
        this.queued = queued;
    }

    public void addArc(Arc arc) {
        this.arcs.add(arc);
    }

    public void addRequiredArc(Arc arc) {
        if (this.requiredArcs == null) {
            this.requiredArcs = new LinkedList<Arc>();
        }
        this.requiredArcs.add(arc);
    }

    public int compareTo(Object o) {
        Node n = (Node)o;
        boolean thisKnown = this.isRequirementKnown();
        boolean nKnown = n.isRequirementKnown();
        if (thisKnown && !nKnown) {
            return -1;
        }
        if (!thisKnown && nKnown) {
            return 1;
        }
        return (this.arcs.size() - n.arcs.size()) * (thisKnown ? -1 : 1);
    }

    public List<Arc> getArcs() {
        return this.arcs;
    }

    @Override
    public void setRequirement(boolean required) throws ConsistencyException {
        if (this.domain.setRequirement(required)) {
            if (required) {
                if (this.requiredArcs != null) {
                    for (Arc arc : this.requiredArcs) {
                        arc.setRequirement(true);
                    }
                }
                Arc requiredArc = null;
                for (Arc arc : this.arcs) {
                    if (arc.isNotRequired()) continue;
                    if (requiredArc == null) {
                        requiredArc = arc;
                        continue;
                    }
                    requiredArc = null;
                    break;
                }
                if (requiredArc != null) {
                    requiredArc.setRequirement(true);
                }
            } else {
                for (Arc arc : this.arcs) {
                    arc.setRequirement(false);
                }
            }
            this.listener.graphElementChanged(this);
        }
    }

    @Override
    public void clearRequirement() {
        this.domain.clearRequirement();
    }

    public boolean prune() throws ConsistencyException {
        boolean prune = false;
        if (this.arcs.size() == 0) {
            prune = true;
        } else if (this.domain.getRequirement() == GraphElementRequirement.UNKNOWN) {
            if (this.arcs.size() == 1) {
                prune = true;
            } else {
                int possiblePaths = 0;
                for (Arc arc : this.arcs) {
                    if (arc.isRequired()) {
                        this.setRequirement(true);
                        return false;
                    }
                    if (!arc.isNotRequired()) {
                        ++possiblePaths;
                    }
                    if (possiblePaths <= 1) continue;
                    break;
                }
                if (possiblePaths < 2) {
                    prune = true;
                }
            }
        }
        if (prune) {
            this.setRequirement(false);
        }
        return prune;
    }

    public boolean canReachNode(Node target, Arc avoidArc) {
        LinkedList<Node> visitedList = new LinkedList<Node>();
        return this.doTargetSearch(this, null, target, visitedList, avoidArc);
    }

    public boolean canReachAllNodes(List<Node> targetList) {
        LinkedList<Node> visitedList = new LinkedList<Node>();
        return this.doTargetSearch(this, targetList, null, visitedList, null);
    }

    private boolean doTargetSearch(Node current, List<Node> targetList, Node target, List<Node> visitedList, Arc avoidArc) {
        visitedList.add(current);
        for (Arc arc : current.getArcs()) {
            Node next;
            if (arc == avoidArc || arc.isNotRequired()) continue;
            Node left = arc.getLeft();
            Node right = arc.getRight();
            Node node = next = left == current ? right : left;
            if (target != null && next == target) {
                return true;
            }
            if (targetList.remove(next) && targetList.size() == 0) {
                return true;
            }
            if (visitedList.contains(next) || !this.doTargetSearch(next, targetList, target, visitedList, avoidArc)) continue;
            return true;
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Node[" + this.id + "]: Table ");
        if (this.table != null && this.table.getPhysicalTable() != null) {
            buff.append(this.table.getPhysicalTable().getDisplayName(""));
        } else if (this.table != null) {
            buff.append(this.table.getDisplayName(""));
        } else {
            buff.append("*null*");
        }
        return buff.toString();
    }
}

